/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.automaton;

import java.util.HashMap;
import java.util.Iterator;
import spinja.promela.compiler.actions.Action;
import spinja.promela.compiler.actions.ExprAction;
import spinja.promela.compiler.actions.Sequence;
import spinja.promela.compiler.automaton.State;
import spinja.promela.compiler.automaton.Transition;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.expression.Identifier;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.variable.Variable;
import spinja.util.StringWriter;

public class ActionTransition
extends Transition {
    private final Sequence sequence = new Sequence();

    public ActionTransition(State state, State state2) {
        super(state, state2);
    }

    @Override
    public void addAction(Action action) {
        this.sequence.addAction(action);
    }

    @Override
    public Transition duplicate() {
        ActionTransition actionTransition = new ActionTransition(this.getFrom(), this.getTo());
        for (Action action : this.sequence) {
            actionTransition.addAction(action);
        }
        return actionTransition;
    }

    @Override
    public int getActionCount() {
        return this.sequence.getNrActions();
    }

    @Override
    public String getText() {
        StringWriter stringWriter = new StringWriter();
        boolean bl = true;
        for (Action action : this) {
            stringWriter.appendIf(!bl, "; ").append(action.toString());
            bl = false;
        }
        return stringWriter.toString();
    }

    @Override
    public boolean isLocal() {
        if (this.takesAtomicToken() || this.getFrom() != null && this.getFrom().isInAtomic()) {
            return false;
        }
        for (Action action : this.sequence) {
            if (action.isLocal(this.getFrom().getAutomaton().getProctype())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUseless() {
        return false;
    }

    @Override
    public Action getAction(int n) {
        return this.sequence.getAction(n);
    }

    @Override
    public Iterator<Action> iterator() {
        return this.sequence.iterator();
    }

    @Override
    public boolean printTransitionImpl(StringWriter stringWriter) throws ParseException {
        HashMap<Variable, Identifier> hashMap = new HashMap<Variable, Identifier>();
        boolean bl = this.sequence.getBackupVariables(hashMap);
        boolean bl2 = false;
        if (bl) {
            stringWriter.appendLine("private byte[] _backup;").appendLine(new Object[0]);
            bl2 = true;
        } else if (!hashMap.isEmpty()) {
            for (Variable variable : hashMap.keySet()) {
                stringWriter.appendLine("private int _backup_", variable.getName(), ";");
                bl2 = true;
            }
            stringWriter.appendLine(new Object[0]);
        }
        stringWriter.setSavePoint();
        stringWriter.appendLine("public final void takeImpl() throws ValidationException {").indent();
        int n = stringWriter.length();
        if (bl) {
            stringWriter.appendLine("_backup = getProcess().getModel().encode();");
        }
        this.sequence.printTakeStatement(stringWriter);
        stringWriter.outdent();
        if (stringWriter.length() > n) {
            stringWriter.appendLine("}").appendLine(new Object[0]);
            bl2 = true;
        } else {
            stringWriter.revertToSavePoint();
        }
        stringWriter.setSavePoint();
        stringWriter.appendLine("public final void undoImpl() {").indent();
        n = stringWriter.length();
        if (bl) {
            stringWriter.appendLine("if(!getProcess().getModel().decode(_backup)) throw new Error(\"Could not decode the backup!\");");
        } else {
            this.sequence.printUndoStatement(stringWriter);
        }
        stringWriter.outdent();
        if (stringWriter.length() > n) {
            stringWriter.appendLine("}").appendLine(new Object[0]);
            bl2 = true;
        } else {
            stringWriter.revertToSavePoint();
        }
        return bl2;
    }

    @Override
    public boolean isAlwaysEnabled() {
        if (this.sequence.getNrActions() >= 1) {
            try {
                Action action = this.sequence.getAction(0);
                Expression expression = null;
                if (action instanceof ExprAction) {
                    expression = ((ExprAction)action).getExpression();
                }
                if (expression != null && expression.getSideEffect() != null) {
                    return false;
                }
                return action.getEnabledExpression() == null;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }
}

