/*
 * Decompiled with CFR 0.152.
 */
package spinja.store.hash;

import spinja.store.hash.HashAlgorithm;

public class MarcHash
extends HashAlgorithm {
    private static final int[] values;
    private static final long[] values_long;

    private static int nextValue(int n, int n2) {
        while (!MarcHash.isCorrect(n += n2)) {
        }
        return n;
    }

    private static long nextValue(long l, long l2) {
        while (!MarcHash.isCorrect(l += l2)) {
        }
        return l;
    }

    private static boolean isCorrect(int n) {
        int n2 = 0;
        for (int i = 1; i != 0; i <<= 1) {
            if ((n & i) == 0) continue;
            ++n2;
        }
        return n2 == 16;
    }

    private static boolean isCorrect(long l) {
        int n = 0;
        for (long i = 1L; i != 0L; i <<= 1) {
            if ((l & i) == 0L) continue;
            ++n;
        }
        return n == 32;
    }

    @Override
    public int hash(byte[] byArray, int n) {
        int n2 = n;
        for (int i = 0; i < byArray.length; ++i) {
            n2 ^= values[(i << 8 | byArray[i] & 0xFF) + n & 0xFFFFF];
        }
        return n2;
    }

    @Override
    public long hash(byte[] byArray, long l) {
        long l2 = l;
        int n = (int)(l & 0xFFFFFL);
        for (int i = 0; i < byArray.length; ++i) {
            l2 ^= values_long[(i << 8 | byArray[i] & 0xFF) + n & 0xFFFFF];
        }
        return l2;
    }

    static {
        int n;
        int n2;
        values = new int[0x100000];
        int[] nArray = new int[9];
        for (int i = 0; i < 4096; ++i) {
            nArray[0] = MarcHash.nextValue(nArray[8], 1500000001);
            nArray[1] = MarcHash.nextValue(nArray[0], 1500000001);
            nArray[2] = MarcHash.nextValue(nArray[1], 1500000001);
            nArray[3] = MarcHash.nextValue(nArray[2], 1500000001);
            nArray[4] = MarcHash.nextValue(nArray[3], 1500000001);
            nArray[5] = MarcHash.nextValue(nArray[4], 1500000001);
            nArray[6] = MarcHash.nextValue(nArray[5], 1500000001);
            nArray[7] = MarcHash.nextValue(nArray[6], 1500000001);
            nArray[8] = MarcHash.nextValue(nArray[7], 1500000001);
            for (n2 = 0; n2 < 256; ++n2) {
                n = i * 256 + n2;
                MarcHash.values[n] = nArray[8];
                if ((n2 & 0x80) != 0) {
                    int n3 = n;
                    values[n3] = values[n3] ^ nArray[0];
                }
                if ((n2 & 0x40) != 0) {
                    int n4 = n;
                    values[n4] = values[n4] ^ nArray[1];
                }
                if ((n2 & 0x20) != 0) {
                    int n5 = n;
                    values[n5] = values[n5] ^ nArray[2];
                }
                if ((n2 & 0x10) != 0) {
                    int n6 = n;
                    values[n6] = values[n6] ^ nArray[3];
                }
                if ((n2 & 8) != 0) {
                    int n7 = n;
                    values[n7] = values[n7] ^ nArray[4];
                }
                if ((n2 & 4) != 0) {
                    int n8 = n;
                    values[n8] = values[n8] ^ nArray[5];
                }
                if ((n2 & 2) != 0) {
                    int n9 = n;
                    values[n9] = values[n9] ^ nArray[6];
                }
                if ((n2 & 1) == 0) continue;
                int n10 = n;
                values[n10] = values[n10] ^ nArray[7];
            }
        }
        values_long = new long[0x100000];
        long[] lArray = new long[9];
        for (n2 = 0; n2 < 4096; ++n2) {
            lArray[0] = MarcHash.nextValue(lArray[8], 8650415921358664919L);
            lArray[1] = MarcHash.nextValue(lArray[0], 8650415921358664919L);
            lArray[2] = MarcHash.nextValue(lArray[1], 8650415921358664919L);
            lArray[3] = MarcHash.nextValue(lArray[2], 8650415921358664919L);
            lArray[4] = MarcHash.nextValue(lArray[3], 8650415921358664919L);
            lArray[5] = MarcHash.nextValue(lArray[4], 8650415921358664919L);
            lArray[6] = MarcHash.nextValue(lArray[5], 8650415921358664919L);
            lArray[7] = MarcHash.nextValue(lArray[6], 8650415921358664919L);
            lArray[8] = MarcHash.nextValue(lArray[7], 8650415921358664919L);
            for (n = 0; n < 256; ++n) {
                int n11 = n2 * 256 + n;
                MarcHash.values_long[n11] = lArray[8];
                if ((n & 0x80) != 0) {
                    int n12 = n11;
                    values_long[n12] = values_long[n12] ^ lArray[0];
                }
                if ((n & 0x40) != 0) {
                    int n13 = n11;
                    values_long[n13] = values_long[n13] ^ lArray[1];
                }
                if ((n & 0x20) != 0) {
                    int n14 = n11;
                    values_long[n14] = values_long[n14] ^ lArray[2];
                }
                if ((n & 0x10) != 0) {
                    int n15 = n11;
                    values_long[n15] = values_long[n15] ^ lArray[3];
                }
                if ((n & 8) != 0) {
                    int n16 = n11;
                    values_long[n16] = values_long[n16] ^ lArray[4];
                }
                if ((n & 4) != 0) {
                    int n17 = n11;
                    values_long[n17] = values_long[n17] ^ lArray[5];
                }
                if ((n & 2) != 0) {
                    int n18 = n11;
                    values_long[n18] = values_long[n18] ^ lArray[6];
                }
                if ((n & 1) == 0) continue;
                int n19 = n11;
                values_long[n19] = values_long[n19] ^ lArray[7];
            }
        }
    }
}

