/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.sexp;

import java.util.Collections;
import java.util.Map;

public interface VariableResolver {
    public <T> T resolve(String var1, Class<T> var2);

    public static class Mapped
    implements VariableResolver {
        private final Map<String, Object> values;

        public Mapped() {
            this(null);
        }

        public Mapped(Map<String, Object> values) {
            this.values = values == null ? Collections.emptyMap() : values;
        }

        @Override
        public <T> T resolve(String name, Class<T> type) {
            Object value = this.values.get(name);
            if (value == null) {
                throw new IllegalArgumentException("Unknown variable '" + name + "'.");
            }
            if (!type.isInstance(value)) {
                StringBuilder message = new StringBuilder();
                message.append("Variable '");
                message.append(name);
                message.append("' needs a '");
                message.append(type.getSimpleName());
                message.append("' but received a '");
                message.append(value.getClass().getSimpleName());
                message.append("'.");
                throw new IllegalArgumentException(message.toString());
            }
            return type.cast(value);
        }
    }
}

