/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.utils;

import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.petitparser.context.Context;
import org.petitparser.context.Result;
import org.petitparser.parser.Parser;
import org.petitparser.utils.Mirror;

public class Tracer {
    public static Parser on(Parser source, Consumer<TraceEvent> consumer) {
        TraceEvent[] parentClosure = new TraceEvent[1];
        return Mirror.of(source).transform(parser -> parser.callCC((continuation, context) -> {
            TraceEvent parent = parentClosure[0];
            TraceEvent enter = new TraceEvent(TraceEventType.ENTER, parent, (Parser)parser, context);
            consumer.accept(enter);
            parentClosure[0] = enter;
            Result result = (Result)continuation.apply(context);
            parentClosure[0] = parent;
            TraceEvent exit = new TraceEvent(TraceEventType.EXIT, parent, (Parser)parser, result);
            consumer.accept(exit);
            return result;
        }));
    }

    public static class TraceEvent {
        public final TraceEventType type;
        public final TraceEvent parent;
        public final Parser parser;
        public final Context context;

        public int getLevel() {
            return this.parent != null ? 1 + this.parent.getLevel() : 0;
        }

        private TraceEvent(TraceEventType type, TraceEvent parent, Parser parser, Context context) {
            this.type = type;
            this.parent = parent;
            this.parser = parser;
            this.context = context;
        }

        public String toString() {
            String indent = Stream.generate(() -> "  ").limit(this.getLevel()).collect(Collectors.joining());
            return indent + (TraceEventType.ENTER.equals((Object)this.type) ? this.parser : this.context);
        }
    }

    public static enum TraceEventType {
        ENTER,
        EXIT;

    }
}

