/*
 * Decompiled with CFR 0.152.
 */
package spinja.options;

import spinja.options.Option;

public class NumberOption
extends Option {
    private final int defValue;
    private final int minValue;
    private final int maxValue;
    private int value;

    public NumberOption(char c, String string, int n, int n2, int n3) {
        super(c, string);
        this.defValue = n;
        this.minValue = n2;
        this.maxValue = n3;
        this.value = n2 - 1;
    }

    public int getValue() {
        if (this.value == this.minValue - 1) {
            return this.defValue;
        }
        return this.value;
    }

    @Override
    public boolean isSet() {
        return this.value == this.minValue - 1;
    }

    @Override
    public void parseOption(String string) {
        try {
            this.value = Integer.parseInt(string);
            if (this.value < this.minValue) {
                System.out.println("Warning for option -" + this.getChar() + ": value below reach, assuming " + this.minValue);
                this.value = this.minValue;
            } else if (this.value > this.maxValue) {
                System.out.println("Warning for option -" + this.getChar() + ": value above reach, assuming " + this.maxValue);
                this.value = this.maxValue;
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Warning for option -" + this.getChar() + ": value not a valid number, assuming " + this.defValue);
            this.value = this.defValue;
        }
    }

    @Override
    public String toString() {
        String string = this.toString("[" + this.minValue + ".." + this.maxValue + "]");
        String string2 = this.indentedDescription(24, "(default: " + this.defValue + ")");
        return string + "\n" + string2;
    }
}

