/*
 * Decompiled with CFR 0.152.
 */
package plug.language.SpinJa;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import plug.core.IRuntimeView;
import plug.core.view.ConfigurationItem;
import plug.language.SpinJa.runtime.SpinJaConfiguration;
import plug.language.SpinJa.runtime.SpinJaTransitionRelation;
import plug.utils.Pair;
import spinja.concurrent.model.ConcurrentModel;
import spinja.promela.model.PromelaTransition;
import spinja.util.ByteArrayStorage;
import spinja.util.DataReader;

public class SpinJaRuntimeView
implements IRuntimeView<SpinJaConfiguration, Pair<PromelaTransition, SpinJaConfiguration>> {
    SpinJaTransitionRelation runtime;

    public SpinJaRuntimeView(SpinJaTransitionRelation runtime) {
        this.runtime = runtime;
    }

    public SpinJaTransitionRelation getRuntime() {
        return this.runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationItem> getConfigurationItems(SpinJaConfiguration value) {
        ConcurrentModel<PromelaTransition> model;
        ConcurrentModel<PromelaTransition> concurrentModel = model = this.runtime.getModel();
        synchronized (concurrentModel) {
            ByteArrayStorage reader = new ByteArrayStorage();
            reader.setBuffer(value.state);
            model.decode((DataReader)reader);
            ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
            children.add(this.getTreeForBehavior(model));
            for (int i = 0; i < model.getNrProcesses(); ++i) {
                ConfigurationItem childTree = this.getTreeForBehavior(model.getProcess(i));
                children.add(childTree);
            }
            return children;
        }
    }

    ConfigurationItem getTreeForBehavior(Object bhc) {
        ConfigurationItem fieldTree;
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        for (Field field : bhc.getClass().getDeclaredFields()) {
            fieldTree = this.getTreeForField(bhc, field);
            if (fieldTree == null) continue;
            children.add(fieldTree);
        }
        for (Field field : bhc.getClass().getSuperclass().getDeclaredFields()) {
            if (!field.getName().startsWith("_sid") || (fieldTree = this.getTreeForField(bhc, field)) == null) continue;
            children.add(fieldTree);
        }
        ConfigurationItem parentTree = new ConfigurationItem("process", bhc.getClass().getSimpleName(), null, children);
        parentTree.setExpanded(true);
        return parentTree;
    }

    ConfigurationItem getTreeForField(Object object, Field field) {
        try {
            String value;
            field.setAccessible(true);
            Object fVal = field.get(object);
            if (field.getName().startsWith("this")) {
                return null;
            }
            if (field.getType().isArray()) {
                StringBuilder b = new StringBuilder();
                int iMax = Array.getLength(fVal) - 1;
                if (iMax == -1) {
                    value = "[]";
                } else {
                    b.append('[');
                    int i = 0;
                    while (true) {
                        b.append(Array.get(fVal, i));
                        if (i == Array.getLength(fVal) - 1) break;
                        b.append(", ");
                        ++i;
                    }
                    b.append(']');
                    value = b.toString();
                }
            } else {
                value = field.getType().isArray() ? Arrays.deepToString((Object[])fVal) : fVal.toString();
            }
            ConfigurationItem varField = new ConfigurationItem("variable", field.getName() + " = " + value, null, null);
            return varField;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public String getFireableTransitionDescription(Pair<PromelaTransition, SpinJaConfiguration> transition) {
        return null;
    }
}

