/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.parser.actions;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.petitparser.context.Context;
import org.petitparser.context.Result;
import org.petitparser.parser.Parser;
import org.petitparser.parser.combinators.DelegateParser;

public class TrimmingParser
extends DelegateParser {
    private Parser left;
    private Parser right;

    public TrimmingParser(Parser delegate, Parser left, Parser right) {
        super(delegate);
        this.left = Objects.requireNonNull(left, "Undefined left trimming parser");
        this.right = Objects.requireNonNull(right, "Undefined right trimming parser");
    }

    @Override
    public Result parseOn(Context context) {
        Result leftResult = this.consume(this.left, context);
        Result delegateResult = this.delegate.parseOn(leftResult);
        if (delegateResult.isFailure()) {
            return delegateResult;
        }
        Result rightResult = this.consume(this.right, delegateResult);
        return rightResult.success(delegateResult.get());
    }

    private Result consume(Parser parser, Context context) {
        Result result = parser.parseOn(context);
        while (result.isSuccess()) {
            result = parser.parseOn(result);
        }
        return result;
    }

    @Override
    public void replace(Parser source, Parser target) {
        super.replace(source, target);
        if (this.left == source) {
            this.left = target;
        }
        if (this.right == source) {
            this.right = target;
        }
    }

    @Override
    public List<Parser> getChildren() {
        return Arrays.asList(this.delegate, this.left, this.right);
    }

    @Override
    public Parser copy() {
        return new TrimmingParser(this.delegate, this.left, this.right);
    }
}

