/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.expressions.FieldLiteral;
import org.cte.ABCD.model.kernel.Literal;

public class RecordLit
implements Literal {
    private final List<FieldLiteral> valueList = new ArrayList<FieldLiteral>();

    public List<FieldLiteral> getValueList() {
        return Collections.unmodifiableList(this.valueList);
    }

    public int getValueCount() {
        return this.valueList.size();
    }

    public FieldLiteral getValue(int index) {
        if (index < 0 || index >= this.getValueCount()) {
            return null;
        }
        return this.valueList.get(index);
    }

    public void addValue(FieldLiteral newValue) {
        this.addValue(this.getValueCount(), newValue);
    }

    public void addValue(int index, FieldLiteral newValue) {
        this.valueList.add(index, newValue);
    }

    public FieldLiteral setValue(int index, FieldLiteral newValue) {
        return this.valueList.set(index, newValue);
    }

    public void addAllValue(Collection<FieldLiteral> toAddList) {
        for (FieldLiteral newValue : toAddList) {
            this.addValue(this.getValueCount(), newValue);
        }
    }

    public void removeValue(FieldLiteral value) {
        int index = this.valueList.indexOf(value);
        if (index >= 0) {
            this.removeValue(index);
        }
    }

    public void removeValue(int index) {
        this.valueList.remove(index);
    }

    @Override
    public void accept(ABCDVisitor visitor) {
        visitor.visitRecordLit(this);
    }

    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof RecordLit)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        return this.equalsFeatures((RecordLit)that, cache);
    }

    protected boolean equalsFeatures(RecordLit that, IdentityHashMap<Object, Object> cache) {
        int l1size = 0;
        int l2size = 0;
        l1size = this.valueList.size();
        if (l1size != (l2size = that.valueList.size())) {
            return false;
        }
        for (int i = 0; i < l1size; ++i) {
            if (this.valueList.get(i).equalsCached(that.valueList.get(i), cache)) continue;
            return false;
        }
        return true;
    }
}

