/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.fiacre;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import obp.fiacre.model.AnyPattern;
import obp.fiacre.model.Arg;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayElem;
import obp.fiacre.model.ArrayPattern;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BinOp;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Channel;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.Composition;
import obp.fiacre.model.ConstantDecl;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.Constr;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.ConstrPattern;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.DeterministicAssignment;
import obp.fiacre.model.Emission;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Field;
import obp.fiacre.model.FieldPattern;
import obp.fiacre.model.FiniteBound;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.FunctionDecl;
import obp.fiacre.model.FunctionRef;
import obp.fiacre.model.InlineArray;
import obp.fiacre.model.InlineQueue;
import obp.fiacre.model.InlineRecord;
import obp.fiacre.model.Instance;
import obp.fiacre.model.IntType;
import obp.fiacre.model.InterfacedComp;
import obp.fiacre.model.Interval;
import obp.fiacre.model.LocalPortDecl;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.ModelCloner;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NodeDecl;
import obp.fiacre.model.NullStmt;
import obp.fiacre.model.Par;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.PortDecl;
import obp.fiacre.model.Profile;
import obp.fiacre.model.Program;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Reception;
import obp.fiacre.model.RecordElem;
import obp.fiacre.model.RefArg;
import obp.fiacre.model.ReturnStmt;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.SingleAssignment;
import obp.fiacre.model.Statement;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.UnOp;
import obp.fiacre.model.Union;
import obp.fiacre.model.ValuedField;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Wait;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.compiler.StaticEvaluator;
import org.cte.ABCD.compiler.TimedChecker;
import org.cte.ABCD.fiacre.FiacreBuilderForABCD;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.Asynchronous;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ChannelTypeDecl;
import org.cte.ABCD.model.declarations.DeclarationWithPorts;
import org.cte.ABCD.model.declarations.EventPool;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.PortMap;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.declarations.State;
import org.cte.ABCD.model.declarations.SynchronizationPolicy;
import org.cte.ABCD.model.declarations.Synchronous;
import org.cte.ABCD.model.declarations.TypeDecl;
import org.cte.ABCD.model.declarations.ValueHolder;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.Any;
import org.cte.ABCD.model.expressions.ArrayLit;
import org.cte.ABCD.model.expressions.BinaryExp;
import org.cte.ABCD.model.expressions.FalseLit;
import org.cte.ABCD.model.expressions.FieldLiteral;
import org.cte.ABCD.model.expressions.FunctionCall;
import org.cte.ABCD.model.expressions.IndexedExp;
import org.cte.ABCD.model.expressions.IntegerLit;
import org.cte.ABCD.model.expressions.QueueLit;
import org.cte.ABCD.model.expressions.RecordLit;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.expressions.SelectedExp;
import org.cte.ABCD.model.expressions.TrueLit;
import org.cte.ABCD.model.expressions.UnaryExp;
import org.cte.ABCD.model.expressions.UnionLiteral;
import org.cte.ABCD.model.kernel.Element;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Literal;
import org.cte.ABCD.model.kernel.Type;
import org.cte.ABCD.model.kernel.TypedElement;
import org.cte.ABCD.model.statements.AssignStmt;
import org.cte.ABCD.model.statements.Block;
import org.cte.ABCD.model.statements.CaseItem;
import org.cte.ABCD.model.statements.CaseStmt;
import org.cte.ABCD.model.statements.DeferredEvent;
import org.cte.ABCD.model.statements.ForeachStmt;
import org.cte.ABCD.model.statements.GuardStmt;
import org.cte.ABCD.model.statements.IfStmt;
import org.cte.ABCD.model.statements.InputStmt;
import org.cte.ABCD.model.statements.LoopStmt;
import org.cte.ABCD.model.statements.OutputStmt;
import org.cte.ABCD.model.statements.ReceiveStmt;
import org.cte.ABCD.model.statements.SelectStmt;
import org.cte.ABCD.model.statements.SendStmt;
import org.cte.ABCD.model.statements.SpecialTypeStmt;
import org.cte.ABCD.model.statements.ToStmt;
import org.cte.ABCD.model.statements.WaitStmt;
import org.cte.ABCD.model.statements.WhileStmt;
import org.cte.ABCD.model.types.MutexType;
import org.cte.ABCD.model.types.NatType;
import org.cte.ABCD.model.types.NoneType;
import org.cte.ABCD.model.types.Record;
import org.cte.ABCD.model.types.SemaphoreType;
import org.cte.ABCD.model.types.TimerType;
import org.cte.ABCD.printer.PrintVisitor;
import org.cte.ABCD.transformations.TInstNonBlockingComm;
import org.cte.ABCD.transformations.fiacre.TInsertNonBlockingRead;

public class ABCD2Fiacre
implements ABCDVisitor {
    private final Stack<Object> objectStack = new Stack();
    private List<Statement> newStmtsToAdd = new Vector<Statement>();
    private final Map<Element, Object> visited = new IdentityHashMap<Element, Object>();
    private Program fiacreProgram;
    private int currentIdx = 0;
    private boolean isLhs;
    private boolean isTimed = false;
    private FiacreBuilderForABCD fB = new FiacreBuilderForABCD();
    Map<org.cte.ABCD.model.types.Union, String> union2name = new IdentityHashMap<org.cte.ABCD.model.types.Union, String>();
    String typeName = null;
    private Set<Port> port2param = new HashSet<Port>();
    private Transition currentTransition;

    public Program toFiacre(ABCDSystem s) {
        s.accept(this);
        return this.pop(Program.class);
    }

    public <T> T peekObject(Class<T> type) {
        Object node = this.objectStack.peek();
        return type.cast(node);
    }

    public <T> T pop(Class<T> type) {
        Object node = this.objectStack.pop();
        return type.cast(node);
    }

    public Object push(Object node) {
        this.objectStack.push(node);
        return node;
    }

    public boolean isRegistered(Element key) {
        Object o = this.visited.get(key);
        if (o != null) {
            this.push(o);
            return true;
        }
        return false;
    }

    public Object register(Element key, Object o) {
        this.visited.put(key, o);
        return o;
    }

    @Override
    public void visitBoolType(org.cte.ABCD.model.types.BoolType toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        this.push(this.register(toVisit, new BoolType()));
    }

    @Override
    public void visitNatType(NatType toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        this.push(this.register(toVisit, new obp.fiacre.model.NatType()));
    }

    @Override
    public void visitIntType(org.cte.ABCD.model.types.IntType toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        this.push(this.register(toVisit, new IntType()));
    }

    @Override
    public void visitNoneType(NoneType toVisit) {
        this.push(null);
    }

    @Override
    public void visitTimerType(TimerType toVisit) {
    }

    @Override
    public void visitSemaphoreType(SemaphoreType toVisit) {
    }

    @Override
    public void visitMutexType(MutexType toVisit) {
    }

    @Override
    public void visitInterval(org.cte.ABCD.model.types.Interval toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Interval node = new Interval();
        this.register(toVisit, node);
        toVisit.getMini().accept(this);
        node.setMini(this.pop(Exp.class));
        toVisit.getMaxi().accept(this);
        node.setMaxi(this.pop(Exp.class));
        this.push(node);
    }

    @Override
    public void visitUnion(org.cte.ABCD.model.types.Union toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Union node = new Union();
        this.register(toVisit, node);
        if (this.typeName == null) {
            System.err.println("anonymous union declaration is not supported yet\n");
        } else {
            this.union2name.put(toVisit, this.typeName);
        }
        for (org.cte.ABCD.model.declarations.Field f : toVisit.getFieldsList()) {
            f.accept(this);
            node.addConstr(this.pop(Constr.class));
        }
        this.push(node);
    }

    @Override
    public void visitUnionLiteral(UnionLiteral toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        if (this.isLhs) {
            ConstrPattern node = new ConstrPattern();
            this.register(toVisit, node);
            node.setName(this.union2name.get(toVisit.getType()) + "_" + toVisit.getSelector());
            if (toVisit.getExpression() != null) {
                toVisit.getExpression().accept(this);
                node.setArg(this.pop(Pattern.class));
            }
            this.push(node);
            return;
        }
        ConstrExp node = new ConstrExp();
        this.register(toVisit, node);
        node.setName(this.union2name.get(toVisit.getType()) + "_" + toVisit.getSelector());
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
            node.setArg(this.pop(Exp.class));
        }
        this.push(node);
    }

    @Override
    public void visitRecord(Record toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        obp.fiacre.model.Record node = new obp.fiacre.model.Record();
        this.register(toVisit, node);
        for (org.cte.ABCD.model.declarations.Field f : toVisit.getFieldsList()) {
            f.accept(this);
            node.addField(this.pop(Field.class));
        }
        this.push(node);
    }

    @Override
    public void visitArray(org.cte.ABCD.model.types.Array toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Array node = new Array();
        this.register(toVisit, node);
        toVisit.getType().accept(this);
        node.setType(this.pop(obp.fiacre.model.Type.class));
        toVisit.getSize().accept(this);
        node.setSize(this.pop(Exp.class));
        this.push(node);
    }

    @Override
    public void visitQueue(org.cte.ABCD.model.types.Queue toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Queue node = new Queue();
        this.register(toVisit, node);
        toVisit.getType().accept(this);
        node.setType(this.pop(obp.fiacre.model.Type.class));
        toVisit.getSize().accept(this);
        node.setSize(this.pop(Exp.class));
        this.push(node);
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        obp.fiacre.model.TypeDecl node = new obp.fiacre.model.TypeDecl();
        TypeId tid = new TypeId();
        tid.setDecl(node);
        this.register(toVisit, tid);
        node.setName(toVisit.getName());
        this.typeName = toVisit.getName();
        toVisit.getType().accept(this);
        this.typeName = null;
        node.setIs(this.pop(obp.fiacre.model.Type.class));
        this.push(node);
    }

    @Override
    public void visitField(org.cte.ABCD.model.declarations.Field toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        if (toVisit.getParent() instanceof org.cte.ABCD.model.types.Union) {
            Constr node = new Constr();
            this.register(toVisit, node);
            if (toVisit.getType() != null) {
                toVisit.getType().accept(this);
                node.setType(this.pop(obp.fiacre.model.Type.class));
            }
            node.setName(this.union2name.get(toVisit.getParent()) + "_" + toVisit.getName());
            this.push(node);
            return;
        }
        Field node = new Field();
        this.register(toVisit, node);
        node.setName(toVisit.getName());
        toVisit.getType().accept(this);
        node.setType(this.pop(obp.fiacre.model.Type.class));
        this.push(node);
    }

    @Override
    public void visitSynchronous(Synchronous toVisit) {
    }

    @Override
    public void visitAsynchronous(Asynchronous toVisit) {
    }

    @Override
    public void visitEventPool(EventPool toVisit) {
    }

    @Override
    public void visitChannelTypeDecl(ChannelTypeDecl toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        if (toVisit.getSynchronizationPolicy() instanceof Asynchronous) {
            Asynchronous syncPolicy = (Asynchronous)toVisit.getSynchronizationPolicy();
            syncPolicy.getSize().accept(this);
            toVisit.getType().accept(this);
            obp.fiacre.model.Type type = this.pop(obp.fiacre.model.Type.class);
            Exp exp = this.pop(Exp.class);
            Literal l = StaticEvaluator.evaluate(syncPolicy.getSize());
            if (!(l instanceof IntegerLit)) {
                System.err.println("Incorrect buffersize for channeltype " + toVisit.getName());
                return;
            }
            int size = ((IntegerLit)l).getValue();
            List<Declaration> fifo = this.fB.createFifo("Fifo" + size + (syncPolicy.isIsBlocking() ? "block" : "noblock"), type, exp, syncPolicy.isIsBlocking());
            this.fiacreProgram.addAllDeclaration(fifo);
            obp.fiacre.model.ProcessDecl process = syncPolicy.isIsBlocking() ? (obp.fiacre.model.ProcessDecl)fifo.get(0) : (obp.fiacre.model.ProcessDecl)fifo.get(1);
            this.register(toVisit, process);
            this.push(process);
            return;
        }
        if (toVisit.getSynchronizationPolicy() instanceof EventPool) {
            EventPool syncPolicy = (EventPool)toVisit.getSynchronizationPolicy();
            toVisit.getType().accept(this);
            obp.fiacre.model.Type type = this.pop(obp.fiacre.model.Type.class);
            syncPolicy.getSize().accept(this);
            Exp exp = this.pop(Exp.class);
            obp.fiacre.model.TypeDecl node = this.fB.typeDecl(toVisit.getName(), this.fB.queueType(exp, type));
            this.fiacreProgram.addDeclaration(node);
            this.register(toVisit, node);
            this.push(node);
            return;
        }
        Profile node = new Profile();
        this.register(toVisit, node);
        toVisit.getType().accept(this);
        obp.fiacre.model.Type tp = this.pop(obp.fiacre.model.Type.class);
        if (tp != null) {
            node.addType(tp);
        }
        this.push(node);
    }

    @Override
    public void visitConstantDecl(org.cte.ABCD.model.declarations.ConstantDecl toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        ConstantDecl node = new ConstantDecl();
        ConstantRef cref = new ConstantRef();
        cref.setDecl(node);
        this.register(toVisit, cref);
        node.setName(toVisit.getName());
        toVisit.getType().accept(this);
        node.setType(this.pop(obp.fiacre.model.Type.class));
        toVisit.getValue().accept(this);
        node.setValue(this.pop(Exp.class));
        this.push(node);
    }

    @Override
    public void visitVariableDecl(VariableDecl toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        LocalVariable node = new LocalVariable();
        VarRef vref = new VarRef();
        vref.setDecl(node);
        this.register(toVisit, vref);
        node.setName(toVisit.getName());
        toVisit.getType().accept(this);
        node.setType(this.pop(obp.fiacre.model.Type.class));
        if (toVisit.getValue() != null) {
            toVisit.getValue().accept(this);
            node.setInitializer(this.pop(Exp.class));
        }
        if (toVisit.isIsLTT()) {
            node.addComment("@ltt");
        }
        this.push(node);
    }

    @Override
    public void visitChannelDecl(ChannelDecl toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        toVisit.getType().accept(this);
        Object decl = this.peekObject(Object.class);
        if (decl instanceof obp.fiacre.model.ProcessDecl) {
            obp.fiacre.model.ProcessDecl pD = (obp.fiacre.model.ProcessDecl)decl;
            Instance fifoI = new Instance();
            fifoI.setType(pD);
            fifoI.setName(toVisit.getName());
            this.register(toVisit, fifoI);
            return;
        }
        if (((ChannelTypeDecl)toVisit.getType()).getSynchronizationPolicy() instanceof EventPool) {
            obp.fiacre.model.TypeDecl type = this.pop(obp.fiacre.model.TypeDecl.class);
            LocalVariable node = this.fB.localVariable(toVisit.getName(), this.fB.type(type));
            this.register(toVisit, node);
            this.push(node);
            return;
        }
        LocalPortDecl node = new LocalPortDecl();
        this.register(toVisit, node);
        node.setName(toVisit.getName());
        node.setChannel(this.pop(Channel.class));
        if (this.isTimed) {
            FiniteBound fB = new FiniteBound();
            fB.setStrict(false);
            fB.setVal(0);
            node.setMini(fB);
            node.setMaxi(fB);
        }
        this.push(node);
    }

    @Override
    public void visitPort(Port toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        if (this.port2param.contains(toVisit)) {
            ArgumentVariable node = new ArgumentVariable();
            this.register(toVisit, node);
            node.setName(toVisit.getName());
            toVisit.getType().accept(this);
            obp.fiacre.model.Type type = this.pop(obp.fiacre.model.Type.class);
            node.setType(type);
            node.setRef(true);
            node.setRead(toVisit.isIsInput());
            node.setWrite(!toVisit.isIsInput());
            this.push(node);
            return;
        }
        ParamPortDecl node = new ParamPortDecl();
        this.register(toVisit, node);
        node.setName(toVisit.getName());
        toVisit.getType().accept(this);
        Profile chan = new Profile();
        obp.fiacre.model.Type tp = this.pop(obp.fiacre.model.Type.class);
        if (tp != null) {
            chan.addType(tp);
        }
        node.setChannel(chan);
        if (toVisit.isIsInput()) {
            node.setIn(true);
        } else {
            node.setOut(true);
        }
        this.push(node);
    }

    @Override
    public void visitProcessDecl(ProcessDecl toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        obp.fiacre.model.ProcessDecl node = new obp.fiacre.model.ProcessDecl();
        this.register(toVisit, node);
        node.setName(toVisit.getName());
        for (State state : toVisit.getStatesList()) {
            state.accept(this);
            node.addState(this.pop(obp.fiacre.model.State.class));
        }
        for (Port port : toVisit.getPortsList()) {
            port.accept(this);
            if (this.port2param.contains(port)) {
                node.addArg(this.pop(ArgumentVariable.class));
                continue;
            }
            node.addPort(this.pop(ParamPortDecl.class));
        }
        for (ParameterDecl parameterDecl : toVisit.getParametersList()) {
            parameterDecl.accept(this);
            node.addArg(this.pop(ArgumentVariable.class));
        }
        for (VariableDecl variableDecl : toVisit.getVariablesList()) {
            variableDecl.accept(this);
            node.addVar(this.pop(LocalVariable.class));
        }
        if (toVisit.getInitialization() != null) {
            toVisit.getInitialization().accept(this);
            node.setInitAction(this.pop(Statement.class));
        }
        for (org.cte.ABCD.model.statements.Transition transition : toVisit.getTransitionsList()) {
            transition.accept(this);
            node.addTransition(this.pop(Transition.class));
        }
        this.push(node);
    }

    @Override
    public void visitState(State toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        obp.fiacre.model.State node = new obp.fiacre.model.State();
        this.register(toVisit, node);
        node.setName(toVisit.getName());
        this.push(node);
    }

    @Override
    public void visitPortMap(PortMap toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        SynchronizationPolicy syncPol = null;
        if (toVisit.getActual() instanceof Reference && ((Reference)toVisit.getActual()).getRef() instanceof ChannelDecl) {
            syncPol = ((ChannelTypeDecl)((ChannelDecl)((Reference)toVisit.getActual()).getRef()).getType()).getSynchronizationPolicy();
        } else {
            System.err.println("ABCD2Fiacre: unexpected actual in portmap");
        }
        if (syncPol instanceof EventPool) {
            toVisit.getActual().accept(this);
            VarRef node = this.fB.varRef(this.pop(LocalVariable.class));
            this.register(toVisit, node);
            this.port2param.add(toVisit.getFormal());
            this.push(node);
            return;
        }
        LocalPortDecl node = new LocalPortDecl();
        this.register(toVisit, node);
        if (syncPol instanceof Asynchronous) {
            this.isRegistered(((Reference)toVisit.getActual()).getRef());
            Instance fifoI = this.pop(Instance.class);
            ParamPortDecl port = null;
            if (toVisit.getFormal().isIsInput()) {
                port = fifoI.getType().getPort(1);
                if (!((Asynchronous)syncPol).isIsBlocking()) {
                    toVisit.getFormal().accept(this);
                    PortDecl thePort = this.pop(ParamPortDecl.class);
                    thePort.setChannel(port.getChannel());
                    if (!this.isRegistered(toVisit.getFormal().getContainer())) {
                        DeclarationWithPorts pDecl = toVisit.getFormal().getContainer();
                        pDecl.accept(this);
                    }
                    obp.fiacre.model.ProcessDecl fcrProcess = this.pop(obp.fiacre.model.ProcessDecl.class);
                    TInsertNonBlockingRead.tranformProcess(fcrProcess, thePort, this.currentIdx++);
                }
            } else {
                port = fifoI.getType().getPort(0);
            }
            node.setChannel(port.getChannel());
            node.setName(fifoI.getName() + "_" + port.getName());
        } else {
            toVisit.getActual().accept(this);
            LocalPortDecl chan = this.pop(LocalPortDecl.class);
            node.setChannel(chan.getChannel());
            node.setName(chan.getName());
        }
        if (toVisit.getFormal().isIsInput()) {
            node.setIn(true);
        } else {
            node.setOut(true);
        }
        this.push(node);
    }

    @Override
    public void visitArgumentMap(ArgumentMap toVisit) {
        if (toVisit.getContainer() instanceof FunctionCall) {
            toVisit.getActual().accept(this);
        } else {
            if (this.isRegistered(toVisit)) {
                return;
            }
            RefArg node = new RefArg();
            this.register(toVisit, node);
            toVisit.getActual().accept(this);
            node.setRef(this.pop(VarRef.class).getDecl());
            this.push(node);
        }
    }

    @Override
    public void visitProcessInstance(ProcessInstance toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Instance node = new Instance();
        this.register(toVisit, node);
        node.setName(toVisit.getName());
        ProcessDecl theProcess = toVisit.getProcess();
        for (ArgumentMap aM : toVisit.getArgumentsList()) {
            aM.accept(this);
            node.addArg(this.pop(Arg.class));
        }
        PortDecl[] ports = new PortDecl[theProcess.getPortsCount()];
        int[] inputPositions = new int[toVisit.getInputsCount()];
        int[] outputPositions = new int[toVisit.getOutputsCount()];
        int inI = 0;
        int outI = 0;
        for (int i = 0; i < theProcess.getPortsCount(); ++i) {
            if (theProcess.getPorts(i).isIsInput()) {
                inputPositions[inI++] = i;
                continue;
            }
            outputPositions[outI++] = i;
        }
        inI = 0;
        for (PortMap pM : toVisit.getInputsList()) {
            pM.accept(this);
            ports[inputPositions[inI++]] = this.pop(PortDecl.class);
        }
        outI = 0;
        for (PortMap pM : toVisit.getOutputsList()) {
            pM.accept(this);
            if (!this.port2param.contains(pM.getFormal())) {
                ports[outputPositions[outI++]] = this.pop(PortDecl.class);
                continue;
            }
            node.addArg(this.pop(Arg.class));
        }
        ArrayList<PortDecl> portL = new ArrayList<PortDecl>();
        for (PortDecl pD : ports) {
            if (pD == null) continue;
            portL.add(pD);
        }
        node.addAllPort(portL);
        theProcess.accept(this);
        node.setType(this.pop(NodeDecl.class));
        this.push(node);
    }

    @Override
    public void visitABCDSystem(ABCDSystem toVisit) {
        InterfacedComp instI;
        if (this.isRegistered(toVisit)) {
            return;
        }
        Program node = new Program();
        this.register(toVisit, node);
        this.fiacreProgram = node;
        for (org.cte.ABCD.model.kernel.Declaration tD : toVisit.getDeclarationsList()) {
            tD.accept(this);
            node.addDeclaration(this.pop(Declaration.class));
        }
        TInstNonBlockingComm nonblockProcessor = new TInstNonBlockingComm();
        toVisit.accept(nonblockProcessor);
        ComponentDecl compDecl = new ComponentDecl();
        Par par = new Par();
        compDecl.setName("sys");
        compDecl.setBody(par);
        for (ChannelTypeDecl ctD : toVisit.getChannelTypesList()) {
            ctD.accept(this);
            this.pop(Object.class);
        }
        this.isTimed = TimedChecker.isTimed(toVisit);
        for (ChannelDecl cD : toVisit.getChannelsList()) {
            cD.accept(this);
            if (((ChannelTypeDecl)cD.getType()).getSynchronizationPolicy() instanceof Asynchronous) {
                this.pop(obp.fiacre.model.ProcessDecl.class);
                this.isRegistered(cD);
                Instance fifoI = this.pop(Instance.class);
                instI = new InterfacedComp();
                instI.setComposition(fifoI);
                par.addArg(instI);
                for (PortDecl portDecl : fifoI.getType().getPortList()) {
                    LocalPortDecl fPort = new LocalPortDecl();
                    compDecl.addLocalPort(fPort);
                    fPort.setChannel(portDecl.getChannel());
                    fPort.setName(fifoI.getName() + "_" + portDecl.getName());
                    fifoI.addPort(fPort);
                }
                continue;
            }
            if (((ChannelTypeDecl)cD.getType()).getSynchronizationPolicy() instanceof EventPool) {
                LocalVariable var = this.pop(LocalVariable.class);
                compDecl.addVar(var);
                continue;
            }
            compDecl.addLocalPort(this.pop(LocalPortDecl.class));
        }
        for (VariableDecl vD : toVisit.getVariablesList()) {
            vD.accept(this);
            compDecl.addVar(this.pop(LocalVariable.class));
        }
        for (org.cte.ABCD.model.declarations.FunctionDecl fD : toVisit.getFunctionsList()) {
            fD.accept(this);
            node.addDeclaration(this.pop(FunctionDecl.class));
        }
        HashSet<Declaration> processes = new HashSet<Declaration>();
        for (ProcessInstance pI : toVisit.getCompositionList()) {
            instI = new InterfacedComp();
            pI.accept(this);
            instI.setComposition(this.pop(Composition.class));
            par.addArg(instI);
            this.isRegistered(pI.getProcess());
            processes.add(this.pop(obp.fiacre.model.ProcessDecl.class));
        }
        node.addAllDeclaration(processes);
        node.addDeclaration(compDecl);
        node.setRoot(compDecl);
        this.push(node);
    }

    @Override
    public void visitInputStmt(InputStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Reception node = new Reception();
        this.register(toVisit, node);
        toVisit.getPort().accept(this);
        node.setPort(this.pop(PortDecl.class));
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
            node.addPattern(this.pop(Pattern.class));
        }
        this.push(node);
    }

    @Override
    public void visitOutputStmt(OutputStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Emission node = new Emission();
        this.register(toVisit, node);
        toVisit.getPort().accept(this);
        node.setPort(this.pop(PortDecl.class));
        if (toVisit.getExpression() != null) {
            toVisit.getExpression().accept(this);
            node.addArg(this.pop(Exp.class));
        }
        this.push(node);
    }

    @Override
    public void visitToStmt(ToStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        To node = new To();
        this.register(toVisit, node);
        toVisit.getState().accept(this);
        node.setDest(this.pop(obp.fiacre.model.State.class));
        this.push(node);
    }

    @Override
    public void visitLoopStmt(LoopStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        To node = new To();
        this.register(toVisit, node);
        toVisit.getParent().accept(this);
        Transition t = this.pop(Transition.class);
        node.setDest(t.getFrom());
        this.push(node);
    }

    @Override
    public void visitIfStmt(IfStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        obp.fiacre.model.IfStmt node = new obp.fiacre.model.IfStmt();
        this.register(toVisit, node);
        toVisit.getCondition().accept(this);
        node.setCondition(this.pop(Exp.class));
        toVisit.getTrueBranch().accept(this);
        node.setThen(this.pop(Statement.class));
        if (toVisit.getFalseBranch() != null) {
            toVisit.getFalseBranch().accept(this);
            node.setElse(this.pop(Statement.class));
        }
        this.push(node);
    }

    @Override
    public void visitSelectStmt(SelectStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Select node = new Select();
        this.register(toVisit, node);
        for (org.cte.ABCD.model.kernel.Statement s : toVisit.getStatementsList()) {
            s.accept(this);
            node.addStatement(this.pop(Statement.class));
        }
        this.push(node);
    }

    @Override
    public void visitSpecialTypeStmt(SpecialTypeStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        ValueHolder pfx = toVisit.getReceiver();
        pfx.accept(this);
        if (this.isQueue(pfx)) {
            BinExp rhs = new BinExp();
            rhs.setLeft(this.pop(Exp.class));
            assert (toVisit.getArgumentsCount() == 1);
            toVisit.getArguments(0).accept(this);
            rhs.setRight(this.pop(Exp.class));
            if (toVisit.getSelector().equals("write")) {
                rhs.setBinOp(BinOp.ENQUEUE);
            }
            DeterministicAssignment node = new DeterministicAssignment();
            SingleAssignment sA = new SingleAssignment();
            this.register(toVisit, node);
            sA.setLhs((Pattern)((Object)rhs.getLeft()));
            sA.setRhs(rhs);
            node.addAssignment(sA);
            this.push(node);
            return;
        }
        NullStmt node = new NullStmt();
        this.register(toVisit, node);
        this.push(node);
    }

    @Override
    public void visitWaitStmt(WaitStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Wait node = new Wait();
        this.register(toVisit, node);
        toVisit.getMinBound().accept(this);
        FiniteBound fB = new FiniteBound();
        if (toVisit.isMinIncluded()) {
            fB.setStrict(false);
        } else {
            fB.setStrict(true);
        }
        NatLiteral e = this.pop(NatLiteral.class);
        fB.setVal(e.getValue());
        node.setMini(fB);
        toVisit.getMaxBound().accept(this);
        fB = new FiniteBound();
        if (toVisit.isMaxIncluded()) {
            fB.setStrict(false);
        } else {
            fB.setStrict(true);
        }
        e = this.pop(NatLiteral.class);
        fB.setVal(e.getValue());
        node.setMaxi(fB);
        this.push(node);
    }

    @Override
    public void visitAssignStmt(AssignStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        DeterministicAssignment node = new DeterministicAssignment();
        SingleAssignment sA = new SingleAssignment();
        this.register(toVisit, node);
        this.isLhs = true;
        toVisit.getLhs().accept(this);
        sA.setLhs(this.pop(Pattern.class));
        this.isLhs = false;
        toVisit.getRhs().accept(this);
        sA.setRhs(this.pop(Exp.class));
        node.addAssignment(sA);
        this.push(node);
    }

    @Override
    public void visitTransition(org.cte.ABCD.model.statements.Transition toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Transition node = new Transition();
        this.register(toVisit, node);
        this.currentTransition = node;
        toVisit.getFrom().accept(this);
        node.setFrom(this.pop(obp.fiacre.model.State.class));
        toVisit.getBehavior().accept(this);
        node.setAction(this.pop(Statement.class));
        this.currentTransition = null;
        this.push(node);
    }

    @Override
    public void visitBlock(Block toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Seq node = new Seq();
        this.register(toVisit, node);
        for (org.cte.ABCD.model.kernel.Statement s : toVisit.getStatementsList()) {
            s.accept(this);
            node.addStatement(this.pop(Statement.class));
            if (this.newStmtsToAdd.isEmpty()) continue;
            node.addAllStatement(this.newStmtsToAdd);
            this.newStmtsToAdd = new Vector<Statement>();
        }
        this.push(node);
    }

    @Override
    public void visitIntegerLit(IntegerLit toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        NatLiteral node = new NatLiteral();
        this.register(toVisit, node);
        node.setValue(toVisit.getValue());
        this.push(node);
    }

    @Override
    public void visitTrueLit(TrueLit toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        BoolLiteral node = new BoolLiteral();
        this.register(toVisit, node);
        node.setValue(true);
        this.push(node);
    }

    @Override
    public void visitFalseLit(FalseLit toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        BoolLiteral node = new BoolLiteral();
        this.register(toVisit, node);
        node.setValue(false);
        this.push(node);
    }

    @Override
    public void visitArrayLit(ArrayLit toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        InlineArray node = new InlineArray();
        this.register(toVisit, node);
        for (Expression e : toVisit.getValueList()) {
            e.accept(this);
            node.addElem(this.pop(Exp.class));
        }
        this.push(node);
    }

    @Override
    public void visitQueueLit(QueueLit toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        InlineQueue node = new InlineQueue();
        this.register(toVisit, node);
        for (Expression e : toVisit.getValueList()) {
            e.accept(this);
            node.addElem(this.pop(Exp.class));
        }
        this.push(node);
    }

    @Override
    public void visitRecordLit(RecordLit toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        InlineRecord node = new InlineRecord();
        this.register(toVisit, node);
        for (FieldLiteral f : toVisit.getValueList()) {
            f.accept(this);
            node.addValue(this.pop(ValuedField.class));
        }
        this.push(node);
    }

    @Override
    public void visitFieldLiteral(FieldLiteral toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        ValuedField node = new ValuedField();
        this.register(toVisit, node);
        node.setField(toVisit.getName());
        toVisit.getValue().accept(this);
        node.setValue(this.pop(Exp.class));
        this.push(node);
    }

    @Override
    public void visitUnaryExp(UnaryExp toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        UnExp node = new UnExp();
        this.register(toVisit, node);
        toVisit.getOperand().accept(this);
        node.setExp(this.pop(Exp.class));
        switch (toVisit.getOperator()) {
            case UMINUS: {
                node.setUnop(UnOp.UMINUS);
                break;
            }
            case UNOT: {
                node.setUnop(UnOp.UNOT);
                break;
            }
        }
        this.push(node);
    }

    @Override
    public void visitBinaryExp(BinaryExp toVisit) {
        BinExp bnode;
        if (this.isRegistered(toVisit)) {
            return;
        }
        Exp node = bnode = new BinExp();
        this.register(toVisit, node);
        toVisit.getOperands(0).accept(this);
        bnode.setLeft(this.pop(Exp.class));
        toVisit.getOperands(1).accept(this);
        bnode.setRight(this.pop(Exp.class));
        switch (toVisit.getOperator()) {
            case BADD: {
                bnode.setBinOp(BinOp.BADD);
                break;
            }
            case BAND: {
                bnode.setBinOp(BinOp.BAND);
                break;
            }
            case BDIV: {
                bnode.setBinOp(BinOp.BDIV);
                break;
            }
            case BEQ: {
                bnode.setBinOp(BinOp.BEQ);
                break;
            }
            case BGE: {
                bnode.setBinOp(BinOp.BGE);
                break;
            }
            case BGT: {
                bnode.setBinOp(BinOp.BGT);
                break;
            }
            case BLE: {
                bnode.setBinOp(BinOp.BLE);
                break;
            }
            case BLT: {
                bnode.setBinOp(BinOp.BLT);
                break;
            }
            case BMINUS: {
                bnode.setBinOp(BinOp.BMINUS);
                break;
            }
            case BMOD: {
                bnode.setBinOp(BinOp.BMOD);
                break;
            }
            case BMUL: {
                bnode.setBinOp(BinOp.BMUL);
                break;
            }
            case BNAND: {
                UnExp unode = new UnExp();
                bnode.setBinOp(BinOp.BAND);
                unode.setUnop(UnOp.UNOT);
                unode.setExp(node);
                node = unode;
                break;
            }
            case BNE: {
                bnode.setBinOp(BinOp.BNE);
                break;
            }
            case BNOR: {
                UnExp unode = new UnExp();
                bnode.setBinOp(BinOp.BOR);
                unode.setUnop(UnOp.UNOT);
                unode.setExp(node);
                node = unode;
                break;
            }
            case BOR: {
                bnode.setBinOp(BinOp.BOR);
                break;
            }
            case BXOR: {
                BinExp ne = new BinExp();
                BinExp comp = new BinExp();
                ModelCloner fC = new ModelCloner();
                bnode.getLeft().accept(fC);
                ne.setLeft((Exp)fC.popObject(Exp.class));
                bnode.getRight().accept(fC);
                ne.setRight((Exp)fC.popObject(Exp.class));
                ne.setBinOp(BinOp.BAND);
                UnExp unode = new UnExp();
                unode.setUnop(UnOp.UNOT);
                unode.setExp(ne);
                bnode.setBinOp(BinOp.BOR);
                comp.setLeft(bnode);
                comp.setRight(unode);
                comp.setBinOp(BinOp.BAND);
                node = comp;
                break;
            }
        }
        this.push(node);
    }

    @Override
    public void visitIndexedExp(IndexedExp toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        if (this.isLhs) {
            ArrayPattern node = new ArrayPattern();
            this.register(toVisit, node);
            toVisit.getPrefix().accept(this);
            node.setArray(this.pop(Pattern.class));
            toVisit.getIndex().accept(this);
            node.setIndex(this.pop(Exp.class));
            this.push(node);
            return;
        }
        ArrayElem node = new ArrayElem();
        this.register(toVisit, node);
        toVisit.getPrefix().accept(this);
        node.setArray(this.pop(Exp.class));
        toVisit.getIndex().accept(this);
        node.setIndex(this.pop(Exp.class));
        this.push(node);
    }

    private boolean isQueue(org.cte.ABCD.model.kernel.Declaration decl) {
        Type pfxType;
        return decl instanceof TypedElement && ((pfxType = ((TypedElement)((Object)decl)).getType()) instanceof org.cte.ABCD.model.types.Queue || pfxType instanceof TypeDecl && ((TypeDecl)pfxType).getType() instanceof org.cte.ABCD.model.types.Queue);
    }

    private UnExp unaryQueueOpToFiacre(SelectedExp toConvert) {
        UnExp node = new UnExp();
        String selector = toConvert.getSelector();
        node.setExp(this.pop(Exp.class));
        if (selector.equals("full")) {
            node.setUnop(UnOp.UFULL);
        } else if (selector.equals("empty")) {
            node.setUnop(UnOp.UEMPTY);
        } else if (selector.equals("read")) {
            DeterministicAssignment assign = new DeterministicAssignment();
            SingleAssignment sA = new SingleAssignment();
            sA.setLhs((Pattern)((Object)node.getExp()));
            UnExp rhs = new UnExp();
            rhs.setExp(node.getExp());
            rhs.setUnop(UnOp.DEQUEUE);
            sA.setRhs(rhs);
            assign.addAssignment(sA);
            this.newStmtsToAdd.add(assign);
            node.setUnop(UnOp.FIRST);
        } else if (selector.equals("dequeue")) {
            node.setUnop(UnOp.DEQUEUE);
        } else if (selector.equals("first")) {
            node.setUnop(UnOp.FIRST);
        } else if (selector.equals("length")) {
            node.setUnop(UnOp.LENGTH);
        } else {
            if (selector.equals("write")) {
                System.err.println("queue write is a special type statement\n");
                return null;
            }
            System.err.println("queue does not support " + selector + "operation\n");
            return null;
        }
        return node;
    }

    @Override
    public void visitSelectedExp(SelectedExp toVisit) {
        obp.fiacre.model.Element node;
        NamedDeclaration pfxDecl;
        if (this.isRegistered(toVisit)) {
            return;
        }
        Expression pfx = toVisit.getPrefix();
        pfx.accept(this);
        if (pfx instanceof Reference && this.isQueue(pfxDecl = ((Reference)pfx).getRef())) {
            UnExp node2 = this.unaryQueueOpToFiacre(toVisit);
            this.register(toVisit, node2);
            this.push(node2);
            return;
        }
        if (this.isLhs) {
            node = new FieldPattern();
            this.register(toVisit, node);
            ((FieldPattern)node).setRecord(this.pop(Pattern.class));
            ((FieldPattern)node).setField(toVisit.getSelector());
            this.push(node);
            return;
        }
        node = new RecordElem();
        this.register(toVisit, node);
        ((RecordElem)node).setRecord(this.pop(Exp.class));
        ((RecordElem)node).setField(toVisit.getSelector());
        this.push(node);
    }

    @Override
    public void visitReference(Reference toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        toVisit.getRef().accept(this);
        this.pop(Object.class);
        if (!this.isRegistered(toVisit.getRef())) {
            System.err.println("cannot find reference");
        }
        this.register(toVisit, this.peekObject(Object.class));
    }

    @Override
    public void visitParameterDecl(ParameterDecl toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        ArgumentVariable node = new ArgumentVariable();
        VarRef vref = new VarRef();
        vref.setDecl(node);
        this.register(toVisit, vref);
        node.setName(toVisit.getName());
        toVisit.getType().accept(this);
        node.setType(this.pop(obp.fiacre.model.Type.class));
        node.setRef(true);
        this.push(node);
    }

    @Override
    public void visitWhileStmt(WhileStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        obp.fiacre.model.WhileStmt node = new obp.fiacre.model.WhileStmt();
        this.register(toVisit, node);
        toVisit.getCondition().accept(this);
        node.setCondition(this.pop(Exp.class));
        toVisit.getBody().accept(this);
        node.setBody(this.pop(Statement.class));
        this.push(node);
    }

    @Override
    public void visitForeachStmt(ForeachStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Foreach node = new Foreach();
        this.register(toVisit, node);
        toVisit.getVariable().accept(this);
        VarRef var = this.pop(VarRef.class);
        node.setIter((LocalVariable)var.getDecl());
        toVisit.getBody().accept(this);
        node.setBody(this.pop(Statement.class));
        this.push(node);
    }

    @Override
    public void visitNullStmt(org.cte.ABCD.model.statements.NullStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        NullStmt node = new NullStmt();
        this.register(toVisit, node);
        this.push(node);
    }

    @Override
    public void visitFunctionDecl(org.cte.ABCD.model.declarations.FunctionDecl toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        FunctionDecl node = new FunctionDecl();
        this.register(toVisit, node);
        node.setName(toVisit.getName());
        for (ParameterDecl p : toVisit.getParametersList()) {
            p.accept(this);
            ArgumentVariable arg = this.pop(ArgumentVariable.class);
            arg.setRead(true);
            arg.setWrite(false);
            arg.setRef(false);
            node.addArg(arg);
        }
        toVisit.getType().accept(this);
        node.setReturnType(this.pop(obp.fiacre.model.Type.class));
        for (VariableDecl v : toVisit.getVariablesList()) {
            v.accept(this);
            node.addVar(this.pop(LocalVariable.class));
        }
        toVisit.getBody().accept(this);
        node.setBody(this.pop(Statement.class));
        this.push(node);
    }

    @Override
    public void visitReturnStmt(org.cte.ABCD.model.statements.ReturnStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        ReturnStmt node = new ReturnStmt();
        this.register(toVisit, node);
        toVisit.getExpression().accept(this);
        node.setExpression(this.pop(Exp.class));
        this.push(node);
    }

    @Override
    public void visitFunctionCall(FunctionCall toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        FunctionRef node = new FunctionRef();
        this.register(toVisit, node);
        toVisit.getFunctionDeclaration().accept(this);
        node.setDecl(this.pop(FunctionDecl.class));
        for (ArgumentMap aM : toVisit.getArgumentsList()) {
            aM.accept(this);
            node.addParam(this.pop(Exp.class));
        }
        this.push(node);
    }

    @Override
    public void visitCaseItem(CaseItem toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        Rule node = new Rule();
        this.register(toVisit, node);
        this.isLhs = true;
        toVisit.getExpression().accept(this);
        node.setLhs(this.pop(Pattern.class));
        this.isLhs = false;
        toVisit.getBlock().accept(this);
        node.setAction(this.pop(Statement.class));
        this.push(node);
    }

    @Override
    public void visitCaseStmt(CaseStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        obp.fiacre.model.CaseStmt node = new obp.fiacre.model.CaseStmt();
        this.register(toVisit, node);
        toVisit.getExpression().accept(this);
        node.setExp(this.pop(Exp.class));
        for (CaseItem cI : toVisit.getItemsList()) {
            cI.accept(this);
            node.addRule(this.pop(Rule.class));
        }
        this.push(node);
    }

    @Override
    public void visitAny(Any toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        AnyPattern node = new AnyPattern();
        this.register(toVisit, node);
        this.push(node);
    }

    @Override
    public void visitSendStmt(SendStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        toVisit.getPort().accept(this);
        VarRef port = this.fB.varRef(this.pop(ArgumentVariable.class));
        toVisit.getExpression().accept(this);
        Exp value = this.pop(Exp.class);
        To loop = this.fB.loopOn(this.currentTransition);
        this.fB.attachComment(loop, "should either be loop or on false, but we don't support any of them");
        obp.fiacre.model.IfStmt node = this.fB.ifStmt(this.fB.not(this.fB.full(port)), this.fB.assign(port, this.fB.enqueue(port, value)), loop);
        this.fB.attachComment(node, PrintVisitor.print(toVisit));
        this.register(toVisit, node);
        this.push(node);
    }

    @Override
    public void visitReceiveStmt(ReceiveStmt toVisit) {
    }

    @Override
    public void visitDeferredEvent(DeferredEvent toVisit) {
    }

    @Override
    public void visitGuardStmt(GuardStmt toVisit) {
        if (this.isRegistered(toVisit)) {
            return;
        }
        obp.fiacre.model.CaseStmt node = new obp.fiacre.model.CaseStmt();
        this.register(toVisit, node);
        toVisit.getExpression().accept(this);
        node.setExp(this.pop(Exp.class));
        Rule rule = new Rule();
        BoolLiteral b = new BoolLiteral();
        b.setValue(true);
        rule.setLhs(b);
        rule.setAction(new NullStmt());
        node.addRule(rule);
        this.push(node);
    }
}

