/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.ffi.try0;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import obp.fiacre.ffi.try0.Java2JniTypeExtractor;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayedType;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Field;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;

public class TFiacre2CValues
extends ModelVisitor.Stub {
    Map<Object, String> valueNameMap = new HashMap<Object, String>();
    Map<Object, String> fieldIndex2objectName = new HashMap<Object, String>();
    Map<Object, String> field2indexName = new HashMap<Object, String>();
    Stack<Object> fcrTypeContext = new Stack();
    Stack<String> jniObjectContext = new Stack();
    Stack<String> objectIndexStack = new Stack();
    boolean errorStatus = false;
    StringBuilder codeStream = new StringBuilder();
    Object root = null;
    boolean readRoot = false;
    int idx = 0;
    private String packageName;

    public TFiacre2CValues(String packageName, String objName, Object root) {
        this(packageName, objName, root, false, 0);
    }

    public TFiacre2CValues(String packageName, String objName, Object root, int initialIdx) {
        this(packageName, objName, root, false, initialIdx);
    }

    public TFiacre2CValues(String packageName, String objName, Object root, boolean readRoot, int initialIdx) {
        this.jniObjectContext.push(objName);
        this.fcrTypeContext.push(true);
        this.root = root;
        this.readRoot = readRoot;
        this.idx = initialIdx;
        this.packageName = packageName;
        this.objectIndexStack.push("idx00");
    }

    private String newName() {
        return "tmp" + this.idx++;
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        String myName = this.newName();
        this.valueNameMap.put(toVisit, myName);
        if (this.fcrTypeContext.peek() instanceof ArrayedType) {
            this.codeStream.append("\tjboolean * " + myName + " = (*env)->GetBooleanArrayElements(env, *((jbooleanArray*)(&" + this.jniObjectContext.peek() + ")), NULL);\n");
        } else {
            String code = "\tjboolean " + myName + " = (*env)->GetBooleanField(env, " + this.jniObjectContext.peek() + ", " + this.objectIndexStack.peek() + ");\n";
            this.codeStream.append(code);
        }
        this.fieldIndex2objectName.put(this.objectIndexStack.peek(), this.jniObjectContext.peek());
    }

    private void marshalInt(Type toVisit) {
        String myName = this.newName();
        this.valueNameMap.put(toVisit, myName);
        if (this.fcrTypeContext.peek() instanceof ArrayedType) {
            this.codeStream.append("\tjint * " + myName + " = (*env)->GetIntArrayElements(env, *((jintArray*)(&" + this.jniObjectContext.peek() + ")), NULL);\n");
        } else {
            String code = "\tjint " + myName + " = (*env)->GetIntField(env, " + this.jniObjectContext.peek() + ", " + this.objectIndexStack.peek() + ");\n";
            this.codeStream.append(code);
        }
        this.fieldIndex2objectName.put(this.objectIndexStack.peek(), this.jniObjectContext.peek());
    }

    @Override
    public void visitIntType(IntType toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitNatType(NatType toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitInterval(Interval toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitRecord(Record toVisit) {
        String myName = this.newName();
        String myObjName = myName + "Obj";
        String typeName = myName + "_ctype";
        if (this.fcrTypeContext.peek() instanceof ArrayedType) {
            System.err.println("Arrays with record elements are not supported yet for FFI calls!");
            this.errorStatus = true;
            return;
        }
        if (this.root != null && this.root != toVisit || this.readRoot) {
            this.codeStream.append("\tjobject " + myObjName + " = (*env)->GetObjectField(env, " + this.jniObjectContext.peek() + ", " + this.objectIndexStack.peek() + ");\n");
        } else {
            this.codeStream.append("\tjobject " + myObjName + " = " + this.jniObjectContext.peek() + ";\n");
        }
        this.fieldIndex2objectName.put(this.objectIndexStack.peek(), this.jniObjectContext.peek());
        this.codeStream.append("\tjclass " + myName + "Class = (*env)->GetObjectClass(env, " + myObjName + ");\n");
        this.valueNameMap.put(toVisit, myName);
        this.jniObjectContext.push(myObjName);
        int fieldIdx = 0;
        for (Field field : toVisit.getFieldList()) {
            Java2JniTypeExtractor typer = new Java2JniTypeExtractor();
            typer.packageName = this.packageName;
            field.getType().accept(typer);
            String fieldIdxName = myObjName + fieldIdx;
            this.codeStream.append("\tjfieldID " + fieldIdxName + " = (*env)->GetFieldID(env, " + myName + "Class, \"" + field.getName() + "\", \"" + typer.jniSignature + "\");\n");
            this.objectIndexStack.push(fieldIdxName);
            this.field2indexName.put(field, fieldIdxName);
            field.getType().accept(this);
            this.objectIndexStack.pop();
            ++fieldIdx;
        }
        this.jniObjectContext.pop();
        if (this.root != null && this.root != toVisit || this.readRoot) {
            this.codeStream.append("\t" + typeName + " " + myName + ";\n");
            for (Field field : toVisit.getFieldList()) {
                this.valueNameMap.put(field, myName + "." + field.getName());
                this.codeStream.append("\t" + myName + "." + field.getName() + " = " + this.valueNameMap.get(field.getType()) + ";\n");
            }
        }
    }

    private void marshalArrayedType(ArrayedType toVisit) {
        String myName = this.newName();
        String myObjectName = myName + "obj";
        if (this.fcrTypeContext.peek() instanceof ArrayedType) {
            System.err.println("Multidimensional arrays are not supported yet for FFI calls!");
            this.errorStatus = true;
            return;
        }
        this.valueNameMap.put(toVisit, myName);
        this.codeStream.append("\tjobject " + myObjectName + " = (*env)->GetObjectField(env, " + this.jniObjectContext.peek() + ", " + this.objectIndexStack.peek() + ");\n");
        this.fieldIndex2objectName.put(this.objectIndexStack.peek(), this.jniObjectContext.peek());
        this.fcrTypeContext.push(toVisit);
        this.jniObjectContext.push(myObjectName);
        toVisit.getType().accept(this);
        this.jniObjectContext.pop();
        this.fcrTypeContext.pop();
    }

    @Override
    public void visitArray(Array toVisit) {
        this.marshalArrayedType(toVisit);
    }

    @Override
    public void visitUnion(Union toVisit) {
    }

    @Override
    public void visitQueue(Queue toVisit) {
        this.marshalArrayedType(toVisit);
    }

    @Override
    public void visitTypeId(TypeId toVisit) {
        this.fcrTypeContext.push(toVisit);
        toVisit.getDecl().accept(this);
        this.fcrTypeContext.pop();
        this.valueNameMap.put(toVisit, this.valueNameMap.get(toVisit.getDecl()));
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        this.fcrTypeContext.push(toVisit);
        toVisit.getIs().accept(this);
        this.fcrTypeContext.pop();
        this.valueNameMap.put(toVisit, this.valueNameMap.get(toVisit.getIs()));
    }
}

