/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tla2sany.semantic.SemanticNode;
import tlc2.tool.FingerprintException;
import tlc2.util.Context;
import tlc2.value.MVPerm;
import tlc2.value.Value;
import tlc2.value.ValueExcept;
import util.Assert;
import util.ToolIO;

public class LazyValue
extends Value {
    private static final boolean LAZYEVAL_OFF = Boolean.getBoolean(LazyValue.class.getName() + ".off");
    public SemanticNode expr;
    public Context con;
    private Value val;

    public LazyValue(SemanticNode expr, Context con) {
        this(expr, con, true);
    }

    public LazyValue(SemanticNode expr, Context con, boolean cachable) {
        this.expr = expr;
        this.con = con;
        this.val = null;
        if (LAZYEVAL_OFF || !cachable) {
            this.val = ValUndef;
        }
    }

    public final boolean isUncachable() {
        return this.val == ValUndef;
    }

    public final void setValue(Value aValue) {
        assert (!this.isUncachable());
        this.val = aValue;
    }

    public final Value getValue() {
        return this.val;
    }

    @Override
    public final byte getKind() {
        return 25;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (this.val == null || this.val == ValUndef) {
                Assert.fail("Error(TLC): Attempted to compare lazy values.");
            }
            return this.val.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (this.val == null || this.val == ValUndef) {
                Assert.fail("Error(TLC): Attempted to check equality of lazy values.");
            }
            return this.val.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            if (this.val == null || this.val == ValUndef) {
                Assert.fail("Error(TLC): Attempted to check set membership of lazy values.");
            }
            return this.val.member(elem);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            if (this.val == null || this.val == ValUndef) {
                Assert.fail("Error(TLC): Attempted to check if a lazy value is a finite set.");
            }
            return this.val.isFinite();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (this.val == null || this.val == ValUndef) {
                Assert.fail("Error(TLC): Attempted to apply EXCEPT construct to lazy value.");
            }
            return this.val.takeExcept(ex);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (this.val == null || this.val == ValUndef) {
                Assert.fail("Error(TLC): Attempted to apply EXCEPT construct to lazy value.");
            }
            return this.val.takeExcept(exs);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            if (this.val == null || this.val == ValUndef) {
                Assert.fail("Error(TLC): Attempted to compute size of lazy value.");
            }
            return this.val.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.val = (Value)ois.readObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.val == null || this.val == ValUndef) {
            Assert.fail("Error(TLC): Attempted to serialize lazy value.");
        }
        oos.writeObject(this.val);
    }

    @Override
    public final boolean isNormalized() {
        try {
            if (this.val == null || this.val == ValUndef) {
                Assert.fail("Error(TLC): Attempted to normalize lazy value.");
            }
            return this.val.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.val == null || this.val == ValUndef) {
                Assert.fail("Error(TLC): Attempted to normalize lazy value.");
            }
            this.val.normalize();
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final Value deepCopy() {
        try {
            if (this.val == null || this.val == ValUndef) {
                return this;
            }
            return this.val.deepCopy();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            if (this.val == null || this.val == ValUndef) {
                Assert.fail("Error(TLC): Attempted to call assignable on lazy value.");
            }
            return this.val.assignable(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            if (this.val == null || this.val == ValUndef) {
                Assert.fail("Error(TLC): Attempted to fingerprint a lazy value.");
            }
            return this.val.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        try {
            if (this.val == null || this.val == ValUndef) {
                Assert.fail("Error(TLC): Attempted to apply permutation to lazy value.");
            }
            return this.val.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            if (this.val == null || this.val == ValUndef) {
                return sb.append("<LAZY " + this.expr + ">");
            }
            return this.val.toString(sb, offset);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    static {
        if (LAZYEVAL_OFF) {
            ToolIO.out.println("LazyValue is disabled.");
        }
    }
}

