/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.grammar.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.petitparser.grammar.json.JsonGrammar;
import org.petitparser.utils.Functions;

public class JsonParser
extends JsonGrammar {
    @Override
    protected void initialize() {
        super.initialize();
        this.action("elements", Functions.withoutSeparators());
        this.action("members", Functions.withoutSeparators());
        this.action("array", new Function<List<List<?>>, List<?>>(){

            @Override
            public List<?> apply(List<List<?>> input) {
                return input.get(1) != null ? input.get(1) : new ArrayList();
            }
        });
        this.action("object", new Function<List<List<List<Object>>>, Map<Object, Object>>(){

            @Override
            public Map<Object, Object> apply(List<List<List<Object>>> input) {
                LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
                if (input.get(1) != null) {
                    for (List<Object> list : input.get(1)) {
                        result.put(list.get(0), list.get(2));
                    }
                }
                return result;
            }
        });
        this.action("trueToken", Functions.constant((Object)true));
        this.action("falseToken", Functions.constant((Object)false));
        this.action("nullToken", Functions.constant(null));
        this.redef("stringToken", this.ref("stringPrimitive").trim());
        this.action("numberToken", new Function<String, Number>(){

            @Override
            public Number apply(String input) {
                long integral;
                double floating = Double.parseDouble(input);
                if (floating == (double)(integral = (long)floating) && input.indexOf(46) == -1) {
                    return integral;
                }
                return floating;
            }
        });
        this.action("stringPrimitive", new Function<List<List<Character>>, String>(){

            @Override
            public String apply(List<List<Character>> input) {
                return JsonGrammar.listToString((Collection<Character>)input.get(1));
            }
        });
        this.action("characterEscape", Functions.lastOfList());
        this.action("characterEscape", ESCAPE_TABLE_FUNCTION);
        this.action("characterOctal", new Function<List<String>, Character>(){

            @Override
            public Character apply(List<String> input) {
                return Character.valueOf(Character.toChars(Integer.parseInt(input.get(1), 16))[0]);
            }
        });
    }
}

