/*
 * Decompiled with CFR 0.152.
 */
package spinja.store;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import spinja.store.StateStore;
import spinja.store.hash.HashAlgorithm;
import spinja.store.hash.JenkinsHash;
import sun.misc.Unsafe;

public class AtomicHashTable
extends StateStore {
    private static Unsafe unsafe = null;
    private static final int indexOffset;
    private static final int indexScale;
    private static final long nextOffset;
    private volatile HashTable current;
    private final ExecutorService executors;

    private static final long rawIndex(int n) {
        return indexOffset + n * indexScale;
    }

    public AtomicHashTable(int n) {
        this.current = new HashTable(n);
        this.executors = Executors.newSingleThreadExecutor();
    }

    @Override
    public int addState(byte[] byArray) {
        return this.current.addState(byArray);
    }

    @Override
    public long getBytes() {
        return this.current.getBytes();
    }

    @Override
    public int getStored() {
        return this.current.getStored();
    }

    @Override
    public void printSummary() {
        this.current.printSummary();
    }

    public int getRealStored() {
        int n = 0;
        for (byte[] byArray : this.current.table) {
            if (byArray == null) continue;
            ++n;
        }
        return n;
    }

    public void shutdown() {
        this.executors.shutdown();
    }

    public void awaitTermination(int n, TimeUnit timeUnit) throws InterruptedException {
        this.executors.awaitTermination(n, timeUnit);
    }

    static {
        try {
            Class<Unsafe> clazz = Unsafe.class;
            Field field = clazz.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(clazz);
            indexOffset = unsafe.arrayBaseOffset(byte[][].class);
            indexScale = unsafe.arrayIndexScale(byte[][].class);
            nextOffset = unsafe.objectFieldOffset(HashTable.class.getDeclaredField("next"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    private final class HashTable
    extends StateStore {
        private final byte[] tombstone = new byte[0];
        private HashTable next;
        private final byte[][] table;
        private volatile int collisions;
        private volatile int stored;
        private final int size;
        private final int maxIterations;
        private final int maxStored;
        private volatile long bytes;
        private final HashAlgorithm hash;
        private final int mask;

        public HashTable(int n) {
            this(n, new JenkinsHash());
        }

        public HashTable(int n, HashAlgorithm hashAlgorithm) {
            this.table = new byte[1 << n][];
            this.stored = 0;
            this.collisions = 0;
            this.size = n;
            this.maxIterations = this.table.length;
            this.maxStored = (int)((double)this.table.length * 0.9);
            this.bytes = 56 + 4 * this.table.length;
            this.hash = hashAlgorithm;
            this.mask = this.table.length - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addState(byte[] byArray) {
            Object object;
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (this.next == null && this.stored >= this.maxStored) {
                new DoubleSize();
            }
            HashAlgorithm.HashGenerator hashGenerator = this.hash.hash(byArray);
            int n = hashGenerator.currentHash() & this.mask;
            int n2 = 0;
            while (!unsafe.compareAndSwapObject(this.table, AtomicHashTable.rawIndex(n), null, byArray)) {
                object = (byte[])unsafe.getObjectVolatile(this.table, AtomicHashTable.rawIndex(n));
                if (object == this.tombstone) {
                    return this.next.addState(byArray);
                }
                if (Arrays.equals((byte[])object, byArray)) {
                    return -n - 1;
                }
                if (n2 >= this.maxIterations) {
                    new DoubleSize();
                    return this.next.addState(byArray);
                }
                ++n2;
                n = hashGenerator.nextHash() & this.mask;
            }
            object = this;
            synchronized (object) {
                ++this.stored;
                this.bytes += (long)(19 + (byArray.length >> 3 << 3));
                this.collisions += n2;
            }
            return n;
        }

        @Override
        public long getBytes() {
            return this.bytes;
        }

        public int getCollisions() {
            return this.collisions;
        }

        @Override
        public int getStored() {
            return this.stored;
        }

        @Override
        public void printSummary() {
            System.out.printf("hash conflicts: %d (resolved)\n", this.getCollisions());
            System.out.println();
        }

        private final class DoubleSize
        implements Runnable {
            private final boolean run;

            public DoubleSize() {
                this.run = unsafe.compareAndSwapObject(HashTable.this, nextOffset, null, new HashTable(HashTable.this.size + 1));
                AtomicHashTable.this.executors.execute(this);
            }

            @Override
            public void run() {
                if (this.run) {
                    System.err.println("spinja: warning, more than 90% of the hash table is full, increasing size to -w" + (HashTable.this.size + 1) + "..");
                    for (int i = 0; i < HashTable.this.table.length; ++i) {
                        byte[] byArray = HashTable.this.table[i];
                        if (unsafe.compareAndSwapObject(HashTable.this.table, AtomicHashTable.rawIndex(i), null, HashTable.this.tombstone)) continue;
                        HashTable.this.next.addState(byArray);
                    }
                    AtomicHashTable.this.current = HashTable.this.next;
                    System.err.println("done with -w" + (HashTable.this.size + 1));
                }
            }
        }
    }
}

