/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.model;

import spinja.concurrent.model.ConcurrentModel;
import spinja.exceptions.ValidationException;
import spinja.model.listener.TransitionEvent;
import spinja.model.listener.TransitionListener;
import spinja.promela.model.PromelaModel;
import spinja.promela.model.PromelaProcess;
import spinja.promela.model.PromelaTransition;
import spinja.util.DataReader;
import spinja.util.DataWriter;

public class NeverClaimModel
extends ConcurrentModel<PromelaTransition>
implements TransitionListener {
    private final PromelaModel model;
    private final PromelaProcess neverProc;
    private boolean _turn;

    public static ConcurrentModel<PromelaTransition> createNever(PromelaModel promelaModel) throws ValidationException {
        PromelaProcess promelaProcess = promelaModel.getNever();
        if (promelaProcess != null) {
            return new NeverClaimModel(promelaModel, promelaProcess);
        }
        return promelaModel;
    }

    NeverClaimModel(PromelaModel promelaModel, PromelaProcess promelaProcess) {
        this.model = promelaModel;
        promelaModel.addTransitionListener(this);
        this.neverProc = promelaProcess;
        this._turn = true;
    }

    @Override
    public String getName() {
        return this.model.getName() + "-with-never-claim";
    }

    @Override
    public int getNrProcesses() {
        if (this._turn) {
            return 1;
        }
        return this.model.getNrProcesses();
    }

    public PromelaProcess getProcess(int n) {
        if (this._turn) {
            if (n == 0) {
                return this.neverProc;
            }
            throw new IndexOutOfBoundsException();
        }
        return this.model.getProcess(n);
    }

    @Override
    public int getSize() {
        return this.model.getSize() + this.neverProc.getSize() + 1;
    }

    @Override
    public NeverClaimModel clone() {
        return new NeverClaimModel(this.model, this.neverProc);
    }

    @Override
    public boolean conditionHolds(int n) {
        if (!this._turn) {
            if (n == 4) {
                return false;
            }
            return this.neverProc.conditionHolds(n);
        }
        return this.model.conditionHolds(n);
    }

    @Override
    public PromelaTransition nextTransition(PromelaTransition promelaTransition) {
        if (this._turn) {
            return this.neverProc.nextTransition(promelaTransition);
        }
        return this.model.nextTransition(promelaTransition);
    }

    @Override
    public boolean decode(DataReader dataReader) {
        this._turn = dataReader.readBoolean();
        return this.neverProc.decode(dataReader) && this.model.decode(dataReader);
    }

    @Override
    public void encode(DataWriter dataWriter) {
        dataWriter.writeBoolean(this._turn);
        this.neverProc.encode(dataWriter);
        this.model.encode(dataWriter);
    }

    @Override
    public String toString() {
        return this.model.toString() + this.neverProc.toString();
    }

    @Override
    public void transitionTaken(TransitionEvent transitionEvent) {
        this._turn = !this._turn;
    }

    @Override
    public void transitionUndo(TransitionEvent transitionEvent) {
        this._turn = !this._turn;
    }
}

