/*
 * Decompiled with CFR 0.152.
 */
package obp.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import obp.cc.ConcreteContext;
import obp.cc.State;
import obp.cc.Transition;
import obp.obs.Observer;
import obp.predicate.Predicate;
import obp.transfo.cc.ConcreteContextCache;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.JBoost;

public class ConcreteContextUtil {
    private static JBoost createBoost() {
        return new JBoost("cc", 1);
    }

    public static ConcreteContext loadCC(File file) throws FileNotFoundException {
        return ConcreteContextUtil.loadCC(new FileInputStream(file));
    }

    public static ConcreteContext loadCC(InputStream in) {
        JBoost boost = ConcreteContextUtil.createBoost();
        boost.initializeZippedReading(new ZipInputStream(in), "cc");
        ConcreteContext cc = (ConcreteContext)boost.readObject(ConcreteContext.class);
        boost.close();
        return cc;
    }

    public static void saveCC(ConcreteContext cc, File file) throws FileNotFoundException {
        ConcreteContextUtil.saveCC(cc, new FileOutputStream(file));
    }

    public static void saveCC(ConcreteContext cc, OutputStream out) {
        JBoost boost = ConcreteContextUtil.createBoost();
        boost.initializeZippedWriting(new ZipOutputStream(out), "cc");
        boost.writeObject((BoostObject)cc);
        boost.close();
    }

    public static byte[] writeCC(ConcreteContext cc) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JBoost boost = ConcreteContextUtil.createBoost();
        boost.initializeZippedWriting(new ZipOutputStream(out), "cc");
        boost.writeObject((BoostObject)cc);
        boost.close();
        return out.toByteArray();
    }

    public static ConcreteContext copyConcreteContext(ConcreteContext original) {
        if (original == null) {
            return null;
        }
        ConcreteContext copy = new ConcreteContext();
        copy.setName(original.getName());
        HashMap<State, State> originalToCopyState = new HashMap<State, State>();
        for (State state : original.getStateList()) {
            State copyState = ConcreteContextUtil.copyState(state);
            copy.addState(copyState);
            originalToCopyState.put(state, copyState);
        }
        copy.setStartState((State)originalToCopyState.get(original.getStartState()));
        copy.setStopState((State)originalToCopyState.get(original.getStopState()));
        for (Transition transition : original.getTransitionList()) {
            Transition copyTransition = ConcreteContextUtil.copyTransition(transition);
            copyTransition.setSource((State)originalToCopyState.get(transition.getSource()));
            copyTransition.setTarget((State)originalToCopyState.get(transition.getTarget()));
            copy.addTransition(copyTransition);
        }
        return copy;
    }

    public static void copyObserversAndAsserts(ConcreteContext source, ConcreteContext destination) {
        if (source == null || destination == null) {
            return;
        }
        for (Observer observer : source.getObserverList()) {
            destination.addObserver(observer);
        }
        for (Predicate predicate : source.getAssertList()) {
            destination.addAssert(predicate);
        }
        destination.setFoldingPredicate(source.getFoldingPredicate());
    }

    public static Transition copyTransition(Transition original) {
        Transition newTransition = new Transition();
        newTransition.setAction(original.getAction());
        return newTransition;
    }

    public static State copyState(State original) {
        State newState = new State();
        newState.setUnstable(original.isUnstable());
        return newState;
    }

    public static BigInteger countPaths(ConcreteContext cc) throws InterruptedException {
        float ratio = (float)cc.getTransitionCount() / (float)cc.getStateCount();
        if (ratio > 5.0f) {
            return ConcreteContextUtil.countPathsOptimizedForAlternatives(cc);
        }
        return ConcreteContextUtil.countPathsSimple(cc);
    }

    public static BigInteger countPathsSimple(ConcreteContext cc) throws InterruptedException {
        ConcreteContextCache cache = new ConcreteContextCache(cc);
        BigInteger result = BigInteger.ZERO;
        long count = 0L;
        LinkedList<Context> context = new LinkedList<Context>();
        context.addLast(new Context(cc.getStartState(), -1));
        while (!context.isEmpty()) {
            if (count >= 500000L) {
                result = result.add(BigInteger.valueOf(count));
                count = 0L;
                Thread.sleep(0L);
            }
            Context current = (Context)context.peekLast();
            ++current.transitionIndex;
            List<Transition> outTransitions = cache.getOutTransitions(current.state);
            if (current.transitionIndex < outTransitions.size()) {
                Transition transition = outTransitions.get(current.transitionIndex);
                State state = transition.getTarget();
                if (cc.getStopState().equals(state)) {
                    ++count;
                    continue;
                }
                context.addLast(new Context(state, -1));
                continue;
            }
            context.removeLast();
        }
        result = result.add(BigInteger.valueOf(count));
        return result;
    }

    public static BigInteger countPathsOptimizedForAlternatives(ConcreteContext cc) throws InterruptedException {
        ConcreteContextCache cache = new ConcreteContextCache(cc);
        BigInteger result = BigInteger.ZERO;
        long count = 0L;
        LinkedList<Context> context = new LinkedList<Context>();
        context.addLast(new Context(cc.getStartState(), -1));
        while (!context.isEmpty()) {
            Transition transition;
            if (count >= 500000L) {
                result = result.add(BigInteger.valueOf(count));
                count = 0L;
                Thread.sleep(0L);
            }
            Context current = (Context)context.peekLast();
            ++current.transitionIndex;
            List<Transition> outTransitions = cache.getOutTransitions(current.state);
            current.weight = 1;
            while (current.transitionIndex < outTransitions.size() - 1) {
                transition = outTransitions.get(current.transitionIndex);
                Transition nextTransition = outTransitions.get(current.transitionIndex + 1);
                if (transition.getTarget() != nextTransition.getTarget()) break;
                ++current.transitionIndex;
                ++current.weight;
            }
            if (current.transitionIndex < outTransitions.size()) {
                transition = outTransitions.get(current.transitionIndex);
                State state = transition.getTarget();
                if (cc.getStopState().equals(state)) {
                    long localCount = 1L;
                    for (Context oneContext : context) {
                        localCount *= (long)oneContext.weight;
                    }
                    count += localCount;
                    continue;
                }
                context.addLast(new Context(state, -1));
                continue;
            }
            context.removeLast();
        }
        result = result.add(BigInteger.valueOf(count));
        return result;
    }

    public static boolean hasOnePath(ConcreteContext cc) {
        ConcreteContextCache cache = new ConcreteContextCache(cc);
        int count = 0;
        LinkedList<Context> context = new LinkedList<Context>();
        context.addLast(new Context(cc.getStartState(), -1));
        while (!context.isEmpty()) {
            Context current = (Context)context.peekLast();
            ++current.transitionIndex;
            List<Transition> outTransitions = cache.getOutTransitions(current.state);
            if (current.transitionIndex < outTransitions.size()) {
                Transition transition = outTransitions.get(current.transitionIndex);
                State state = transition.getTarget();
                if (cc.getStopState().equals(state)) {
                    if ((count = (int)((short)(count + 1))) <= 1) continue;
                    return false;
                }
                context.addLast(new Context(state, -1));
                continue;
            }
            context.removeLast();
        }
        assert (count == 1);
        return true;
    }

    public static BigInteger countPathsLinear(ConcreteContext cc) {
        ConcreteContextCache cache = new ConcreteContextCache(cc);
        List<State> states = cc.getStateList();
        BigInteger[] count = new BigInteger[cc.getStateCount()];
        for (int i = cc.getStateCount() - 1; i >= 0; --i) {
            count[i] = BigInteger.ZERO;
            List<Transition> fanout = cache.getOutTransitions(states.get(i));
            if (fanout.size() == 0) {
                count[i] = BigInteger.ONE;
                continue;
            }
            for (Transition t : fanout) {
                int j = states.indexOf(t.getTarget());
                count[i] = count[i].add(count[j]);
            }
        }
        return count[0];
    }

    public static int maxAccumulatedReachability(ConcreteContext cc) {
        ConcreteContextCache cache = new ConcreteContextCache(cc);
        boolean[] reach = new boolean[cc.getStateCount()];
        List<State> states = cc.getStateList();
        int maxReach = 0;
        int farthestState = 0;
        for (int i = 0; i < cc.getStateCount(); ++i) {
            reach[i] = true;
            if (i > farthestState) {
                farthestState = i;
            }
            for (Transition t : cache.getOutTransitions(states.get(i))) {
                State target = t.getTarget();
                int targetId = states.indexOf(target);
                reach[targetId] = true;
                if (targetId <= farthestState) continue;
                farthestState = targetId;
            }
            int currentReach = 0;
            for (int j = i; j < farthestState; ++j) {
                currentReach += reach[j] ? 1 : 0;
            }
            if (currentReach > maxReach) {
                maxReach = currentReach;
            }
            reach[i] = false;
        }
        return maxReach;
    }

    public static class Context {
        public final State state;
        public int transitionIndex;
        public int weight;

        public Context(State state, int transitionIndex) {
            this.state = state;
            this.transitionIndex = transitionIndex;
            this.weight = 0;
        }
    }
}

