/*
 * Decompiled with CFR 0.152.
 */
package obp.states;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import obp.aut.parser.AutParser;
import obp.states.States;
import obp.states.parser.StatesLexer;
import obp.states.parser.StatesParser;

public class Main {
    private static String[] octetUnits = new String[]{"o", "ko", "mo", "go", "to"};

    public static void main(String[] args) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        File statesFile = new File("tests/GC_0/diagnostic.states");
        for (int i = 0; i < 3; ++i) {
            runtime.gc();
            long start = System.currentTimeMillis();
            long startTotalMem = runtime.totalMemory();
            long startFreeMem = runtime.freeMemory();
            BufferedInputStream statesStream = new BufferedInputStream(new FileInputStream(statesFile));
            StatesLexer statesLexer = new StatesLexer(statesStream);
            StatesParser statesParser = new StatesParser();
            States states = (States)statesParser.parse(statesLexer);
            runtime.gc();
            long end = System.currentTimeMillis();
            long endTotalMem = runtime.totalMemory();
            long endFreeMem = runtime.freeMemory();
            long usedMem = endTotalMem - endFreeMem - (startTotalMem - startFreeMem);
            System.out.println("Parse " + statesFile.getPath() + " (" + Main.formatOctet(statesFile.length()) + ", " + states.getStateCount() + " states) in " + (end - start) + "ms.");
            System.out.println("Tooks " + Main.formatOctet(usedMem));
        }
        File autFile = new File("tests/GC_0/diagnostic.aut");
        for (int i = 0; i < 3; ++i) {
            runtime.gc();
            long start = System.currentTimeMillis();
            long startTotalMem = runtime.totalMemory();
            long startFreeMem = runtime.freeMemory();
            BufferedInputStream autStream = new BufferedInputStream(new FileInputStream(autFile));
            AutParser parser = new AutParser(autStream);
            parser.parse();
            runtime.gc();
            long end = System.currentTimeMillis();
            long endTotalMem = runtime.totalMemory();
            long endFreeMem = runtime.freeMemory();
            long usedMem = endTotalMem - endFreeMem - (startTotalMem - startFreeMem);
            System.out.println("Parse " + autFile.getPath() + " (" + Main.formatOctet(autFile.length()) + ") in " + (end - start) + "ms.");
            System.out.println("Tooks " + Main.formatOctet(usedMem));
            runtime.gc();
        }
    }

    public static String formatOctet(long value) {
        int unit;
        for (unit = 0; value > 1024L && unit < octetUnits.length - 1; value /= 1024L, ++unit) {
        }
        return Long.toString(value) + " " + octetUnits[unit];
    }
}

