/*
 * Decompiled with CFR 0.152.
 */
package DVE.compiler.builder;

import DVE.model.ArrayLiteral;
import DVE.model.ArrayType;
import DVE.model.Assignment;
import DVE.model.BinaryExpression;
import DVE.model.BinaryOperator;
import DVE.model.ByteType;
import DVE.model.ChannelDeclaration;
import DVE.model.ChannelReference;
import DVE.model.ConstantDeclaration;
import DVE.model.Expression;
import DVE.model.IndexedExpression;
import DVE.model.InputSynchronization;
import DVE.model.IntegerType;
import DVE.model.Literal;
import DVE.model.ModelFactory;
import DVE.model.NumberLiteral;
import DVE.model.OutputSynchronization;
import DVE.model.Process;
import DVE.model.ProcessReference;
import DVE.model.ProcessStateReference;
import DVE.model.State;
import DVE.model.StateReference;
import DVE.model.System;
import DVE.model.Type;
import DVE.model.TypedChannelDeclaration;
import DVE.model.UnaryExpression;
import DVE.model.UnaryOperator;
import DVE.model.VariableDeclaration;
import DVE.model.VariableReference;
import java.math.BigInteger;
import java.util.List;

public class DVEBuilder {
    public static DVEBuilder uniqueInstance = new DVEBuilder();
    ModelFactory dveFactory = ModelFactory.eINSTANCE;

    public Expression binaryExpression(Expression lhs, BinaryOperator op, Expression rhs) {
        BinaryExpression exp = this.dveFactory.createBinaryExpression();
        exp.setOperator(op);
        exp.getOperands().add((Object)lhs);
        exp.getOperands().add((Object)rhs);
        return exp;
    }

    public Literal literal(boolean bool) {
        return bool ? this.dveFactory.createTrueLiteral() : this.dveFactory.createFalseLiteral();
    }

    public Literal literal(BigInteger i) {
        NumberLiteral num = this.dveFactory.createNumberLiteral();
        num.setValue(i);
        return num;
    }

    public Literal literal(int i) {
        NumberLiteral num = this.dveFactory.createNumberLiteral();
        num.setValue(BigInteger.valueOf(i));
        return num;
    }

    public Literal literal(List<Expression> exps) {
        ArrayLiteral lit = this.dveFactory.createArrayLiteral();
        lit.getValues().addAll(exps);
        return lit;
    }

    public Expression imply(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.IMPLY, rhs);
    }

    public Expression or(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.OR, rhs);
    }

    public Expression and(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.AND, rhs);
    }

    public Expression bor(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.BOR, rhs);
    }

    public Expression band(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.BAND, rhs);
    }

    public Expression bxor(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.BXOR, rhs);
    }

    public Expression eq(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.EQ, rhs);
    }

    public Expression neq(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.NEQ, rhs);
    }

    public Expression lt(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.LT, rhs);
    }

    public Expression leq(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.LEQ, rhs);
    }

    public Expression gt(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.GT, rhs);
    }

    public Expression geq(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.GEQ, rhs);
    }

    public Expression shl(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.SHL, rhs);
    }

    public Expression shr(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.SHR, rhs);
    }

    public Expression minus(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.MINUS, rhs);
    }

    public Expression plus(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.PLUS, rhs);
    }

    public Expression mult(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.MULT, rhs);
    }

    public Expression div(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.DIV, rhs);
    }

    public Expression mod(Expression lhs, Expression rhs) {
        return this.binaryExpression(lhs, BinaryOperator.MOD, rhs);
    }

    public Expression unaryExpression(UnaryOperator op, Expression rhs) {
        UnaryExpression exp = this.dveFactory.createUnaryExpression();
        exp.setOperator(op);
        exp.setOperand(rhs);
        return exp;
    }

    public Expression minus(Expression rhs) {
        return this.unaryExpression(UnaryOperator.MINUS, rhs);
    }

    public Expression bnot(Expression rhs) {
        return this.unaryExpression(UnaryOperator.BNOT, rhs);
    }

    public Expression not(Expression rhs) {
        return this.unaryExpression(UnaryOperator.NOT, rhs);
    }

    public Expression indexedExpression(Expression base, Expression index) {
        IndexedExpression exp = this.dveFactory.createIndexedExpression();
        exp.setBase(base);
        exp.setIndex(index);
        return exp;
    }

    public Expression processStateReference(Process proc, State state) {
        ProcessStateReference exp = this.dveFactory.createProcessStateReference();
        exp.setPrefix(this.reference(proc));
        exp.setRef(state);
        return exp;
    }

    public VariableDeclaration variableDeclaration(String name, Type type, Expression initial) {
        VariableDeclaration vdecl = this.dveFactory.createVariableDeclaration();
        vdecl.setName(name);
        vdecl.setType(type);
        vdecl.setInitial(initial);
        return vdecl;
    }

    public ConstantDeclaration constantDeclaration(String name, Type type, Expression initial) {
        ConstantDeclaration vdecl = this.dveFactory.createConstantDeclaration();
        vdecl.setName(name);
        vdecl.setType(type);
        vdecl.setInitial(initial);
        return vdecl;
    }

    public IntegerType intType() {
        return this.dveFactory.createIntegerType();
    }

    public ByteType byteType() {
        return this.dveFactory.createByteType();
    }

    public ArrayType arrayType(Type etype, int size) {
        ArrayType type = this.dveFactory.createArrayType();
        type.setElementType(etype);
        type.setSize(this.literal(size));
        return type;
    }

    public ArrayType arrayType(Type etype, Expression size) {
        ArrayType type = this.dveFactory.createArrayType();
        type.setElementType(etype);
        type.setSize(size);
        return type;
    }

    public ChannelDeclaration channelDeclaration(String name) {
        ChannelDeclaration c = this.dveFactory.createChannelDeclaration();
        c.setName(name);
        return c;
    }

    public TypedChannelDeclaration typedChannelDeclaration(String name, List<Type> types, int bufferSize) {
        TypedChannelDeclaration tcd = this.dveFactory.createTypedChannelDeclaration();
        tcd.setName(name);
        tcd.setBufferSize(this.literal(bufferSize));
        tcd.getTypes().addAll(types);
        return tcd;
    }

    public State state(String name) {
        State s = this.dveFactory.createState();
        s.setName(name);
        return s;
    }

    public InputSynchronization input(ChannelReference chan, Expression exp) {
        InputSynchronization is = this.dveFactory.createInputSynchronization();
        is.setChannel(chan);
        is.setValue(exp);
        return is;
    }

    public OutputSynchronization output(ChannelReference chan, Expression exp) {
        OutputSynchronization is = this.dveFactory.createOutputSynchronization();
        is.setChannel(chan);
        is.setValue(exp);
        return is;
    }

    public ChannelReference reference(ChannelDeclaration decl) {
        ChannelReference cr = this.dveFactory.createChannelReference();
        cr.setRef(decl);
        return cr;
    }

    public ChannelReference channelReference(String name) {
        ChannelReference cr = this.dveFactory.createChannelReference();
        cr.setRefName(name);
        return cr;
    }

    public VariableReference reference(VariableDeclaration decl) {
        VariableReference vr = this.dveFactory.createVariableReference();
        vr.setRef(decl);
        return vr;
    }

    public VariableReference reference(VariableReference vr0) {
        VariableReference vr = this.dveFactory.createVariableReference();
        vr.setRef(vr0.getRef());
        return vr;
    }

    public VariableReference variableReference(String name) {
        VariableReference vr = this.dveFactory.createVariableReference();
        vr.setRefName(name);
        return vr;
    }

    public StateReference reference(State s) {
        StateReference sr = this.dveFactory.createStateReference();
        sr.setRef(s);
        return sr;
    }

    public StateReference stateReference(String s) {
        StateReference sr = this.dveFactory.createStateReference();
        sr.setRefName(s);
        return sr;
    }

    public ProcessReference reference(Process p) {
        ProcessReference pr = this.dveFactory.createProcessReference();
        pr.setRef(p);
        return pr;
    }

    public ProcessReference processReference(String name) {
        ProcessReference pr = this.dveFactory.createProcessReference();
        pr.setRefName(name);
        return pr;
    }

    public Assignment assign(Expression lhs, Expression rhs) {
        Assignment assign = this.dveFactory.createAssignment();
        assign.setLhs(lhs);
        assign.setRhs(rhs);
        return assign;
    }

    public System system() {
        return this.dveFactory.createSystem();
    }
}

