/*
 * Decompiled with CFR 0.152.
 */
package DVE.compiler;

import DVE.compiler.builder.DVEBuilder;
import DVE.model.ArrayLiteral;
import DVE.model.Assignment;
import DVE.model.BinaryExpression;
import DVE.model.ChannelDeclaration;
import DVE.model.ChannelReference;
import DVE.model.ConstantDeclaration;
import DVE.model.Element;
import DVE.model.Expression;
import DVE.model.IndexedExpression;
import DVE.model.InputSynchronization;
import DVE.model.NamedDeclaration;
import DVE.model.OutputSynchronization;
import DVE.model.Process;
import DVE.model.ProcessReference;
import DVE.model.ProcessStateReference;
import DVE.model.ProcessVariableReference;
import DVE.model.Reference;
import DVE.model.State;
import DVE.model.StateReference;
import DVE.model.Synchronization;
import DVE.model.System;
import DVE.model.SystemProperties;
import DVE.model.Transition;
import DVE.model.UnaryExpression;
import DVE.model.VariableDeclaration;
import DVE.model.VariableReference;
import DVE.model.util.ModelSwitch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class DVENameResolver {
    DVEBuilder builder = new DVEBuilder();
    Map<String, NamedDeclaration> globalNames = new HashMap<String, NamedDeclaration>();
    Map<Process, Map<String, NamedDeclaration>> processNames = new HashMap<Process, Map<String, NamedDeclaration>>();
    Stack<NamedDeclaration> context = new Stack();
    Set<Reference> unresolvedSet = new HashSet<Reference>();
    boolean failed = false;
    ModelSwitch<Boolean> modelSwitch = new ModelSwitch<Boolean>(){

        @Override
        public Boolean caseSystem(System object) {
            DVENameResolver.this.context.push(object);
            for (NamedDeclaration nD : object.getDeclarations()) {
                this.doSwitch(nD);
            }
            DVENameResolver.this.context.pop();
            for (Reference ref : DVENameResolver.this.unresolvedSet) {
                if (((Boolean)this.doSwitch(ref)).booleanValue()) continue;
                java.lang.System.err.println("Cannot resolve " + ref.getRefName());
                DVENameResolver.this.failed = true;
            }
            return true;
        }

        Process processContext() {
            if (DVENameResolver.this.context.size() < 1) {
                return null;
            }
            if (DVENameResolver.this.context.peek() instanceof Process) {
                return (Process)DVENameResolver.this.context.peek();
            }
            return null;
        }

        @Override
        public Boolean caseVariableDeclaration(VariableDeclaration object) {
            Process ctx = this.processContext();
            if (ctx == null) {
                DVENameResolver.this.globalNames.put(object.getName(), object);
                if (object.getInitial() != null) {
                    this.doSwitch(object.getInitial());
                }
                return true;
            }
            DVENameResolver.this.processNames.get(ctx).put(object.getName(), object);
            if (object.getInitial() != null) {
                this.doSwitch(object.getInitial());
            }
            return true;
        }

        @Override
        public Boolean caseConstantDeclaration(ConstantDeclaration object) {
            Process ctx = this.processContext();
            if (ctx == null) {
                DVENameResolver.this.globalNames.put(object.getName(), object);
                if (object.getInitial() != null) {
                    this.doSwitch(object.getInitial());
                }
                return true;
            }
            DVENameResolver.this.processNames.get(ctx).put(object.getName(), object);
            if (object.getInitial() != null) {
                this.doSwitch(object.getInitial());
            }
            return true;
        }

        @Override
        public Boolean caseChannelDeclaration(ChannelDeclaration object) {
            DVENameResolver.this.globalNames.put(object.getName(), object);
            return true;
        }

        @Override
        public Boolean caseProcess(Process object) {
            DVENameResolver.this.globalNames.put(object.getName(), object);
            DVENameResolver.this.processNames.put(object, new HashMap());
            DVENameResolver.this.context.push(object);
            for (State state : object.getStates()) {
                this.doSwitch(state);
            }
            for (NamedDeclaration nDecl : object.getDeclarations()) {
                this.doSwitch(nDecl);
            }
            if (object.getInitial() != null) {
                this.doSwitch(object.getInitial());
            } else {
                java.lang.System.err.println("Process " + object.getName() + " does not have an initial state\n");
            }
            for (StateReference sR : object.getCommited()) {
                this.doSwitch(sR);
            }
            for (StateReference sR : object.getAccepting()) {
                this.doSwitch(sR);
            }
            for (Transition t : object.getTransitions()) {
                this.doSwitch(t);
            }
            DVENameResolver.this.context.pop();
            return true;
        }

        @Override
        public Boolean caseTransition(Transition object) {
            if (object.getFrom() != null) {
                this.doSwitch(object.getFrom());
            }
            this.doSwitch(object.getTo());
            if (object.getGuard() != null) {
                this.doSwitch(object.getGuard());
            }
            if (object.getSync() != null) {
                this.doSwitch(object.getSync());
            }
            for (Assignment a : object.getEffect()) {
                this.doSwitch(a);
            }
            return true;
        }

        @Override
        public Boolean caseSynchronization(Synchronization object) {
            this.doSwitch(object.getChannel());
            return true;
        }

        @Override
        public Boolean caseInputSynchronization(InputSynchronization object) {
            this.doSwitch(object.getChannel());
            if (object.getValue() != null) {
                this.doSwitch(object.getValue());
            }
            return true;
        }

        @Override
        public Boolean caseOutputSynchronization(OutputSynchronization object) {
            this.doSwitch(object.getChannel());
            if (object.getValue() != null) {
                this.doSwitch(object.getValue());
            }
            return true;
        }

        @Override
        public Boolean caseAssignment(Assignment object) {
            this.doSwitch(object.getLhs());
            this.doSwitch(object.getRhs());
            return true;
        }

        @Override
        public Boolean caseArrayLiteral(ArrayLiteral object) {
            for (Expression exp : object.getValues()) {
                this.doSwitch(exp);
            }
            return true;
        }

        @Override
        public Boolean caseBinaryExpression(BinaryExpression object) {
            for (Expression exp : object.getOperands()) {
                this.doSwitch(exp);
            }
            return true;
        }

        @Override
        public Boolean caseUnaryExpression(UnaryExpression object) {
            this.doSwitch(object.getOperand());
            return true;
        }

        @Override
        public Boolean caseIndexedExpression(IndexedExpression object) {
            this.doSwitch(object.getBase());
            this.doSwitch(object.getIndex());
            return true;
        }

        @Override
        public Boolean caseSystemProperties(SystemProperties object) {
            this.doSwitch(object.getProperty());
            return true;
        }

        @Override
        public Boolean caseState(State object) {
            Process ctx = this.processContext();
            DVENameResolver.this.processNames.get(ctx).put(object.getName(), object);
            return true;
        }

        boolean checkIfError(Element obj, String name) {
            if (obj == null) {
                java.lang.System.err.println("undeclared identifier '" + name + "'");
                DVENameResolver.this.failed = true;
                return true;
            }
            return false;
        }

        @Override
        public Boolean caseStateReference(StateReference object) {
            Map<String, NamedDeclaration> env = DVENameResolver.this.processNames.get(this.processContext());
            State obj = (State)env.get(object.getRefName());
            if (this.checkIfError(obj, object.getRefName())) {
                return false;
            }
            object.setRef(obj);
            return true;
        }

        @Override
        public Boolean caseProcessReference(ProcessReference object) {
            Process p = (Process)DVENameResolver.this.globalNames.get(object.getRefName());
            if (this.checkIfError(p, object.getRefName())) {
                return false;
            }
            object.setRef(p);
            return true;
        }

        @Override
        public Boolean caseVariableReference(VariableReference object) {
            VariableDeclaration vDecl;
            Process ctx = this.processContext();
            if (ctx != null && (vDecl = (VariableDeclaration)DVENameResolver.this.processNames.get(ctx).get(object.getRefName())) != null) {
                object.setRef(vDecl);
                return true;
            }
            vDecl = (VariableDeclaration)DVENameResolver.this.globalNames.get(object.getRefName());
            if (this.checkIfError(vDecl, object.getRefName())) {
                return false;
            }
            object.setRef(vDecl);
            return true;
        }

        @Override
        public Boolean caseChannelReference(ChannelReference object) {
            ChannelDeclaration cD = (ChannelDeclaration)DVENameResolver.this.globalNames.get(object.getRefName());
            if (this.checkIfError(cD, object.getRefName())) {
                return false;
            }
            object.setRef(cD);
            return true;
        }

        @Override
        public Boolean caseProcessStateReference(ProcessStateReference object) {
            Process prefix = (Process)DVENameResolver.this.globalNames.get(object.getPrefix().getRefName());
            if (prefix == null) {
                DVENameResolver.this.unresolvedSet.add(object);
                return false;
            }
            object.getPrefix().setRef(prefix);
            State state = (State)DVENameResolver.this.processNames.get(prefix).get(object.getRefName());
            if (this.checkIfError(state, object.getRefName())) {
                return false;
            }
            object.setRef(state);
            return true;
        }

        @Override
        public Boolean caseProcessVariableReference(ProcessVariableReference object) {
            Process prefix = (Process)DVENameResolver.this.globalNames.get(object.getPrefix().getRefName());
            if (prefix == null) {
                DVENameResolver.this.unresolvedSet.add(object);
                return false;
            }
            object.getPrefix().setRef(prefix);
            VariableDeclaration var = (VariableDeclaration)DVENameResolver.this.processNames.get(prefix).get(object.getRefName());
            if (this.checkIfError(var, object.getRefName())) {
                return false;
            }
            object.setRef(var);
            return true;
        }
    };

    public void apply(System sys) throws Exception {
        this.modelSwitch.doSwitch(sys);
        if (this.failed) {
            throw new Exception();
        }
    }
}

