/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.utils;

import java.util.LinkedHashMap;
import java.util.function.Consumer;
import org.petitparser.context.Result;
import org.petitparser.parser.Parser;
import org.petitparser.utils.Mirror;

public class Profiler {
    public static Parser on(Parser source, Consumer<Profile> consumer) {
        LinkedHashMap builders = new LinkedHashMap();
        return Mirror.of(source).transform(parser -> {
            ProfileBuilder builder = new ProfileBuilder((Parser)parser);
            builders.put(parser, builder);
            return parser.callCC((continuation, context) -> {
                builder.start();
                Result result = (Result)continuation.apply(context);
                builder.stop();
                return result;
            });
        }).callCC((continuation, context) -> {
            builders.values().stream().forEach(rec$ -> ((ProfileBuilder)rec$).reset());
            Result result = (Result)continuation.apply(context);
            builders.values().stream().map(rec$ -> ((ProfileBuilder)rec$).build()).forEach(consumer);
            return result;
        });
    }

    private static class ProfileBuilder {
        private final Parser parser;
        private int activationCount;
        private int totalActivationCount;
        private long elapsedNanoseconds;
        private int nestingLevel;
        private long startTime;

        private ProfileBuilder(Parser parser) {
            this.parser = parser;
        }

        private void reset() {
            this.activationCount = 0;
            this.totalActivationCount = 0;
            this.elapsedNanoseconds = 0L;
            this.nestingLevel = 0;
            this.startTime = 0L;
        }

        private void start() {
            ++this.nestingLevel;
            ++this.totalActivationCount;
            if (this.nestingLevel == 1) {
                ++this.activationCount;
                this.startTime = System.nanoTime();
            }
        }

        private void stop() {
            if (this.nestingLevel == 1) {
                this.elapsedNanoseconds += System.nanoTime() - this.startTime;
            }
            --this.nestingLevel;
        }

        private Profile build() {
            return new Profile(this.parser, this.activationCount, this.totalActivationCount, this.elapsedNanoseconds);
        }
    }

    public static class Profile {
        public final Parser parser;
        public final int activationCount;
        public final int totalActivationCount;
        public final long elapsedNanoseconds;

        private Profile(Parser parser, int activationCount, int totalActivationCount, long elapsedNanoseconds) {
            this.parser = parser;
            this.activationCount = activationCount;
            this.totalActivationCount = totalActivationCount;
            this.elapsedNanoseconds = elapsedNanoseconds;
        }

        public String toString() {
            return this.activationCount + "\t" + this.elapsedNanoseconds + "\t" + this.parser;
        }
    }
}

