/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.checker;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import obp.fiacre.checker.ProgramAnalyzer;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Transition;
import obp.fiacre.util.BranchExtractor;
import obp.fiacre.util.TransitionBranch;

public class TransitionAnalyzer {
    private final ProgramAnalyzer caller;
    private final Map<ProcessDecl, Map<Transition, Collection<TransitionBranch>>> branchMap = new LinkedHashMap<ProcessDecl, Map<Transition, Collection<TransitionBranch>>>();
    private boolean valid = true;

    public TransitionAnalyzer(ProgramAnalyzer caller) {
        this.caller = caller;
    }

    public boolean analyze() {
        for (Declaration declaration : this.caller.getProgram().getDeclarationList()) {
            if (!(declaration instanceof ProcessDecl)) continue;
            this.checkProcess((ProcessDecl)declaration);
        }
        return this.valid;
    }

    private void checkProcess(ProcessDecl processDecl) {
        LinkedHashMap<Transition, Collection<TransitionBranch>> processBranchMap = new LinkedHashMap<Transition, Collection<TransitionBranch>>();
        this.branchMap.put(processDecl, processBranchMap);
        for (Transition transition : processDecl.getTransitionList()) {
            String source = transition.getFrom().getName();
            Collection<TransitionBranch> branches = BranchExtractor.extractForCompiler(source, transition);
            processBranchMap.put(transition, branches);
        }
    }

    public Map<Transition, Collection<TransitionBranch>> getBranchList(ProcessDecl processDecl) {
        return this.branchMap.get(processDecl);
    }
}

