/*
 * Decompiled with CFR 0.152.
 */
package spinja;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import spinja.Version;
import spinja.options.BooleanOption;
import spinja.options.MultiStringOption;
import spinja.options.OptionParser;
import spinja.options.StringOption;
import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.Specification;
import spinja.promela.compiler.optimizer.GraphOptimizer;
import spinja.promela.compiler.optimizer.RemoveUselessActions;
import spinja.promela.compiler.optimizer.RemoveUselessGotos;
import spinja.promela.compiler.optimizer.RenumberAll;
import spinja.promela.compiler.optimizer.StateMerging;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Promela;

public class Compile {
    private static Specification compile(File file, String string, boolean bl, boolean bl2) {
        try {
            if (bl2) {
                System.out.print("Start parsing " + file.getName() + "...");
            }
            Promela promela = new Promela(new FileInputStream(file));
            Specification specification = promela.spec(string);
            if (bl2) {
                System.out.println("done");
            }
            if (bl2) {
                System.out.println("Optimizing graphs...");
            }
            GraphOptimizer[] graphOptimizerArray = new GraphOptimizer[]{bl ? new StateMerging() : null, new RemoveUselessActions(), new RemoveUselessGotos(), new RenumberAll()};
            for (GraphOptimizer[] graphOptimizerArray2 : specification) {
                if (bl2) {
                    System.out.println("Initial graph for process " + graphOptimizerArray2 + ":");
                    System.out.println(graphOptimizerArray2.getAutomaton());
                }
                GraphOptimizer[] graphOptimizerArray3 = graphOptimizerArray;
                int n = graphOptimizerArray3.length;
                for (int i = 0; i < n; ++i) {
                    GraphOptimizer graphOptimizer = graphOptimizerArray3[i];
                    if (graphOptimizer == null) continue;
                    graphOptimizer.optimize(graphOptimizerArray2.getAutomaton());
                    if (!bl2) continue;
                    System.out.println("After " + graphOptimizer.getClass().getSimpleName() + ":");
                    System.out.println(graphOptimizerArray2.getAutomaton());
                }
                if (!bl2) continue;
                System.out.println(graphOptimizerArray2.getAutomaton());
            }
            Proctype proctype = specification.getNever();
            if (proctype != null) {
                if (bl2) {
                    System.out.println("Initial graph for never claim:");
                    System.out.println(proctype.getAutomaton());
                }
                for (GraphOptimizer graphOptimizer : graphOptimizerArray) {
                    if (graphOptimizer != null) {
                        graphOptimizer.optimize(proctype.getAutomaton());
                    }
                    if (!bl2) continue;
                    System.out.println("After " + graphOptimizer.getClass().getSimpleName() + ":");
                    System.out.println(proctype.getAutomaton());
                }
                if (bl2) {
                    System.out.println(proctype.getAutomaton());
                }
            }
            if (bl2) {
                System.out.println("Optimization done");
            }
            return specification;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Promela file " + file.getName() + " could not be found.");
        }
        catch (ParseException parseException) {
            System.out.println("Parse exception in file " + file.getName() + ": " + parseException.getMessage());
        }
        return null;
    }

    public static void main(String[] stringArray) {
        File file;
        String string = "SpinJa Promela Compiler - version " + Version.VERSION + " (" + Version.DATE + ")\n" + "(C) University of Twente, Formal Methods and Tools group";
        OptionParser optionParser = new OptionParser("java spinja.Compiler", string, "SpinJa Promela Compiler: this compiler converts a Promela source file\nto a Java model that can be checked by the SpinJa Model Checker.", true);
        StringOption stringOption = new StringOption('n', "sets the name of the model \n(default: Pan)");
        optionParser.addOption(stringOption);
        StringOption stringOption2 = new StringOption('s', "sets the output directory for the sourcecode \n(default: spinja)");
        optionParser.addOption(stringOption2);
        MultiStringOption multiStringOption = new MultiStringOption('o', "disables one or more optimalisations", new String[]{"3"}, new String[]{"disables statement merging"});
        optionParser.addOption(multiStringOption);
        BooleanOption booleanOption = new BooleanOption('v', "verbose: show diagnostic information on the \ncompilation process.");
        optionParser.addOption(booleanOption);
        optionParser.parse(stringArray);
        List<String> list = optionParser.getFiles();
        if (list.size() != 1) {
            System.out.println("Please specify one file that is to be compiled!");
            optionParser.printUsage();
        }
        if (!(file = new File(list.get(0))).exists() || !file.isFile()) {
            System.out.println("File " + file.getName() + " does not exist or is not a valid file!");
            optionParser.printUsage();
        }
        String string2 = null;
        string2 = stringOption.isSet() ? stringOption.getValue() : "Pan";
        Specification specification = Compile.compile(file, string2, !multiStringOption.isSet("3"), booleanOption.isSet());
        if (specification == null) {
            System.exit(-4);
        }
        File file2 = new File(System.getProperty("user.dir"));
        File file3 = null;
        file3 = stringOption2.isSet() ? new File(file2, stringOption2.getValue()) : new File(file2, "spinja");
        if (!file3.exists() && !file3.mkdirs()) {
            System.out.println("Error: could not generate directory " + file3.getName());
            System.exit(-3);
        }
        Compile.writeFiles(specification, string2, file3);
        System.out.println("Written Java files for '" + file + "' to\n" + file3);
    }

    private static void writeFiles(Specification specification, String string, File file) {
        File file2 = new File(file, string + "Model.java");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(specification.generateModel().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException while writing java files: " + iOException.getMessage());
            System.exit(-5);
        }
        catch (ParseException parseException) {
            System.out.println("Parse exception: " + parseException.getMessage());
            System.exit(-6);
        }
    }
}

