/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.pattern;

import obp.cdl.CDLUnit;
import obp.util.CDLUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.xid.basics.error.Diagnostic;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.ui.field.AbstractField;

public class CdlTextField
extends AbstractField {
    private StyledText textWidget;
    private String value;
    private boolean validated = false;
    private Diagnostic diagnostic = null;
    private CDLUnit unit = null;

    public CdlTextField() {
        super(null, 2);
    }

    public void createWidget(Composite parent) {
        super.createWidget(parent);
        this.createLabel(parent);
        this.createInfo(parent);
        this.createText(parent);
        this.createButtonBar(parent);
    }

    protected void createText(Composite parent) {
        this.textWidget = new StyledText(parent, this.textStyle());
        this.attachFieldToWidget((Widget)this.textWidget);
        this.textWidget.setEnabled(this.isEnable());
        this.createMenu((Control)this.textWidget);
        if (this.value != null) {
            this.textWidget.setText(this.value);
        }
        this.textWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newText = CdlTextField.this.textWidget.getText();
                String string = newText = newText.length() > 0 ? newText : null;
                if (CdlTextField.this.getValue() == null ? newText != null : !CdlTextField.this.getValue().equals(newText)) {
                    CdlTextField.this.setValue(newText, 1);
                }
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 200;
        data.minimumHeight = 80;
        data.horizontalSpan = this.fieldHorizontalSpan();
        data.verticalSpan = 1;
        this.textWidget.setLayoutData((Object)data);
        this.fireWidgetCreation((Widget)this.textWidget);
    }

    protected int textStyle() {
        int style = 19200;
        return style;
    }

    public boolean activate() {
        if (this.textWidget != null) {
            return this.textWidget.setFocus();
        }
        return false;
    }

    public boolean grabExcessVerticalSpace() {
        return true;
    }

    public String getValue() {
        return this.value;
    }

    protected void setValue(String value, int type) {
        String oldValue = this.value;
        this.value = value;
        this.validated = false;
        this.unit = null;
        if (this.textWidget != null && type != 1 && !this.textWidget.getText().equals(value == null ? "" : value)) {
            this.textWidget.setText(value == null ? "" : value);
        }
        this.notificationSupport.fireValueNotification(type, "value", (Object)value, (Object)oldValue);
    }

    public void setValue(String value) {
        this.setValue(value, 2);
    }

    public Diagnostic getDiagnostic() {
        if (this.validated) {
            return this.diagnostic;
        }
        this.diagnostic = null;
        this.unit = null;
        if (this.value != null && this.value.trim().length() > 0) {
            try {
                this.unit = CDLUtil.readCDLAndResolveReferences(this.value);
            }
            catch (Throwable e) {
                this.diagnostic = new Diagnostic.Stub(2, DiagnosticUtil.createMessage((Throwable)e));
            }
        }
        this.validated = true;
        return this.diagnostic;
    }

    public CDLUnit getUnit() {
        this.getDiagnostic();
        return this.unit;
    }
}

