/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.cdl;

import java.io.File;
import obp.cdl.CDLDeclaration;
import obp.cdl.PropertyDeclaration;
import obp.ui.cdl.CDLViewer;
import obp.ui.cdl.Configuration;
import obp.ui.cdl.ExportAction;
import obp.ui.cdl.OpenedUnit;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.xid.basics.Basics;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.Validator;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.PlatformUtil;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.dialog.FieldDialog;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.TextField;

public class Actions {
    private final CDLViewer ui;

    public Actions(CDLViewer ui) {
        this.ui = ui;
    }

    private Image getImage(String filename) {
        return this.ui.getResources().getImage(filename);
    }

    public Action.Container createFileAction() {
        if (Basics.isMac()) {
            PlatformUtil.registerCocoaNameAboutAndPreference((String)"CDLViewer", (Action)this.createAboutAction(), (Action)this.createPreferencesAction());
            return new Action.Container("File", new Action[]{this.createOpenCdlAction(), this.createCloseUnitAction(), new Action.Stub(11), this.createExportPngAction(), this.createExportAction()});
        }
        return new Action.Container("File", new Action[]{this.createOpenCdlAction(), this.createCloseUnitAction(), new Action.Stub(11), this.createExportPngAction(), this.createExportAction(), new Action.Stub(11), this.createPreferencesAction(), new Action.Stub(11), this.createQuitAction()});
    }

    private Action createAboutAction() {
        return new Action.Stub("About CDLViewer\u2026"){

            public int run(ActionMonitor monitor) {
                return 1;
            }
        };
    }

    private Action createPreferencesAction() {
        return new Action.Stub("Preferences\u2026"){

            public int getVisibility() {
                return 1;
            }

            public int run(ActionMonitor monitor) {
                Configuration configuration = Actions.this.ui.getConfiguration();
                final TextField dotField = new TextField("Dot Executable");
                dotField.addAction((Action)new Action.Stub("\u2026"){

                    public int run(ActionMonitor monitor) {
                        String newDot;
                        FileDialog dialog = new FileDialog(Actions.this.ui.getShell());
                        if (dotField.getValue() != null) {
                            File dotFile = new File(dotField.getValue());
                            dialog.setFilterPath(dotFile.getParent());
                            dialog.setFileName(dotFile.getName());
                        }
                        if ((newDot = dialog.open()) == null) {
                            return 2;
                        }
                        dotField.setValue(newDot);
                        return 1;
                    }
                });
                dotField.setValidator((Validator)new Validator.Stub<String>(1, "Invalid Dot file."){

                    public boolean isValid(String value) {
                        if (value == null) {
                            return false;
                        }
                        File file = new File(value);
                        return file.exists() && file.isFile() && file.canExecute();
                    }
                });
                dotField.setValue(configuration.getDotExecutable());
                FieldDialog dialog = new FieldDialog(Actions.this.ui.getShell(), "CDLViewer", "Configuration", 4, (Field)dotField);
                dialog.setButtonLabel(new String[]{"Ok"});
                dialog.open();
                configuration.setDotExecutable(dotField.getValue());
                return 1;
            }
        };
    }

    private Action createOpenCdlAction() {
        return new Action.Stub("Open CDL\u2026", this.getImage("eclipse/open_edit.gif")){

            public int run(ActionMonitor monitor) {
                FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.cdl", "*"});
                String file = dialog.open();
                if (file == null) {
                    return 2;
                }
                try {
                    Actions.this.ui.loadUnit(new File(file));
                }
                catch (Exception e) {
                    Actions.this.ui.handleError(2, "Can't load file '" + file + "': " + DiagnosticUtil.createMessage((Throwable)e) + ".");
                    return 3;
                }
                return 1;
            }
        };
    }

    private Action createCloseUnitAction() {
        return new Action.Stub("Close", this.getImage("eclipse/delete_edit.gif")){

            public int getVisibility() {
                return Actions.this.ui.getSelection() instanceof OpenedUnit ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                Actions.this.ui.closeUnit((OpenedUnit)Actions.this.ui.getSelection());
                return 1;
            }
        };
    }

    private Action createExportPngAction() {
        return new Action.Stub("Export to PNG\u2026", this.getImage("eclipse/export_wiz.gif")){

            public int getVisibility() {
                Object selection = Actions.this.ui.getSelection();
                if (selection instanceof CDLDeclaration) {
                    return 1;
                }
                if (selection instanceof PropertyDeclaration) {
                    return 1;
                }
                return 2;
            }

            public int run(ActionMonitor monitor) {
                FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.png", "*"});
                String file = dialog.open();
                if (file == null) {
                    return 2;
                }
                try {
                    Actions.this.ui.writeSelectedDiagramToPng(file);
                }
                catch (Exception e) {
                    return 3;
                }
                return 1;
            }
        };
    }

    private Action createExportAction() {
        return new ExportAction(this.ui);
    }

    private Action createQuitAction() {
        return new Action.Stub("Quit"){

            public int run(ActionMonitor monitor) {
                Actions.this.ui.getShell().dispose();
                return 1;
            }
        };
    }

    public Action.Container createWindowAction() {
        return new Action.Container("Window", new Action[]{this.createShowErrorsAction()});
    }

    private Action createShowErrorsAction() {
        return new Action.Stub("Show Errors", this.getImage("error_tsk.gif"), 266){

            public boolean getState() {
                return Actions.this.ui.isShowErrors();
            }

            public int run(ActionMonitor monitor) {
                Actions.this.ui.setShowErrors(!Actions.this.ui.isShowErrors());
                return 1;
            }
        };
    }
}

