/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.data.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.NamedElement;
import obp.if2.data.Constant;
import obp.if2.data.constants.ConstantLiteral;
import obp.if2.data.constants.literal.IdentifiedConstant;
import obp.if2.structure.Entity;

public class NamedConstant
implements NamedElement,
Constant {
    private ConstantLiteral value;
    private final List<IdentifiedConstant> referenceDeclarationList = new ArrayList<IdentifiedConstant>();
    private Entity entity;
    private String name;

    public ConstantLiteral getValue() {
        return this.value;
    }

    public void setValue(ConstantLiteral newValue) {
        if (this.value == null ? newValue != null : !this.value.equals(newValue)) {
            this.value = newValue;
        }
    }

    public List<IdentifiedConstant> getReferenceDeclarationList() {
        return Collections.unmodifiableList(this.referenceDeclarationList);
    }

    public int getReferenceDeclarationCount() {
        return this.referenceDeclarationList.size();
    }

    public IdentifiedConstant getReferenceDeclaration(int index) {
        if (index < 0 || index >= this.getReferenceDeclarationCount()) {
            return null;
        }
        return this.referenceDeclarationList.get(index);
    }

    public void addReferenceDeclaration(IdentifiedConstant newValue) {
        this.addReferenceDeclaration(this.getReferenceDeclarationCount(), newValue);
    }

    public void addReferenceDeclaration(int index, IdentifiedConstant newValue) {
        this.referenceDeclarationList.add(index, newValue);
    }

    public IdentifiedConstant setReferenceDeclaration(int index, IdentifiedConstant newValue) {
        return this.referenceDeclarationList.set(index, newValue);
    }

    public void addAllReferenceDeclaration(Collection<IdentifiedConstant> toAddList) {
        for (IdentifiedConstant newValue : toAddList) {
            this.addReferenceDeclaration(this.getReferenceDeclarationCount(), newValue);
        }
    }

    public void removeReferenceDeclaration(IdentifiedConstant value) {
        int index = this.referenceDeclarationList.indexOf(value);
        if (index >= 0) {
            this.removeReferenceDeclaration(index);
        }
    }

    public void removeReferenceDeclaration(int index) {
        this.referenceDeclarationList.remove(index);
    }

    public void addReferenceDeclarationAndOpposite(IdentifiedConstant newValue) {
        this.addReferenceDeclaration(newValue);
        if (newValue != null) {
            newValue.setConstant(this);
        }
    }

    public void addAllReferenceDeclarationAndOpposite(Collection<IdentifiedConstant> toAddList) {
        for (IdentifiedConstant newValue : toAddList) {
            this.addReferenceDeclarationAndOpposite(this.getReferenceDeclarationCount(), newValue);
        }
    }

    public void addReferenceDeclarationAndOpposite(int index, IdentifiedConstant newValue) {
        this.addReferenceDeclaration(index, newValue);
        if (newValue != null) {
            newValue.setConstant(this);
        }
    }

    public IdentifiedConstant setReferenceDeclarationAndOpposite(int index, IdentifiedConstant newValue) {
        IdentifiedConstant oldValue = this.referenceDeclarationList.set(index, newValue);
        if (newValue != null) {
            newValue.setConstant(this);
        }
        return oldValue;
    }

    public void removeReferenceDeclarationAndOpposite(IdentifiedConstant removed) {
        this.removeReferenceDeclaration(removed);
        if (removed != null) {
            removed.setConstant(null);
        }
    }

    public void removeReferenceDeclarationAndOpposite(int index) {
        IdentifiedConstant removed = this.referenceDeclarationList.get(index);
        this.removeReferenceDeclaration(index);
        if (removed != null) {
            removed.setConstant(null);
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity newValue) {
        if (this.entity == null ? newValue != null : !this.entity.equals(newValue)) {
            this.entity = newValue;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    @Override
    public void accept(If2Visitor visitor) {
        visitor.visitNamedConstant(this);
    }
}

