/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.core.AbstractExplorer;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.core.ITransitionExecutor;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.obs.AtomicAction;

public class FixedOrderTransitionExecutor
implements ITransitionExecutor {
    AbstractExplorer explorer;
    protected boolean[] modifiedBehaviors;
    protected Transition[] transitionArray;
    protected int transitionCount;

    @Override
    public void setExplorer(AbstractExplorer explorer) {
        this.explorer = explorer;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FixedOrderTransitionExecutor theClone = (FixedOrderTransitionExecutor)super.clone();
        theClone.setExplorer(null);
        return theClone;
    }

    @Override
    public void init() {
        this.modifiedBehaviors = new boolean[this.explorer.getBehaviorCount()];
        this.transitionCount = 0;
        this.transitionArray = new Transition[2];
    }

    @Override
    public void addInput(Transition transition) {
        this.addTransition(transition);
    }

    @Override
    public void addOutput(Transition transition) {
        this.addTransition(transition);
    }

    private void addTransition(Transition transition) {
        if (this.transitionCount >= this.transitionArray.length) {
            this.transitionArray = Arrays.copyOf(this.transitionArray, this.transitionArray.length * 2);
        }
        this.transitionArray[this.transitionCount] = transition;
        ++this.transitionCount;
    }

    @Override
    public boolean execute(Configuration configuration, Channel channel) {
        int i;
        Configuration newConfiguration = new Configuration(configuration);
        short[] newDbm = newConfiguration.dbm;
        if (newDbm != null) {
            if (channel != null && channel.clockId != -1) {
                DBM.andGuard(newDbm, 0, channel.clockId, channel.minBoundInternal);
            }
            for (i = 0; i < this.transitionCount; ++i) {
                this.transitionArray[i].when(newConfiguration, this.explorer);
            }
        }
        if (newDbm == null || !DBM.isEmpty(newDbm)) {
            boolean stop;
            Arrays.fill(this.modifiedBehaviors, false);
            for (i = 0; i < this.transitionCount; ++i) {
                Transition transition = this.transitionArray[i];
                this.modifiedBehaviors[transition.behaviorId] = true;
                transition.updateModifiedBehaviors(newConfiguration, this.explorer, this.modifiedBehaviors);
            }
            for (i = 0; i < this.modifiedBehaviors.length; i = (short)(i + 1)) {
                if (!this.modifiedBehaviors[i]) continue;
                newConfiguration.replaceBehaviorConfigurationByCopy((short)i);
            }
            boolean isBlocked = false;
            ArrayList<AtomicAction> atomicActionList = new ArrayList<AtomicAction>(5);
            for (int i2 = 0; i2 < this.transitionCount; ++i2) {
                if (this.transitionArray[i2].action(this.explorer, atomicActionList, newConfiguration)) continue;
                isBlocked = true;
                break;
            }
            if (!isBlocked && !(stop = this.explorer.observe(configuration, atomicActionList, newConfiguration))) {
                if (newDbm != null) {
                    this.explorer.applyDelayAndInvariant(configuration, newConfiguration);
                }
                this.explorer.registerActionAndTarget(configuration, atomicActionList, newConfiguration);
                this.reset();
                return true;
            }
        }
        this.reset();
        return false;
    }

    public Configuration fireOneTransition(Configuration configuration, Transition transition, List<AtomicAction> atomicActionList) {
        Configuration newConfiguration = new Configuration(configuration);
        short[] newDbm = newConfiguration.dbm;
        if (newDbm != null) {
            transition.when(newConfiguration, this.explorer);
        }
        if (newDbm == null || !DBM.isEmpty(newDbm)) {
            boolean stop;
            boolean isBlocked;
            Arrays.fill(this.modifiedBehaviors, false);
            this.modifiedBehaviors[transition.behaviorId] = true;
            transition.updateModifiedBehaviors(newConfiguration, this.explorer, this.modifiedBehaviors);
            for (short i = 0; i < this.modifiedBehaviors.length; i = (short)(i + 1)) {
                if (!this.modifiedBehaviors[i]) continue;
                newConfiguration.replaceBehaviorConfigurationByCopy(i);
            }
            boolean bl = isBlocked = !transition.action(this.explorer, atomicActionList, newConfiguration);
            if (!isBlocked && !(stop = this.explorer.observe(configuration, atomicActionList, newConfiguration))) {
                if (newDbm != null) {
                    this.explorer.applyDelayAndInvariant(configuration, newConfiguration);
                }
                return newConfiguration;
            }
        }
        return null;
    }

    @Override
    public boolean executeAlone(Configuration configuration, Transition transition) {
        ArrayList<AtomicAction> atomicActionList = new ArrayList<AtomicAction>(5);
        Configuration newConfiguration = this.fireOneTransition(configuration, transition, atomicActionList);
        if (newConfiguration != null) {
            this.explorer.registerActionAndTarget(configuration, atomicActionList, newConfiguration);
            return true;
        }
        return false;
    }

    public void reset() {
        this.transitionCount = 0;
    }
}

