/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import obp.cc.ConcreteContext;
import obp.explorer.ExplorerConfiguration;
import obp.explorer.ExplorerResult;
import obp.explorer.ExplorerResultAnalyzer;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.core.AbstractExplorer;
import obp.partition.AutoSplitPartitioner;
import obp.result.ExplorationResultInfo;
import obp.tool.ToolController;
import obp.transfo.cc.ConcreteContextTopological;
import obp.util.ConcreteContextUtil;
import org.xid.basics.Basics;
import org.xid.basics.progress.ActionMonitor;

public class ExplorerController
extends ToolController {
    private final String fileSeparator = System.getProperty("file.separator");
    private final String explorerMainClassQualifiedName = "obp.explorer.Explorer";
    private final ExplorerConfiguration configuration;

    public ExplorerController(ExplorerConfiguration configuration, PrintWriter out, PrintWriter err) {
        super(out, err);
        this.configuration = configuration;
    }

    private String javaExecutable() {
        StringBuilder executable = new StringBuilder();
        executable.append(System.getProperty("java.home"));
        executable.append(this.fileSeparator);
        executable.append("bin");
        executable.append(this.fileSeparator);
        executable.append("java");
        if (Basics.isWindows()) {
            executable.append(".exe");
        }
        return executable.toString();
    }

    private String[] vmArgs() {
        String heapSize = this.configuration.getVMHeapOption();
        return new String[]{"-Xms" + heapSize, "-Xmx" + heapSize, "-XX:+UseParallelGC", "-XX:NewRatio=20", "-classpath", this.classPath()};
    }

    private String classPath() {
        return System.getProperty("java.class.path");
    }

    public void explore(File programClassPathFile, String programQualifiedName, ConcreteContext cc, File ccsl, File configurationsFile, ActionMonitor monitor) {
        this.scheduleClearResult();
        this.exploreWithContext(programClassPathFile, programQualifiedName, cc, ccsl, configurationsFile, monitor);
    }

    private void exploreWithContext(File programClassPathFile, String programQualifiedName, ConcreteContext cc, File ccslFile, File configurationsDirectory, ActionMonitor monitor) {
        byte[] ccBuffer;
        String confsFileName = (cc != null ? cc.getName() : "no_context") + ".confs";
        File configurationsFile = configurationsDirectory != null ? new File(configurationsDirectory, confsFileName) : null;
        ProgramLoader.FromClass loader = new ProgramLoader.FromClass(programQualifiedName, programClassPathFile);
        ExplorerResult resultInfo = new ExplorerResult(loader, cc, ccslFile, configurationsFile);
        final ExplorerResultAnalyzer analyzer = new ExplorerResultAnalyzer(resultInfo);
        this.schedule(analyzer);
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.javaExecutable());
        for (String arg : this.vmArgs()) {
            command.add(arg);
        }
        command.add("-Djava.library.path=" + programClassPathFile);
        command.add("obp.explorer.Explorer");
        command.add("--boost");
        Integer explorerID = 0;
        try {
            Class<? extends AbstractExplorer> c = this.configuration.getExplorerClass();
            Method m = c.getDeclaredMethod("getExplorerID", new Class[0]);
            explorerID = (Integer)m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] byArray = ccBuffer = cc == null ? null : ConcreteContextUtil.writeCC(cc);
        if (ccBuffer == null && (explorerID == 1 || explorerID == 2)) {
            command.add("--context-driven");
            command.add("0");
        } else {
            command.add("--context-driven");
            command.add(explorerID.toString());
        }
        if (this.configuration.checkDBMInclusion) {
            command.add("--dbm-inclusion");
        }
        if (ccBuffer != null) {
            this.schedule(new ByteArrayInputStream(ccBuffer));
            command.add("--cc");
            command.add("-");
        }
        if (ccslFile != null) {
            command.add("--ccsl");
            command.add(ccslFile.getAbsolutePath());
        }
        command.add("--program-path");
        command.add(programClassPathFile.getAbsolutePath());
        if (configurationsFile != null) {
            command.add("--out");
            command.add(configurationsFile.getAbsolutePath());
        }
        command.add(programQualifiedName);
        this.schedule(command.toArray(new String[command.size()]));
        this.schedule(new Runnable(){

            @Override
            public void run() {
                ExplorerController.this.getErrorHandler().handleError(0, analyzer.getResult().toShortString());
            }
        });
        this.globalMonitor(monitor);
    }

    public void exploreAutoSplit(File programClassPathFile, String programQualifiedName, ConcreteContext cc, int initialStep, int splitStep, File ccslFile, File configurationsDirectory, ActionMonitor monitor) {
        this.scheduleClearResult();
        AutoSplitPartitioner partitioner = new AutoSplitPartitioner(cc, initialStep, splitStep);
        this.exploreAutoSplit(programClassPathFile, programQualifiedName, partitioner, ccslFile, configurationsDirectory, monitor);
    }

    private void exploreAutoSplit(final File programClassPathFile, final String programQualifiedName, final AutoSplitPartitioner partitioner, final File ccslFile, final File configurationsDirectory, final ActionMonitor monitor) {
        if (partitioner.hasNext()) {
            final ConcreteContext context = ConcreteContextTopological.orderCC(partitioner.next());
            this.schedule(new Runnable(){

                @Override
                public void run() {
                    ExplorerController.this.println("---------------------------------------------------");
                    ExplorerController.this.println("---> Exploring for context '" + context.getName() + "' (" + context.getStateCount() + " states and " + context.getTransitionCount() + " transitions).");
                }
            });
            this.exploreWithContext(programClassPathFile, programQualifiedName, context, ccslFile, configurationsDirectory, monitor);
            this.schedule(new Runnable(){

                @Override
                public void run() {
                    ExplorationResultInfo result = (ExplorationResultInfo)ExplorerController.this.peekResult(ExplorationResultInfo.class);
                    if (result.isComplete()) {
                        ExplorerController.this.println("---> Exploration of context '" + context.getName() + "' succeeded.");
                    } else if (ConcreteContextUtil.hasOnePath(context)) {
                        ExplorerController.this.println("---> Exploration of context '" + context.getName() + "' failed!\t\t***CANNOT SPLIT CONTEXT*** because the context has only one path.");
                    } else {
                        ExplorerController.this.println("---> Exploration of context '" + context.getName() + "' failed, split it.");
                        partitioner.explorationFailed();
                    }
                    ExplorerController.this.exploreAutoSplit(programClassPathFile, programQualifiedName, partitioner, ccslFile, configurationsDirectory, monitor);
                }
            });
        }
    }

    public void exploreMoCCML(File mocfile, String programClassPathFile, File configurationsDirectory, ActionMonitor monitor) {
        this.scheduleClearResult();
        String confsFileName = "no_context.confs";
        if (!configurationsDirectory.exists()) {
            configurationsDirectory.mkdirs();
        }
        File configurationsFile = configurationsDirectory != null ? new File(configurationsDirectory, confsFileName) : null;
        ProgramLoader.FromMoCCML loader = new ProgramLoader.FromMoCCML(mocfile);
        ExplorerResult resultInfo = new ExplorerResult(loader, null, null, configurationsFile);
        final ExplorerResultAnalyzer analyzer = new ExplorerResultAnalyzer(resultInfo);
        this.schedule(analyzer);
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.javaExecutable());
        for (String arg : this.vmArgs()) {
            command.add(arg);
        }
        command.add("-Djava.library.path=/Users/ciprian/Playfield/DEPARTS/idm_obp3/Sources/MoCCML2JoMC/build/classes");
        command.add("obp.explorer.Explorer");
        command.add("--boost");
        Integer explorerID = 0;
        try {
            Class<? extends AbstractExplorer> c = this.configuration.getExplorerClass();
            Method m = c.getDeclaredMethod("getExplorerID", new Class[0]);
            explorerID = (Integer)m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (explorerID == 1 || explorerID == 2) {
            command.add("--context-driven");
            command.add("0");
        } else {
            command.add("--context-driven");
            command.add(explorerID.toString());
        }
        command.add("--program-path");
        command.add(new File(".").getAbsolutePath());
        if (configurationsFile != null) {
            command.add("--out");
            command.add(configurationsFile.getAbsolutePath());
        }
        command.add("--moccml");
        command.add(mocfile.getAbsolutePath());
        command.add("obp.languages.MoCCML.runtime.MoCCMLRoot");
        this.schedule(command.toArray(new String[command.size()]));
        this.schedule(new Runnable(){

            @Override
            public void run() {
                ExplorerController.this.getErrorHandler().handleError(0, analyzer.getResult().toShortString());
            }
        });
        this.globalMonitor(monitor);
    }
}

