/*
 * Decompiled with CFR 0.152.
 */
package obp.cdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.cdl.CdlVisitor;
import obp.cdl.Element;
import obp.cdl.Option;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public abstract class Activity
implements BoostObject,
Element {
    private boolean atomic = false;
    private int loop;
    private final List<Option> optionList = new ArrayList<Option>();

    public Activity() {
    }

    protected Activity(Boost boost) {
        boost.register((BoostObject)this);
        this.atomic = boost.readBoolean();
        this.loop = boost.readInt();
        for (Option oneChild : BoostUtil.readObjectList((Boost)boost, Option.class)) {
            this.optionList.add(oneChild);
        }
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public void setAtomic(boolean newValue) {
        if (this.atomic != newValue) {
            this.atomic = newValue;
        }
    }

    public int getLoop() {
        return this.loop;
    }

    public void setLoop(int newValue) {
        if (this.loop != newValue) {
            this.loop = newValue;
        }
    }

    public List<Option> getOptionList() {
        return Collections.unmodifiableList(this.optionList);
    }

    public int getOptionCount() {
        return this.optionList.size();
    }

    public Option getOption(int index) {
        if (index < 0 || index >= this.getOptionCount()) {
            return null;
        }
        return this.optionList.get(index);
    }

    public void addOption(Option newValue) {
        this.addOption(this.getOptionCount(), newValue);
    }

    public void addOption(int index, Option newValue) {
        this.optionList.add(index, newValue);
    }

    public Option setOption(int index, Option newValue) {
        return this.optionList.set(index, newValue);
    }

    public void addAllOption(Collection<Option> toAddList) {
        for (Option newValue : toAddList) {
            this.addOption(this.getOptionCount(), newValue);
        }
    }

    public void removeOption(Option value) {
        int index = this.optionList.indexOf(value);
        if (index >= 0) {
            this.removeOption(index);
        }
    }

    public void removeOption(int index) {
        this.optionList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        boost.writeBoolean(this.atomic);
        boost.writeInt(this.loop);
        BoostUtil.writeObjectCollection((Boost)boost, this.optionList);
    }

    @Override
    public abstract void accept(CdlVisitor var1);
}

