/*
 * Decompiled with CFR 0.152.
 */
package plug.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import plug.composite.CompositeAction;
import plug.composite.CompositeConfiguration;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.ILanguagePlugin;
import plug.core.ITransitionRelation;
import plug.statespace.transitions.FiredTransition;
import plug.utils.CartesianProduct;

public class CompositeRuntime
implements ITransitionRelation<CompositeConfiguration, CompositeFireableTransition> {
    public final Map<ITransitionRelation, ILanguagePlugin> runtimeToModule = new IdentityHashMap<ITransitionRelation, ILanguagePlugin>();
    protected final List<ITransitionRelation<IConfiguration, Object>> runtimes = new ArrayList<ITransitionRelation<IConfiguration, Object>>();
    protected final List<String> runtimeNames = new ArrayList<String>();

    public String getRuntimeName(int index) {
        return this.runtimeNames.get(index);
    }

    public ITransitionRelation getRuntime(int index) {
        return this.runtimes.get(index);
    }

    public int getRuntimeCount() {
        return this.runtimes.size();
    }

    public int addRuntime(String name, ITransitionRelation<?, ?> runtime) {
        int key = this.runtimes.size();
        this.runtimes.add(runtime);
        this.runtimeNames.add(name);
        return key;
    }

    @Override
    public Set<CompositeConfiguration> initialConfigurations() {
        ArrayList initials = new ArrayList(this.runtimes.size());
        for (int i = 0; i < this.runtimes.size(); ++i) {
            List iRuntimeInitials = this.runtimes.get(i).initialConfigurations().stream().collect(Collectors.toList());
            initials.add(i, iRuntimeInitials);
        }
        return CartesianProduct.recursiveCartesianProduct(initials).stream().map(pc -> new CompositeConfiguration((List<IConfiguration>)pc)).collect(Collectors.toSet());
    }

    @Override
    public Collection<CompositeFireableTransition> fireableTransitionsFrom(CompositeConfiguration source) {
        HashSet<CompositeFireableTransition> fireableSet = new HashSet<CompositeFireableTransition>();
        for (int i = 0; i < this.runtimes.size(); ++i) {
            IConfiguration configuration = source.get(i);
            for (Object fireable : this.runtimes.get(i).fireableTransitionsFrom(configuration)) {
                fireableSet.add(new CompositeFireableTransition(i, fireable));
            }
        }
        return fireableSet;
    }

    @Override
    public IFiredTransition<CompositeConfiguration, CompositeAction> fireOneTransition(CompositeConfiguration source, CompositeFireableTransition compositeTransition) {
        CompositeConfiguration compositeTarget = source.createCopy();
        IConfiguration runtimeTarget = compositeTarget.get(compositeTransition.runtimeIndex);
        IFiredTransition<IConfiguration, ?> fired = this.runtimes.get(compositeTransition.runtimeIndex).fireOneTransition(runtimeTarget, compositeTransition.remote);
        if (fired == null) {
            return null;
        }
        boolean isFirst = true;
        ArrayList<CompositeConfiguration> compositeReachedTargets = new ArrayList<CompositeConfiguration>(fired.getTargets().size());
        for (IConfiguration reachedTarget : fired.getTargets()) {
            if (!isFirst) {
                compositeTarget = compositeTarget.createCopy();
            } else {
                isFirst = false;
            }
            compositeTarget.set(compositeTransition.runtimeIndex, reachedTarget);
            compositeReachedTargets.add(compositeTarget);
        }
        return new FiredTransition(source, compositeReachedTargets, new CompositeAction(compositeTransition.runtimeIndex, fired.getAction()));
    }

    @Override
    public boolean hasBlockingTransitions() {
        for (ITransitionRelation<IConfiguration, Object> runtime : this.runtimes) {
            if (!runtime.hasBlockingTransitions()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        for (ITransitionRelation<IConfiguration, Object> runtime : this.runtimes) {
            runtime.close();
        }
    }

    public static class CompositeFireableTransition {
        public final int runtimeIndex;
        public final Object remote;

        CompositeFireableTransition(int runtimeIndex, Object remote) {
            this.runtimeIndex = runtimeIndex;
            this.remote = remote;
        }
    }
}

