/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.variable;

import spinja.promela.compiler.variable.ChannelType;
import spinja.promela.compiler.variable.Variable;
import spinja.promela.compiler.variable.VariableType;
import spinja.util.StringWriter;

public class ChannelVariable
extends Variable {
    private static boolean channelsUsed = false;
    private static boolean rendezvousUsed = false;

    public static boolean isChannelsUsed() {
        return channelsUsed;
    }

    public static boolean isRendezvousUsed() {
        return rendezvousUsed;
    }

    public ChannelVariable(String string, int n) {
        super(ChannelType.UNASSIGNED_CHANNEL, string, n);
        channelsUsed = true;
    }

    private void addChannelInit(StringWriter stringWriter, String string) {
        if (this.getType() == ChannelType.UNASSIGNED_CHANNEL) {
            stringWriter.appendLine(this.getName(), string, " = (byte)-1; ");
        } else {
            stringWriter.appendLine(this.getName(), string, " = ", "addChannel(new Channel", this.getType().getId(), "());");
        }
    }

    @Override
    public ChannelType getType() {
        return (ChannelType)super.getType();
    }

    @Override
    public void setType(VariableType variableType) {
        if (!(variableType instanceof ChannelType)) {
            throw new IllegalArgumentException("Type must be a ChannelType");
        }
        super.setType(variableType);
    }

    @Override
    public void printInitExpr(StringWriter stringWriter) {
        if (this.getArraySize() > 1) {
            stringWriter.appendLine(this.getName(), " = new ", this.getType().getJavaName(), "[", this.getArraySize(), "];");
            stringWriter.appendLine("for(int _i = 0; _i < ", this.getArraySize(), "; _i++) {");
            stringWriter.indent();
            this.addChannelInit(stringWriter, "[_i]");
            stringWriter.outdent();
            stringWriter.appendLine("}");
        } else {
            this.addChannelInit(stringWriter, "");
        }
    }
}

