/*
 * Decompiled with CFR 0.152.
 */
package obp.states;

import obp.states.Element;
import obp.states.StatesVisitor;
import obp.states.Time;

public class State {
    protected Element[] elementList;
    protected Time time;
    protected int id;

    protected State() {
        this(-1, null, null);
    }

    public State(int id, Element[] elementList, Time time) {
        this.id = id;
        this.elementList = elementList;
        this.time = time;
    }

    public Element[] getElementList() {
        return this.elementList;
    }

    public int getElementCount() {
        return this.elementList.length;
    }

    public Time getTime() {
        return this.time;
    }

    public int getId() {
        return this.id;
    }

    public String getLabel() {
        return Integer.toString(this.id);
    }

    public void accept(StatesVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.elementList == null ? 0 : this.elementList.hashCode());
        result = 31 * result + (this.time == null ? 0 : this.time.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        State other = (State)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.elementList == null ? other.elementList != null : !this.elementList.equals(other.elementList)) {
            return false;
        }
        return !(this.time == null ? other.time != null : !this.time.equals(other.time));
    }
}

