/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.parser.repeating;

import java.util.Objects;
import org.petitparser.parser.Parser;
import org.petitparser.parser.combinators.DelegateParser;

public abstract class RepeatingParser
extends DelegateParser {
    public static final int UNBOUNDED = -1;
    protected final int min;
    protected final int max;

    public RepeatingParser(Parser delegate, int min, int max) {
        super(delegate);
        this.min = min;
        this.max = max;
        if (min < 0) {
            throw new IllegalArgumentException("Invalid min repetitions");
        }
        if (max != -1 && min > max) {
            throw new IllegalArgumentException("Invalid max repetitions");
        }
    }

    @Override
    public boolean hasEqualProperties(Parser other) {
        return super.hasEqualProperties(other) && Objects.equals(this.min, ((RepeatingParser)other).min) && Objects.equals(this.max, ((RepeatingParser)other).max);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.min + ".." + (this.max == -1 ? "*" : Integer.valueOf(this.max)) + "]";
    }
}

