/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server;

import emi.analysis.com.IConnection;
import emi.analysis.model.EMIAtom;
import emi.analysis.protocol.EMIProtocol;
import emi.analysis.protocol.EMIProtocolAtoms;
import emi.analysis.server.EMIServer;
import emi.analysis.server.atom.AtomManagementException;
import emi.analysis.server.atom.AtomManager;
import emi.analysis.server.atom.AtomsAndParams;
import emi.analysis.server.log.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ServiceEvaluateAtoms
extends EMIServer.AService {
    private AtomManager atomManager;

    public ServiceEvaluateAtoms(AtomManager atomManager, boolean log) {
        super(log);
        this.atomManager = atomManager;
        if (this.atomManager != null) {
            Log.i("Service: evaluation of atoms");
        }
    }

    @Override
    public void execute(EMIProtocol.Header header, IConnection connection) throws IOException {
        AtomsAndParams deserialized = EMIProtocolAtoms.deserialize(connection.read(header.size));
        ArrayList<EMIAtom> atoms = deserialized.getAtoms();
        List<byte[]> params = deserialized.getParams();
        try {
            if (this.atomManager == null) {
                throw new AtomManagementException("not available");
            }
            if (this.log || this.atomManager.hasLog()) {
                Log.d("Service: evaluate " + atoms.size() + " atom" + (atoms.size() > 1 ? "s" : ""));
            }
            this.atomManager.evaluate(atoms, params);
        }
        catch (AtomManagementException e) {
            Log.e("Atom evaluation service: " + e.getMessage());
            EMIProtocol.writeHeader(connection, new EMIProtocol.Header(1));
        }
    }
}

