/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.protocol;

import emi.analysis.model.EMIFireableTransition;
import emi.analysis.model.EMIFireableTransitionComposite;
import emi.analysis.protocol.EMIProtocolFireableTransition;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class EMIProtocolFireableTransitionComposite {
    public static final int SIZEOF_NB_TRANSITIONS = 4;

    private EMIProtocolFireableTransitionComposite() {
    }

    public static int deserialize(ArrayList<EMIFireableTransitionComposite> fireableCompositeTransitions, byte[] data) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        int nb = byteBuffer.getInt();
        for (int i = 0; i < nb; ++i) {
            ArrayList<EMIFireableTransitionComposite> compositeTransition = new ArrayList<EMIFireableTransitionComposite>();
            int bytesRead = EMIProtocolFireableTransitionComposite.deserializeOne(compositeTransition, byteBuffer.compact().array());
            byteBuffer.position(bytesRead);
            fireableCompositeTransitions.addAll(compositeTransition);
        }
        return byteBuffer.position();
    }

    public static int deserializeOne(ArrayList<EMIFireableTransitionComposite> fireableCompositeTransitions, byte[] data) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        ArrayList<EMIFireableTransition> fts = new ArrayList<EMIFireableTransition>();
        int bytesRead = EMIProtocolFireableTransition.deserialize(fts, byteBuffer.compact().array());
        byteBuffer.position(0);
        byte[] transitionData = new byte[bytesRead];
        byteBuffer.get(transitionData);
        EMIFireableTransitionComposite compositeTransition = new EMIFireableTransitionComposite(fts, transitionData);
        fireableCompositeTransitions.add(compositeTransition);
        return bytesRead;
    }

    public static byte[] serialize(EMIFireableTransitionComposite transition) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(EMIProtocolFireableTransitionComposite.getSize(transition));
        byteBuffer.putInt(transition.getTransitions().size());
        for (EMIFireableTransition fireableTransition : transition.getTransitions()) {
            byteBuffer.put(EMIProtocolFireableTransition.serialize(fireableTransition));
        }
        return byteBuffer.array();
    }

    public static int getSize(EMIFireableTransitionComposite transition) {
        int size = 4;
        for (EMIFireableTransition fireableTransition : transition.getTransitions()) {
            size += EMIProtocolFireableTransition.getSize(fireableTransition);
        }
        return size;
    }
}

