/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.serialization.propertyserializer;

import emi.serializer.metamodel.IStrategy;
import emi.serializer.metamodel.Metaclass;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.serialization.propertyserializer.OnlyInlinePropertySerializer;
import emi.serializer.serialization.propertyserializer.PropertySerializer;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class InlinePropertySerializer
extends PropertySerializer {
    private final String propertyName;

    @Override
    public CharSequence before(EObject e, MetamodelTable table, IStrategy strategy) {
        StringConcatenation _xblockexpression = null;
        EStructuralFeature property = e.eClass().getEStructuralFeature(this.propertyName);
        EClassifier propertyType = property.getEType();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("static ");
        String _typeName = UmlSerializerExtensions.typeName((EObject)propertyType);
        _builder.append(_typeName);
        _builder.append(" ");
        String _variableName = UmlSerializerExtensions.variableName(e);
        _builder.append(_variableName);
        _builder.append("_");
        String _name = property.getName();
        _builder.append(_name);
        _builder.append("[] = {");
        Object _eGet = e.eGet(property);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("C_");
        String _upperCase = UmlSerializerExtensions.typeName((EObject)propertyType).toUpperCase();
        _builder_1.append(_upperCase);
        _builder_1.append("_NULL");
        String _cInline = this.toCInline((Iterable)_eGet, _builder_1.toString(), table, strategy);
        _builder.append(_cInline);
        _builder.append("};");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    @Override
    public CharSequence inside(EObject e, MetamodelTable table, IStrategy strategy, boolean inline) {
        StringConcatenation _xblockexpression = null;
        EStructuralFeature property = e.eClass().getEStructuralFeature(this.propertyName);
        EClassifier propertyType = property.getEType();
        StringConcatenation _xifexpression = null;
        if (property.isMany() && inline) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(".");
            String _name = property.getName();
            _builder.append(_name);
            _builder.append(" = (");
            String _typeName = UmlSerializerExtensions.typeName((EObject)propertyType);
            _builder.append(_typeName);
            _builder.append(" * []) {");
            Object _eGet = e.eGet(property);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("C_");
            String _upperCase = UmlSerializerExtensions.typeName((EObject)propertyType).toUpperCase();
            _builder_1.append(_upperCase);
            _builder_1.append("_NULL");
            String _cInline = this.toCInline((Iterable)_eGet, _builder_1.toString(), table, strategy);
            _builder.append(_cInline);
            _builder.append("}");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(".");
            String _name_1 = property.getName();
            _builder_2.append(_name_1);
            _builder_2.append(" = ");
            String _variableName = UmlSerializerExtensions.variableName(e);
            _builder_2.append(_variableName);
            _builder_2.append("_");
            String _name_2 = property.getName();
            _builder_2.append(_name_2);
            _xifexpression = _builder_2;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String toCInline(Iterable<EObject> l, String lastElement, MetamodelTable table, IStrategy strategy) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.genericToCInline((EObject)it, table, strategy);
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(l, (Functions.Function1)_function), (CharSequence)", ");
        _builder.append(_join);
        String _xifexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty(l);
        _xifexpression = _isEmpty ? "" : ", ";
        _builder.append(_xifexpression);
        _builder.append(lastElement);
        return _builder.toString();
    }

    private String genericToCInline(EObject e, MetamodelTable table, IStrategy strategy) {
        String _xblockexpression = null;
        List<PropertySerializer> propertySerializers = null;
        Metaclass metaclass = table.getMetaclasses().get(e.eClass());
        if (metaclass != null) {
            propertySerializers = metaclass.getAllAttributes();
        }
        String _xifexpression = null;
        if (propertySerializers != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("{");
            String _addFieldsInitializers = strategy.addFieldsInitializers(e);
            _builder.append(_addFieldsInitializers);
            _builder.append(" ");
            Functions.Function1 _function = it -> !(it instanceof OnlyInlinePropertySerializer);
            Functions.Function1 _function_1 = it -> it.inside(e, table, strategy, true);
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(propertySerializers, (Functions.Function1)_function), (Functions.Function1)_function_1), (CharSequence)", ");
            _builder.append(_join);
            _builder.append("}");
            _xifexpression = _builder.toString();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    public CharSequence type(EClass e, Metaclass attributeMetaclass) {
        boolean _isMany;
        StringConcatenation _xblockexpression = null;
        EStructuralFeature property = e.getEStructuralFeature(this.propertyName);
        EClassifier propertyType = property.getEType();
        String propertyTypeName = new String();
        boolean needSpace = true;
        if (propertyType instanceof EClass || propertyType instanceof EEnum) {
            propertyTypeName = UmlSerializerExtensions.typeName((EObject)propertyType);
            if (propertyType instanceof EClass && !attributeMetaclass.isOnlyInline()) {
                propertyTypeName = propertyTypeName.concat(" *");
                needSpace = false;
            }
        }
        if (_isMany = property.isMany()) {
            if (needSpace) {
                propertyTypeName = propertyTypeName.concat(" ");
            }
            propertyTypeName = propertyTypeName.concat("*");
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(propertyTypeName);
        _builder.append(" ");
        _builder.append(this.propertyName);
        _builder.append(";");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    @Override
    public CharSequence defaultValue(EClass e) {
        StringConcatenation _xblockexpression = null;
        EStructuralFeature property = e.getEStructuralFeature(this.propertyName);
        StringConcatenation _xifexpression = null;
        boolean _isMany = property.isMany();
        if (_isMany) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(".");
            String _name = property.getName();
            _builder.append(_name);
            _builder.append(" = NULL");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(".");
            String _name_1 = property.getName();
            _builder_1.append(_name_1);
            _builder_1.append(" = 0");
            _xifexpression = _builder_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public InlinePropertySerializer(String propertyName) {
        this.propertyName = propertyName;
    }

    @Pure
    public int hashCode() {
        return 31 + (this.propertyName == null ? 0 : this.propertyName.hashCode());
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InlinePropertySerializer other = (InlinePropertySerializer)obj;
        return !(this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName));
    }

    @Pure
    public String toString() {
        return new ToStringBuilder((Object)this).addAllFields().toString();
    }

    @Pure
    public String getPropertyName() {
        return this.propertyName;
    }
}

