/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.serialization.propertyserializer;

import com.google.common.base.Objects;
import emi.serializer.metamodel.IStrategy;
import emi.serializer.metamodel.Metaclass;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.serialization.propertyserializer.PropertySerializer;
import emi.serializer.utils.UmlSerializerExtensions;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class DefaultPropertySerializer
extends PropertySerializer {
    private final String propertyName;
    private final EClassifier simplifiedPropertyType;

    public EClassifier getType(EStructuralFeature property) {
        EClassifier _xifexpression = null;
        _xifexpression = this.simplifiedPropertyType != null ? this.simplifiedPropertyType : property.getEType();
        return _xifexpression;
    }

    private CharSequence getTypeName(EStructuralFeature property) {
        StringConcatenation _xblockexpression = null;
        EClassifier propertyType = this.getType(property);
        Object _xifexpression = null;
        if (propertyType instanceof EDataType) {
            String _switchResult = null;
            String _name = property.getEType().getName();
            if (_name != null) {
                switch (_name) {
                    case "String": {
                        _switchResult = "char";
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            } else {
                throw new RuntimeException();
            }
            _xifexpression = _switchResult;
        } else {
            StringConcatenation _builder = new StringConcatenation();
            String _typeName = UmlSerializerExtensions.typeName((EObject)propertyType);
            _builder.append(_typeName);
            _xifexpression = _builder;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    public CharSequence before(EObject e, MetamodelTable table, IStrategy strategy) {
        String _xblockexpression = null;
        EStructuralFeature property = e.eClass().getEStructuralFeature(this.propertyName);
        EClassifier propertyType = this.getType(property);
        String _xifexpression = null;
        boolean _isMany = property.isMany();
        if (_isMany) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("static ");
            CharSequence _typeName = this.getTypeName(property);
            _builder.append((Object)_typeName);
            _builder.append(" * ");
            String _variableName = UmlSerializerExtensions.variableName(e);
            _builder.append(_variableName);
            _builder.append("_");
            String _name = property.getName();
            _builder.append(_name);
            _builder.append("[] = {");
            Object _eGet = e.eGet(property);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("(");
            String _typeName_1 = UmlSerializerExtensions.typeName((EObject)propertyType);
            _builder_1.append(_typeName_1);
            _builder_1.append("*)");
            CharSequence _c = UmlSerializerExtensions.toC((Iterable)_eGet, _builder_1.toString());
            _builder.append((Object)_c);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    public CharSequence inside(EObject e, MetamodelTable table, IStrategy strategy, boolean inline) {
        StringConcatenation _xblockexpression = null;
        EStructuralFeature property = e.eClass().getEStructuralFeature(this.propertyName);
        EClassifier propertyType = this.getType(property);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".");
        String _name = property.getName();
        _builder.append(_name);
        _builder.append(" = ");
        CharSequence _xifexpression = null;
        boolean _isMany = property.isMany();
        if (_isMany) {
            StringConcatenation _xifexpression_1 = null;
            if (inline) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("(");
                CharSequence _typeName = this.getTypeName(property);
                _builder_1.append((Object)_typeName);
                _builder_1.append(" * []) {");
                Object _eGet = e.eGet(property);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("(");
                String _typeName_1 = UmlSerializerExtensions.typeName((EObject)propertyType);
                _builder_2.append(_typeName_1);
                _builder_2.append("*)");
                CharSequence _c = UmlSerializerExtensions.toC((Iterable)_eGet, _builder_2.toString());
                _builder_1.append((Object)_c);
                _builder_1.append("}");
                _xifexpression_1 = _builder_1;
            } else {
                StringConcatenation _builder_3 = new StringConcatenation();
                String _variableName = UmlSerializerExtensions.variableName(e);
                _builder_3.append(_variableName);
                _builder_3.append("_");
                String _name_1 = property.getName();
                _builder_3.append(_name_1);
                _xifexpression_1 = _builder_3;
            }
            _xifexpression = _xifexpression_1;
        } else {
            CharSequence _xifexpression_2 = null;
            if (propertyType instanceof EClass) {
                String _xblockexpression_1 = null;
                Object _eGet_1 = e.eGet(property);
                EObject v = (EObject)_eGet_1;
                String _xifexpression_3 = null;
                if (v != null && !Objects.equal((Object)v.eClass(), (Object)propertyType)) {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("(");
                    String _typeName_2 = UmlSerializerExtensions.typeName((EObject)propertyType);
                    _builder_4.append(_typeName_2);
                    _builder_4.append("*)");
                    _xifexpression_3 = _builder_4.toString();
                } else {
                    _xifexpression_3 = "";
                }
                _xblockexpression_1 = UmlSerializerExtensions.variableRef(v, _xifexpression_3);
                _xifexpression_2 = _xblockexpression_1;
            } else {
                CharSequence _xifexpression_3 = null;
                Class _instanceClass = propertyType.getInstanceClass();
                boolean _equals = Objects.equal((Object)_instanceClass, String.class);
                if (_equals) {
                    Object _eGet_1 = e.eGet(property);
                    _xifexpression_3 = UmlSerializerExtensions.toCString((String)_eGet_1);
                } else {
                    _xifexpression_3 = UmlSerializerExtensions.dataToC(e.eGet(property));
                }
                _xifexpression_2 = _xifexpression_3;
            }
            _xifexpression = _xifexpression_2;
        }
        _builder.append((Object)_xifexpression);
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    @Override
    public CharSequence type(EClass e, Metaclass attributeMetaclass) {
        boolean _isMany;
        StringConcatenation _xblockexpression = null;
        EStructuralFeature property = e.getEStructuralFeature(this.propertyName);
        EClassifier propertyType = this.getType(property);
        String propertyTypeName = new String();
        boolean needSpace = true;
        if (propertyType instanceof EClass || propertyType instanceof EEnum) {
            propertyTypeName = UmlSerializerExtensions.typeName((EObject)propertyType);
            if (propertyType instanceof EClass && !attributeMetaclass.isOnlyInline()) {
                propertyTypeName = propertyTypeName.concat(" *");
                needSpace = false;
            }
        } else {
            Class _instanceClass = propertyType.getInstanceClass();
            boolean _equals = Objects.equal((Object)_instanceClass, String.class);
            if (_equals) {
                propertyTypeName = "char *";
                needSpace = false;
            } else {
                Class _instanceClass_2;
                boolean _equals_2;
                Class _instanceClass_1 = propertyType.getInstanceClass();
                boolean _equals_1 = Objects.equal((Object)_instanceClass_1, Boolean.TYPE);
                propertyTypeName = _equals_1 ? "bool" : ((_equals_2 = Objects.equal((Object)(_instanceClass_2 = propertyType.getInstanceClass()), Integer.TYPE)) ? "int" : propertyType.getName());
            }
        }
        if (_isMany = property.isMany()) {
            if (needSpace) {
                propertyTypeName = propertyTypeName.concat(" ");
            }
            propertyTypeName = propertyTypeName.concat("*");
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(propertyTypeName);
        _builder.append(" ");
        _builder.append(this.propertyName);
        _builder.append(";");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    @Override
    public CharSequence defaultValue(EClass e) {
        StringConcatenation _xblockexpression = null;
        EStructuralFeature property = e.getEStructuralFeature(this.propertyName);
        EClassifier propertyType = property.getEType();
        StringConcatenation _xifexpression = null;
        if ((propertyType instanceof EEnum || propertyType instanceof EClass || Objects.equal((Object)propertyType.getInstanceClass(), Boolean.TYPE) || Objects.equal((Object)propertyType.getInstanceClass(), Integer.TYPE)) && !property.isMany()) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(".");
            String _name = property.getName();
            _builder.append(_name);
            _builder.append(" = 0");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(".");
            String _name_1 = property.getName();
            _builder_1.append(_name_1);
            _builder_1.append(" = NULL");
            _xifexpression = _builder_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public DefaultPropertySerializer(String propertyName, EClassifier simplifiedPropertyType) {
        this.propertyName = propertyName;
        this.simplifiedPropertyType = simplifiedPropertyType;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
        return 31 * result + (this.simplifiedPropertyType == null ? 0 : this.simplifiedPropertyType.hashCode());
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultPropertySerializer other = (DefaultPropertySerializer)obj;
        if (this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName)) {
            return false;
        }
        return !(this.simplifiedPropertyType == null ? other.simplifiedPropertyType != null : !this.simplifiedPropertyType.equals(other.simplifiedPropertyType));
    }

    @Pure
    public String toString() {
        return new ToStringBuilder((Object)this).addAllFields().toString();
    }

    @Pure
    public String getPropertyName() {
        return this.propertyName;
    }

    @Pure
    public EClassifier getSimplifiedPropertyType() {
        return this.simplifiedPropertyType;
    }
}

