/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.configuration.emf;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralSpecification;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import plug.language.emi.configuration.emf.ConfigurationVisitor;

public class InstanceSpecificationTranslator
implements ConfigurationVisitor {
    private final UMLFactory uml = UMLFactory.eINSTANCE;
    private final Map<String, InstanceSpecification> objectsByName = new HashMap<String, InstanceSpecification>();
    private final List<InstanceSpecification> objects = new ArrayList<InstanceSpecification>();
    private final List<InstanceSpecification> signalInstances = new ArrayList<InstanceSpecification>();
    private final Class aoClass = this.uml.createClass();
    private final Property csProperty = this.uml.createProperty();
    private final Property epProperty = this.uml.createProperty();
    private final List<Class> additionalClasses = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{this.aoClass}));
    private final boolean incremental = true;
    private InstanceSpecification currentObject = null;

    @Override
    public void start() {
        this.aoClass.setName("ActiveObject");
        this.aoClass.getOwnedAttributes().add((Object)this.csProperty);
        this.aoClass.getOwnedAttributes().add((Object)this.epProperty);
        this.csProperty.setName("__currentState__");
        this.epProperty.setName("__eventPool__");
    }

    public void clearObjects(List<InstanceSpecification> objects) {
        Consumer<InstanceSpecification> _function = it -> {
            Consumer<Slot> _function_1 = it_1 -> it_1.setDefiningFeature(null);
            it.getSlots().forEach(_function_1);
            it.getClassifiers().clear();
        };
        objects.forEach(_function);
    }

    @Override
    public void restart() {
        this.getClass();
    }

    @Override
    public void visitObject(String name, Class type) {
        InstanceSpecification _elvis = null;
        InstanceSpecification _get = this.objectsByName.get(name);
        if (_get != null) {
            _elvis = _get;
        } else {
            InstanceSpecification _xblockexpression = null;
            InstanceSpecification object = this.uml.createInstanceSpecification();
            this.objectsByName.put(name, object);
            this.objects.add(object);
            object.setName(name);
            object.getClassifiers().add((Object)type);
            _elvis = _xblockexpression = object;
        }
        this.currentObject = _elvis;
    }

    public boolean addActiveObjectIfMissing() {
        boolean _not;
        boolean _xifexpression = false;
        boolean _contains = this.currentObject.getClassifiers().contains((Object)this.aoClass);
        boolean bl = _not = !_contains;
        if (_not) {
            _xifexpression = this.currentObject.getClassifiers().add((Object)this.aoClass);
        }
        return _xifexpression;
    }

    public Slot getSlot(InstanceSpecification object, Property definingFeature) {
        Functions.Function1 _function = it -> {
            StructuralFeature _definingFeature = it.getDefiningFeature();
            return _definingFeature == definingFeature;
        };
        return (Slot)IterableExtensions.findFirst((Iterable)object.getSlots(), (Functions.Function1)_function);
    }

    @Override
    public void visitCurrentState(String name) {
        Slot _elvis = null;
        Slot _slot = this.getSlot(this.currentObject, this.csProperty);
        if (_slot != null) {
            _elvis = _slot;
        } else {
            Slot _xblockexpression = null;
            this.addActiveObjectIfMissing();
            Slot slot = this.uml.createSlot();
            this.currentObject.getSlots().add((Object)slot);
            slot.setDefiningFeature((StructuralFeature)this.csProperty);
            _elvis = _xblockexpression = slot;
        }
        Slot slot = _elvis;
        boolean _isEmpty = slot.getValues().isEmpty();
        if (_isEmpty) {
            slot.getValues().add((Object)this.translateValue(name));
        } else {
            ValueSpecification _get = (ValueSpecification)slot.getValues().get(0);
            ((LiteralString)_get).setValue(name);
        }
    }

    @Override
    public void visitEventPoolEvent(Signal signal, Map<Property, Object> params) {
        Slot _elvis = null;
        Slot _slot = this.getSlot(this.currentObject, this.epProperty);
        if (_slot != null) {
            _elvis = _slot;
        } else {
            Slot _xblockexpression = null;
            this.addActiveObjectIfMissing();
            Slot slot = this.uml.createSlot();
            slot.setDefiningFeature((StructuralFeature)this.epProperty);
            this.currentObject.getSlots().add((Object)slot);
            _elvis = _xblockexpression = slot;
        }
        Slot slot = _elvis;
        InstanceSpecification object = this.uml.createInstanceSpecification();
        this.signalInstances.add(object);
        StringConcatenation _builder = new StringConcatenation();
        String _name = this.currentObject.getName();
        _builder.append(_name);
        _builder.append("[");
        int _size = slot.getValues().size();
        _builder.append((Object)_size);
        _builder.append("]");
        object.setName(_builder.toString());
        object.getClassifiers().add((Object)signal);
        InstanceValue iv = this.uml.createInstanceValue();
        iv.setInstance(object);
        slot.getValues().add((Object)iv);
        BiConsumer<Property, Object> _function = (definingFeature, value) -> {
            Slot signalSlot = this.uml.createSlot();
            object.getSlots().add((Object)signalSlot);
            signalSlot.setDefiningFeature((StructuralFeature)definingFeature);
            this.setValue(signalSlot, value);
        };
        params.forEach(_function);
    }

    public LiteralSpecification translateValue(Object value) {
        LiteralBoolean ret;
        LiteralBoolean _xblockexpression;
        LiteralBoolean _switchResult = null;
        boolean _matched = false;
        if (value instanceof Boolean) {
            _matched = true;
            _xblockexpression = null;
            ret = this.uml.createLiteralBoolean();
            ret.setValue(((Boolean)value).booleanValue());
            _switchResult = _xblockexpression = ret;
        }
        if (!_matched && value instanceof Integer) {
            _matched = true;
            _xblockexpression = null;
            ret = this.uml.createLiteralInteger();
            ret.setValue(((Integer)value).intValue());
            _switchResult = _xblockexpression = ret;
        }
        if (!_matched && value instanceof String) {
            _matched = true;
            _xblockexpression = null;
            ret = this.uml.createLiteralString();
            ret.setValue((String)value);
            _switchResult = _xblockexpression = ret;
        }
        if (!_matched) {
            _xblockexpression = null;
            ret = this.uml.createLiteralString();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("error: cannot translate value ");
            _builder.append(value);
            _builder.append(" of type ");
            java.lang.Class<?> _class = value.getClass();
            _builder.append(_class);
            _builder.append(" to UML");
            ret.setValue(_builder.toString());
            _switchResult = _xblockexpression = ret;
        }
        return _switchResult;
    }

    public void updateValue(ValueSpecification vs, Object value) {
        boolean _tripleNotEquals;
        boolean _matched = false;
        if (value instanceof Boolean) {
            _matched = true;
            LiteralBoolean lb = (LiteralBoolean)vs;
            boolean _isValue = lb.isValue();
            boolean bl = _tripleNotEquals = Boolean.valueOf(_isValue) != value;
            if (_tripleNotEquals) {
                lb.setValue(((Boolean)value).booleanValue());
            }
        }
        if (!_matched && value instanceof Integer) {
            _matched = true;
            LiteralInteger li = (LiteralInteger)vs;
            int _value = li.getValue();
            boolean bl = _tripleNotEquals = _value != (Integer)value;
            if (_tripleNotEquals) {
                li.setValue(((Integer)value).intValue());
            }
        }
        if (!_matched && value instanceof String) {
            boolean _not;
            _matched = true;
            LiteralString ls = (LiteralString)vs;
            boolean _contentEquals = ls.getValue().contentEquals((CharSequence)value);
            boolean bl = _not = !_contentEquals;
            if (_not) {
                ls.setValue((String)value);
            }
        }
        if (!_matched) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("error: cannot translate value ");
            _builder.append(value);
            _builder.append(" of type ");
            java.lang.Class<?> _class = value.getClass();
            _builder.append(_class);
            _builder.append(" to UML");
            ((LiteralString)vs).setValue(_builder.toString());
        }
    }

    public Boolean setValue(Slot slot, Object value) {
        boolean _xifexpression = false;
        if (value instanceof Collection) {
            boolean _xifexpression_1 = false;
            boolean _isEmpty = slot.getValues().isEmpty();
            if (_isEmpty) {
                Functions.Function1 _function = it -> this.translateValue(it);
                _xifexpression_1 = Iterables.addAll((Collection)slot.getValues(), (Iterable)IterableExtensions.map((Iterable)((Iterable)value), (Functions.Function1)_function));
            } else {
                Iterator vss = slot.getValues().iterator();
                for (Object v : (Collection)value) {
                    boolean _hasNext = vss.hasNext();
                    if (_hasNext) {
                        this.updateValue((ValueSpecification)vss.next(), v);
                        continue;
                    }
                    slot.getValues().add((Object)this.translateValue(v));
                }
            }
            _xifexpression = _xifexpression_1;
        } else {
            boolean _xifexpression_2 = false;
            boolean _isEmpty_1 = slot.getValues().isEmpty();
            if (_isEmpty_1) {
                _xifexpression_2 = slot.getValues().add((Object)this.translateValue(value));
            } else {
                this.updateValue((ValueSpecification)slot.getValues().get(0), value);
            }
            _xifexpression = _xifexpression_2;
        }
        return _xifexpression;
    }

    @Override
    public void visitSlot(Property definingFeature, Object value) {
        Slot _elvis = null;
        Slot _slot = this.getSlot(this.currentObject, definingFeature);
        if (_slot != null) {
            _elvis = _slot;
        } else {
            Slot _xblockexpression = null;
            Slot slot = this.uml.createSlot();
            slot.setDefiningFeature((StructuralFeature)definingFeature);
            this.currentObject.getSlots().add((Object)slot);
            _elvis = _xblockexpression = slot;
        }
        Slot slot = _elvis;
        this.setValue(slot, value);
    }

    @Override
    public void finish() {
    }

    public void saveModel() {
        try {
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource _createResource = rs.createResource(URI.createFileURI((String)"configuration.uml"));
            XMIResource r = (XMIResource)_createResource;
            r.getContents().addAll(this.objects);
            r.getContents().addAll(this.additionalClasses);
            r.getContents().addAll(this.signalInstances);
            r.setID((EObject)this.aoClass, "ActiveObject");
            r.setID((EObject)this.csProperty, "ActiveObject_currentState");
            r.setID((EObject)this.epProperty, "ActiveObject_eventPool");
            Consumer<InstanceSpecification> _function = it -> r.setID((EObject)it, it.getName().replaceAll("\\[", "_").replaceAll("]", ""));
            this.signalInstances.forEach(_function);
            r.save(Collections.emptyMap());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

