/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.configuration.emf;

import com.google.common.base.Objects;
import emi.analysis.model.EMIConfiguration;
import emi.analysis.model.EMIFireableTransitionComposite;
import emi.analysis.server.translator.Translator;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import plug.language.emi.configuration.emf.ConfigurationVisitor;
import plug.language.emi.configuration.emf.InstanceSpecificationTranslator;
import plug.language.emi.observers.EMIObserver;
import plug.language.emi.runtime.EMIRuntime;

public class Configuration2Model
implements EMIObserver {
    private final Translator translator;
    private ConfigurationVisitor visitor = null;
    private final Map<Classifier, List<Property>> allAttributesCache = new HashMap<Classifier, List<Property>>();

    public Configuration2Model(Translator translator) {
        this.translator = translator;
    }

    public void init(EMIRuntime runtime) {
        System.out.println("Initializing Configuration2Model");
        runtime.addEMIObserver(this);
    }

    @Override
    public void configurationChanged(EMIConfiguration configuration) {
        if (this.visitor == null) {
            InstanceSpecificationTranslator _instanceSpecificationTranslator = new InstanceSpecificationTranslator();
            this.visitor = _instanceSpecificationTranslator;
            this.visitor.start();
        } else {
            this.visitor.restart();
        }
        Consumer<Translator.MetaECTreeItem> _function = it -> {
            Class classifier = (Class)this.translator.getSymbolMatcher().search(Class.class, it.getType().replaceFirst("_store$", ""));
            this.visitor.visitObject(it.getName(), classifier);
            Consumer<Translator.MetaECTreeItem> _function_1 = metaSlot -> {
                block14: {
                    block13: {
                        String _name = metaSlot.getName();
                        if (_name == null) break block13;
                        switch (_name) {
                            case "cs": {
                                int n;
                                this.visitor.visitCurrentState(metaSlot.computeValue(configuration));
                                Translator.MetaECTreeItem ep = this.get((Translator.MetaECTreeItem)it, "ep");
                                if (ep != null && (n = Integer.parseInt(this.get(ep, "nbEvents").computeValue(configuration))) > 0) {
                                    Translator.MetaECTreeItem ep_params = this.get((Translator.MetaECTreeItem)it, "ep_params");
                                    Consumer<Translator.MetaECTreeItem> _function_2 = it_1 -> {
                                        Signal signal = ((SignalEvent)this.translator.getSymbolMatcher().search(SignalEvent.class, this.get((Translator.MetaECTreeItem)it_1, "signalEventId").computeValue(configuration))).getSignal();
                                        LinkedHashMap<Property, Object> params = new LinkedHashMap<Property, Object>();
                                        if (ep_params != null) {
                                            Translator.MetaECTreeItem union = this.get(this.get(this.get(ep_params, "eventOccurred"), it_1.getName()), "union");
                                            StringConcatenation _builder = new StringConcatenation();
                                            String _name_1 = signal.getName();
                                            _builder.append(_name_1);
                                            _builder.append("_params");
                                            Translator.MetaECTreeItem p = this.get(union, _builder.toString());
                                            if (p != null) {
                                                Consumer<Translator.MetaECTreeItem> _function_3 = eventParam -> {
                                                    Functions.Function1 _function_4 = it_2 -> {
                                                        String _name_2 = it_2.getName();
                                                        String _name_3 = eventParam.getName();
                                                        return Objects.equal((Object)_name_2, (Object)_name_3);
                                                    };
                                                    params.put((Property)IterableExtensions.findFirst(this.cachedAllAttributes((Classifier)signal), (Functions.Function1)_function_4), this.translateValue(configuration, (Translator.MetaECTreeItem)eventParam));
                                                };
                                                p.getChildren().forEach(_function_3);
                                            }
                                        }
                                        this.visitor.visitEventPoolEvent(signal, params);
                                    };
                                    IterableExtensions.take((Iterable)this.get(ep, "eventOccurred").getChildren(), (int)n).forEach(_function_2);
                                    break;
                                }
                                break block14;
                            }
                            case "ep": {
                                break;
                            }
                            case "ep_params": {
                                break;
                            }
                            case "od": {
                                Consumer<Translator.MetaECTreeItem> _function_3 = slot -> {
                                    Functions.Function1 _function_4 = it_1 -> {
                                        String _name_1 = it_1.getName();
                                        String _name_2 = slot.getName();
                                        return Objects.equal((Object)_name_1, (Object)_name_2);
                                    };
                                    Property _findFirst = (Property)IterableExtensions.findFirst(this.cachedAllAttributes((Classifier)classifier), (Functions.Function1)_function_4);
                                    Object _xifexpression = null;
                                    boolean _isLeaf = slot.isLeaf();
                                    if (_isLeaf) {
                                        _xifexpression = this.translateValue(configuration, (Translator.MetaECTreeItem)slot);
                                    } else {
                                        Functions.Function1 _function_5 = it_1 -> this.translateValue(configuration, (Translator.MetaECTreeItem)it_1);
                                        _xifexpression = IteratorExtensions.toList((Iterator)IteratorExtensions.map(slot.getChildren().iterator(), (Functions.Function1)_function_5));
                                    }
                                    this.visitor.visitSlot(_findFirst, _xifexpression);
                                };
                                metaSlot.getChildren().forEach(_function_3);
                                break;
                            }
                            default: {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append("Cannot translate metafield ");
                                String _name_1 = metaSlot.getName();
                                _builder.append(_name_1);
                                InputOutput.println((Object)_builder.toString());
                            }
                        }
                        break block14;
                    }
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Cannot translate metafield ");
                    String _name_1 = metaSlot.getName();
                    _builder.append(_name_1);
                    InputOutput.println((Object)_builder.toString());
                }
            };
            it.getChildren().forEach(_function_1);
        };
        this.translator.getMetaECTreeRoot().getChildren().forEach(_function);
        this.visitor.finish();
    }

    public List<Property> cachedAllAttributes(Classifier c) {
        EList _elvis = null;
        EList _get = this.allAttributesCache.get(c);
        if (_get != null) {
            _elvis = _get;
        } else {
            EList _xblockexpression = null;
            EList allAttributes = c.getAllAttributes();
            this.allAttributesCache.put(c, (List<Property>)allAttributes);
            _elvis = _xblockexpression = allAttributes;
        }
        return _elvis;
    }

    public Translator.MetaECTreeItem get(Translator.MetaECTreeItem it, String name) {
        Functions.Function1 _function = it_1 -> {
            String _name = it_1.getName();
            return Objects.equal((Object)_name, (Object)name);
        };
        return (Translator.MetaECTreeItem)IterableExtensions.findFirst((Iterable)it.getChildren(), (Functions.Function1)_function);
    }

    public Object translateValue(EMIConfiguration configuration, Translator.MetaECTreeItem item) {
        String _xifexpression = null;
        boolean _isLeaf = item.isLeaf();
        if (_isLeaf) {
            Object _xifexpression_1 = null;
            if (Objects.equal((Object)item.getName(), (Object)"cs") || Objects.equal((Object)item.getName(), (Object)"signalEventId") || Objects.equal((Object)item.getName(), (Object)"portId")) {
                _xifexpression_1 = item.computeValue(configuration);
            } else {
                Constable _xifexpression_2 = null;
                if (item.getType().startsWith("int") || item.getType().startsWith("unsigned int") || item.getType().startsWith("char") || item.getType().startsWith("unsigned char") || item.getType().endsWith("_t")) {
                    _xifexpression_2 = Integer.parseInt(item.computeValue(configuration));
                } else {
                    Object _xifexpression_3 = null;
                    boolean _startsWith = item.getType().startsWith("bool");
                    if (_startsWith) {
                        String _computeValue = item.computeValue(configuration);
                        _xifexpression_3 = Objects.equal((Object)_computeValue, (Object)"true");
                    } else {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("error: cannot translate value of type ");
                        String _type = item.getType();
                        _builder.append(_type);
                        _builder.append(" for ConfigurationVisitor");
                        _xifexpression_3 = _builder.toString();
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("error: expected a primitive value, or an object, not a ");
            String _type_1 = item.getType();
            _builder_1.append(_type_1);
            _builder_1.append(".");
            _xifexpression = _builder_1.toString();
        }
        return _xifexpression;
    }

    @Override
    public void fireablesChanged(List<EMIFireableTransitionComposite> fireableTransitions) {
    }

    @Override
    public void firedChanged(EMIFireableTransitionComposite firedTransition) {
    }
}

