/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi;

import emi.analysis.json.DefaultTransitionJson;
import emi.analysis.model.EMIFireableTransitionComposite;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import plug.core.IRuntimeView;
import plug.core.view.ConfigurationItem;
import plug.language.emi.model.PlugRuntimeConfiguration;
import plug.language.emi.runtime.EMIRuntime;
import plug.language.emi.translator.PlugConfigurationJson;

public class EMIRuntimeView
implements IRuntimeView<PlugRuntimeConfiguration, EMIFireableTransitionComposite> {
    private EMIRuntime runtime;
    private DefaultTransitionJson transitionJson;
    private PlugConfigurationJson configurationJson;

    public EMIRuntimeView(EMIRuntime runtime) {
        this.runtime = runtime;
        this.transitionJson = new DefaultTransitionJson();
        this.configurationJson = new PlugConfigurationJson();
    }

    public EMIRuntime getRuntime() {
        return this.runtime;
    }

    public List<ConfigurationItem> getConfigurationItems(PlugRuntimeConfiguration value) {
        String s = this.runtime.getTranslation(value.getEMIConfiguration());
        ConfigurationItem item = this.configurationJson.deserialize(s);
        return Collections.singletonList(item);
    }

    public String getFireableTransitionDescription(EMIFireableTransitionComposite transition) {
        String s = this.runtime.getTranslation(transition);
        return this.transitionJson.deserialize(s);
    }

    public String getActionDescription(Object action) {
        String s = null;
        s = action instanceof EMIFireableTransitionComposite ? this.getFireableTransitionDescription((EMIFireableTransitionComposite)action) : Objects.toString(action);
        return s;
    }
}

