/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.types;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import emi.serializer.memoryobjects.PropertiesRO;
import emi.serializer.memoryobjects.Transitions;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.BodyOwner;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class Types {
    private final int NB_EXECUTION_STEPS = 1000000;
    private final int NB_FIREABLES_SUM = 65535;
    private final int EVENT_POOL_SIZE = 32;
    private final int EVENT_SET_SIZE = 32;
    private final int NB_ATOMS = 10;
    private final int ATOM_SIZE = 2048;
    private final int NB_COMMANDS = 255;
    private final int COMMAND_SIZE = 65535;
    private final int CURRENT_STATE_SIZE = 4;
    private final int EVENT_SIZE = 4;
    private final int ATTRIBUTE_SIZE = 4;
    private final int NB_FIFO_LAYERS = 3;
    private final int NB_FIFO_ELEMENTS = 32;
    private final int MAX_PRIORITY_FP = 10000;
    private final ResourceManager resourceManager;

    public Types(ResourceManager rm) {
        this.resourceManager = rm;
    }

    public int getCurrentStateMaxSize() {
        Integer _xblockexpression = null;
        Function<Resource, List> _function = it -> IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), StateMachine.class));
        List stateMachines = this.resourceManager.getList(_function);
        Functions.Function1 _function_1 = it -> (Region)IterableExtensions.head((Iterable)it.getRegions());
        List regions = IterableExtensions.toList((Iterable)ListExtensions.map(stateMachines, (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> it.getSubvertices().size();
        _xblockexpression = (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)regions, (Functions.Function1)_function_2));
        return _xblockexpression;
    }

    private String getIntType(int max, boolean signed) {
        String _xblockexpression = null;
        String string = null;
        string = signed ? (max <= 127 ? "int8_t  " : (max <= Short.MAX_VALUE ? "int16_t " : "int32_t ")) : (max <= 255 ? "uint8_t " : (max <= 65535 ? "uint16_t" : "uint32_t"));
        _xblockexpression = string;
        return _xblockexpression;
    }

    private int sum(Iterable<Integer> iterable) {
        int _xblockexpression = 0;
        int sum = 0;
        List list = IterableExtensions.toList(iterable);
        for (int i = 0; i < list.size(); ++i) {
            int _sum = sum;
            Integer _get = (Integer)list.get(i);
            sum = _sum + _get;
        }
        _xblockexpression = sum;
        return _xblockexpression;
    }

    private int sum(Iterator<Integer> iterator) {
        int _xblockexpression = 0;
        int sum = 0;
        while (iterator.hasNext()) {
            int _sum = sum;
            Integer _next = iterator.next();
            sum = _sum + _next;
        }
        _xblockexpression = sum;
        return _xblockexpression;
    }

    private String serializeMetamodelTypes() {
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        String _xblockexpression = null;
        Function<Resource, List> _function = it -> IteratorExtensions.toList(emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)it.getAllContents(), Class.class));
        List classes = this.resourceManager.getList(_function);
        Functions.Function1 _function_1 = it -> it.getOwnedAttributes().size();
        Integer nbOwnedAttributes = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(classes, (Functions.Function1)_function_1));
        Function<Resource, List> _function_2 = it -> {
            Functions.Function1 _function_3 = it_1 -> it_1 instanceof OpaqueBehavior || it_1 instanceof OpaqueExpression;
            return IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)it.getAllContents(), (Functions.Function1)_function_3));
        };
        List opaques = this.resourceManager.getList(_function_2);
        int nbMaxLanguages = 0;
        int nbMaxBodies = 0;
        boolean _isEmpty = opaques.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1 _function_3 = it -> ((Object[])Conversions.unwrapArray((Object)((BodyOwner)it).getLanguages(), Object.class)).length;
            nbMaxLanguages = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(opaques, (Functions.Function1)_function_3));
            Functions.Function1 _function_4 = it -> ((Object[])Conversions.unwrapArray((Object)((BodyOwner)it).getBodies(), Object.class)).length;
            nbMaxBodies = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(opaques, (Functions.Function1)_function_4));
        }
        Functions.Function1 _function_5 = it -> ((Object[])Conversions.unwrapArray(UmlNavigation.getAttributesNotPeers((Classifier)it), Object.class)).length;
        Integer nbPrimitiveAttributes = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(classes, (Functions.Function1)_function_5));
        Function<Resource, List> _function_6 = it -> IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), StateMachine.class));
        List stateMachines = this.resourceManager.getList(_function_6);
        Function<Resource, List> _function_7 = it -> IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), Region.class));
        List regions = this.resourceManager.getList(_function_7);
        Function<Resource, List> _function_8 = it -> IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), Transition.class));
        List transitions = this.resourceManager.getList(_function_8);
        Functions.Function1 _function_9 = it -> it.getRegions().size();
        Integer nbMaxRegions = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(stateMachines, (Functions.Function1)_function_9));
        int nbMaxStates = this.getCurrentStateMaxSize();
        Functions.Function1 _function_10 = it -> it.getTransitions().size();
        Integer nbMaxTransitions = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(regions, (Functions.Function1)_function_10));
        Functions.Function1 _function_11 = it -> it.getTriggers().size();
        Integer nbMaxTriggers = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(transitions, (Functions.Function1)_function_11));
        int nbSignalEvents = ((Object[])Conversions.unwrapArray(UmlNavigation.getSignalEvents(this.resourceManager), Object.class)).length;
        Function<Resource, List> _function_12 = it -> IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), Enumeration.class));
        List enumerations = this.resourceManager.getList(_function_12);
        int nbMaxEnumerationLiterals = 0;
        int _size = enumerations.size();
        boolean bl2 = _notEquals = _size != 0;
        if (_notEquals) {
            Functions.Function1 _function_13 = it -> it.getOwnedLiterals().size();
            nbMaxEnumerationLiterals = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(enumerations, (Functions.Function1)_function_13));
        }
        Functions.Function1 _function_14 = it -> it.getInterfaceRealizations().size();
        Integer nbInterfaceRealizations = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(classes, (Functions.Function1)_function_14));
        Function<Resource, List> _function_15 = it -> {
            Functions.Function1 _function_16 = it_1 -> it_1.getOwnedReceptions();
            return IteratorExtensions.toList((Iterator)IteratorExtensions.map(emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)it.getAllContents(), Class.class), (Functions.Function1)_function_16));
        };
        List receptions = this.resourceManager.getList(_function_15);
        Function<Resource, List> _function_16 = it -> {
            Functions.Function1 _function_17 = it_1 -> it_1.getOwnedReceptions();
            return IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)it.getAllContents(), Interface.class), (Functions.Function1)_function_17));
        };
        receptions.addAll(this.resourceManager.getList(_function_16));
        Functions.Function1 _function_17 = it -> ((Object[])Conversions.unwrapArray((Object)it, Object.class)).length;
        Integer nbReceptions = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(receptions, (Functions.Function1)_function_17));
        Function<Resource, List> _function_18 = it -> {
            Functions.Function1 _function_19 = it_1 -> it_1.getEnds();
            return IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)it.getAllContents(), Connector.class), (Functions.Function1)_function_19));
        };
        List connectorEnds = this.resourceManager.getList(_function_18);
        Function<Resource, List> _function_19 = it -> {
            Functions.Function1 _function_20 = it_1 -> it_1.getEnds();
            return IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)it.getAllContents(), Property.class), (Functions.Function1)_function_20));
        };
        connectorEnds.addAll(this.resourceManager.getList(_function_19));
        Functions.Function1 _function_20 = it -> ((Object[])Conversions.unwrapArray((Object)it, Object.class)).length;
        Integer nbConnectorEnds = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(connectorEnds, (Functions.Function1)_function_20));
        int nbPorts = ((Object[])Conversions.unwrapArray(UmlNavigation.getPorts(this.resourceManager), Object.class)).length;
        int nbParametersPerOperation = 0;
        List<Operation> operations = UmlNavigation.getOperations(this.resourceManager);
        int _size_1 = operations.size();
        boolean bl3 = _notEquals_1 = _size_1 != 0;
        if (_notEquals_1) {
            Functions.Function1 _function_21 = it -> ((Object[])Conversions.unwrapArray((Object)it.getOwnedParameters(), Object.class)).length;
            nbParametersPerOperation = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(operations, (Functions.Function1)_function_21));
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Types for the metamodel.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef ");
        String _intType = this.getIntType(nbOwnedAttributes, false);
        _builder.append(_intType);
        _builder.append(" NbOwnedAttributes_t;\t// Number of ownedAttributes per class");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_1 = this.getIntType(nbMaxLanguages, false);
        _builder.append(_intType_1);
        _builder.append(" NbLanguages_t;\t\t\t// Number of languages in OpaqueBehaviors or OpaqueExpressions");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_2 = this.getIntType(nbMaxBodies, false);
        _builder.append(_intType_2);
        _builder.append(" NbBodies_t;\t\t\t// Number of bodies in OpaqueBehaviors or OpaqueExpressions");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_3 = this.getIntType(nbPrimitiveAttributes, false);
        _builder.append(_intType_3);
        _builder.append(" NbPrimitiveTypeProperties_t;\t// Number of primitives type properties per class");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_4 = this.getIntType(nbMaxRegions, false);
        _builder.append(_intType_4);
        _builder.append(" NbRegions_t;\t\t\t// Number of regions per state machine");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_5 = this.getIntType(nbMaxTransitions, false);
        _builder.append(_intType_5);
        _builder.append(" NbTransitions_t;\t\t// Number of transitions per state machine");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_6 = this.getIntType(nbMaxTransitions, false);
        _builder.append(_intType_6);
        _builder.append(" NbOutgoingTransitions_t;\t\t// Number of outgoing transitions per state");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_7 = this.getIntType(nbMaxTriggers, false);
        _builder.append(_intType_7);
        _builder.append(" NbTriggers_t;\t\t\t// Number of triggers per transition");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_8 = this.getIntType(nbMaxStates, true);
        _builder.append(_intType_8);
        _builder.append(" NbStates_t;\t\t\t// Number of states per state machine (signed to handle errors with -1 as error code)");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_9 = this.getIntType(nbMaxEnumerationLiterals, false);
        _builder.append(_intType_9);
        _builder.append(" NbEnumerationLiteral_t; // Number of EnumerationLiterals in an Enumeration");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_10 = this.getIntType(nbSignalEvents + 1, false);
        _builder.append(_intType_10);
        _builder.append(" NbSignalEvents_t;\t\t// Number of signal events (+1 in order to reserve the maximum value for 'no signal event')");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_11 = this.getIntType(nbInterfaceRealizations, false);
        _builder.append(_intType_11);
        _builder.append(" NbInterfaceRealizations_t;\t\t\t// Number of interface realizations");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_12 = this.getIntType(nbReceptions, false);
        _builder.append(_intType_12);
        _builder.append(" NbReceptions_t;\t\t\t// Number of receptions per class or interface");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_13 = this.getIntType(nbConnectorEnds, false);
        _builder.append(_intType_13);
        _builder.append(" NbConnectorEnds_t;\t// Number of connector ends per connector or property");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_14 = this.getIntType(nbPorts + 1, false);
        _builder.append(_intType_14);
        _builder.append(" NbPorts_t;\t\t\t\t// Number of ports (+1 in order to reserve the maximum value for 'no port')");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_15 = this.getIntType(nbParametersPerOperation, false);
        _builder.append(_intType_15);
        _builder.append(" NbParametersPerOperation_t;\t\t\t\t// Number of parameters per operations");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String serializeInterpreterTypes() {
        String _xblockexpression = null;
        int nbActiveObjects = UmlNavigation.getActiveObjectsList(this.resourceManager).size();
        int nbPassiveObjects = UmlNavigation.getPassiveObjectsList(this.resourceManager).size();
        int nbObjects = nbActiveObjects + nbPassiveObjects;
        Function<Resource, Integer> _function = it -> {
            Functions.Function1 _function_1 = it_1 -> UmlNavigation.getPrimitiveAttributes(it_1).size();
            return this.sum(IteratorExtensions.map(emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)it.getAllContents(), Class.class), (Functions.Function1)_function_1));
        };
        int nbPrimitiveAttributes = this.sum(this.resourceManager.map(_function));
        this.getClass();
        this.getClass();
        this.getClass();
        this.getClass();
        int storeSize = nbActiveObjects * 4 + nbActiveObjects * 4 * 32 + nbPrimitiveAttributes * 4;
        Function<Resource, List> _function_1 = it -> IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), Region.class));
        List regions = this.resourceManager.getList(_function_1);
        Function<Resource, List> _function_2 = it -> IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), State.class));
        List states = this.resourceManager.getList(_function_2);
        Functions.Function1 _function_3 = it -> {
            Functions.Function1 _function_4 = it_1 -> {
                PseudostateKind _kind = it_1.getKind();
                return Objects.equal((Object)_kind, (Object)PseudostateKind.JUNCTION_LITERAL);
            };
            return ((Object[])Conversions.unwrapArray((Object)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)it.getSubvertices(), Pseudostate.class), (Functions.Function1)_function_4), Object.class)).length;
        };
        Integer nbJunctions = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(regions, (Functions.Function1)_function_3));
        List<ClassifierInstance> parts = UmlNavigation.collectClassifierInstance(this.resourceManager);
        PropertiesRO properties = new PropertiesRO(this.resourceManager);
        Functions.Function1 _function_4 = it -> {
            Classifier _classifier = it.getClassifier();
            return properties.getNbReadOnlyAttributes((Class)_classifier);
        };
        Integer nbProperties = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(parts, (Functions.Function1)_function_4));
        Functions.Function1 _function_5 = it -> Transitions.getMaxTransitionLength(UmlNavigation.getStateMachine(it));
        Integer fireablesLength = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(UmlNavigation.getActiveClasses(this.resourceManager), (Functions.Function1)_function_5));
        Functions.Function1 _function_6 = it -> Transitions.getMaxFireablesTransition(UmlNavigation.getStateMachine(it));
        Integer fireablesMax = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(UmlNavigation.getActiveClasses(this.resourceManager), (Functions.Function1)_function_6));
        Functions.Function1 _function_7 = it -> ((Object[])Conversions.unwrapArray((Object)it.getOutgoings(), Object.class)).length;
        Integer nbOutgoings = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(states, (Functions.Function1)_function_7));
        Functions.Function1 _function_8 = it -> it.getLower();
        Integer objectMultiplicity = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(parts, (Functions.Function1)_function_8));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Macros for the interpreter.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define MAX_FIREABLE_LENGTH\t\t(");
        _builder.append((Object)fireablesLength);
        _builder.append(")\t\t\t// Maximum number of transitions in a compound transition of the model.");
        _builder.newLineIfNotEmpty();
        _builder.append("#define MAX_OUTGOINGS\t\t\t(");
        _builder.append((Object)nbOutgoings);
        _builder.append(")\t\t\t// Maximum number of outgoings transitions of a vertex.");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Types for the interpreter.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef ");
        String _intType = this.getIntType(nbActiveObjects, true);
        _builder.append(_intType);
        _builder.append(" NbActiveObjects_t;\t\t// Number of active objects (signed because NO_OBJECT_ID takes value -1)");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_1 = this.getIntType(nbPassiveObjects, false);
        _builder.append(_intType_1);
        _builder.append(" NbPassiveObjects_t;\t\t// Number of passive objects");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_2 = this.getIntType(nbObjects, false);
        _builder.append(_intType_2);
        _builder.append(" NbObjects_t;\t\t// Number of objects");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef\t");
        String _intType_3 = this.getIntType(this.NB_EXECUTION_STEPS, false);
        _builder.append(_intType_3);
        _builder.append(" NbExecutionSteps_t;\t// Number of execution steps (limit)");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef\t");
        this.getClass();
        String _intType_4 = this.getIntType(65535, false);
        _builder.append(_intType_4);
        _builder.append(" NbFireablesSum_t;\t\t// Number of fireable transitions in a configuration");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef\t");
        String _intType_5 = this.getIntType(fireablesMax, true);
        _builder.append(_intType_5);
        _builder.append(" NbFireables_t;\t\t\t\t// Number of fireable transitions per active object (signed because NO_TRANSITION_ID, INITIAL_TRANSITION_ID, and IMPLICIT_TRANSITION_ID take negative values)");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef\t");
        String _intType_6 = this.getIntType(nbOutgoings, true);
        _builder.append(_intType_6);
        _builder.append(" NbOutgoings_t;\t\t\t// Number of outgoing transitions in the current state");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef\t");
        String _intType_7 = this.getIntType(fireablesLength, true);
        _builder.append(_intType_7);
        _builder.append(" FireablesLength_t;\t\t// Length of fireable transitions (i.e., maximum number of atomic transitions in a compound transition) (value -1 is used for the stack_index)");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_8 = this.getIntType(storeSize, false);
        _builder.append(_intType_8);
        _builder.append(" StoreSize_t;\t\t\t// Size of the store");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_9 = this.getIntType(nbJunctions, false);
        _builder.append(_intType_9);
        _builder.append(" NbJunctions_t; \t// Number of junction pseudostates per active object.");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_10 = this.getIntType(nbProperties, false);
        _builder.append(_intType_10);
        _builder.append(" NbPropertiesRO_t; \t// Number of read-only properties per object.");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_11 = this.getIntType(this.NB_FIFO_LAYERS, false);
        _builder.append(_intType_11);
        _builder.append(" NbFifoLayers_t; \t// Number of layers per fifo.");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        this.getClass();
        String _intType_12 = this.getIntType(32, false);
        _builder.append(_intType_12);
        _builder.append(" NbFifoElements_t; \t// Number of elements per fifo.");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_13 = this.getIntType(objectMultiplicity, false);
        _builder.append(_intType_13);
        _builder.append(" ObjectMultiplicity_t; \t// Multiplicity of a part.");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_14 = this.getIntType(this.MAX_PRIORITY_FP, false);
        _builder.append(_intType_14);
        _builder.append(" PriorityFP_t; \t// Type of the priority used with fixed priority scheduling policy.");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String serializeEventPoolTypes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Types for event pools.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef ");
        this.getClass();
        String _intType = this.getIntType(32, false);
        _builder.append(_intType);
        _builder.append(" NbEvents_t;\t\t\t// Number of events on event pool");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        this.getClass();
        String _intType_1 = this.getIntType(32, false);
        _builder.append(_intType_1);
        _builder.append(" EventSetSize_t;\t\t// Size of the event set (= Number of receptions)");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String serializeCheckerTypes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Types for the checker.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef ");
        String _intType = this.getIntType(this.NB_ATOMS, true);
        _builder.append(_intType);
        _builder.append(" NbAtoms_t;\t\t// Number of atoms that can be checked (signed to handle errors with -1 as error code)");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_1 = this.getIntType(this.ATOM_SIZE, false);
        _builder.append(_intType_1);
        _builder.append(" AtomSize_t;\t// Size of an atom");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String serializePilotTypes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Types for the pilot.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef ");
        String _intType = this.getIntType(this.NB_COMMANDS, false);
        _builder.append(_intType);
        _builder.append(" NbCommands_t;\t\t\t// Number of commands");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        this.getClass();
        String _intType_1 = this.getIntType(65535, false);
        _builder.append(_intType_1);
        _builder.append(" CommandSize_t;\t\t\t// Size of a command");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef MODELS_MODEL_TYPES_H");
        _builder.newLine();
        _builder.append("#define MODELS_MODEL_TYPES_H");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file types_calibration.h");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Define all data types according to the model size.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify manually.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include <stdint.h>");
        _builder.newLine();
        _builder.newLine();
        String _serializeMetamodelTypes = this.serializeMetamodelTypes();
        _builder.append(_serializeMetamodelTypes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeInterpreterTypes = this.serializeInterpreterTypes();
        _builder.append(_serializeInterpreterTypes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeEventPoolTypes = this.serializeEventPoolTypes();
        _builder.append(_serializeEventPoolTypes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeCheckerTypes = this.serializeCheckerTypes();
        _builder.append(_serializeCheckerTypes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializePilotTypes = this.serializePilotTypes();
        _builder.append(_serializePilotTypes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#endif /* MODELS_MODEL_TYPES_H */");
        _builder.newLine();
        return _builder.toString();
    }
}

