/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class Operations {
    private final Map<Class, List<Operation>> mappingOperations;

    public Operations(ResourceManager rm) {
        HashMap<Class, List<Operation>> _hashMap = new HashMap<Class, List<Operation>>();
        this.mappingOperations = _hashMap;
        Consumer<Class> _function = it -> {
            List<Operation> operations = Operations.getOperations(it);
            this.mappingOperations.put((Class)it, operations);
        };
        UmlNavigation.getClasses(rm).forEach(_function);
    }

    private String operationTypeToC(Operation e, Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("UML_Operation * ");
        String _name = e.getName();
        _builder.append(_name);
        _builder.append(";");
        return _builder.toString();
    }

    private String operationToC(Operation e, Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".");
        String _name = e.getName();
        _builder.append(_name);
        _builder.append(" = &");
        String _variableName = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append(_variableName);
        return _builder.toString();
    }

    public static List<Operation> getOperations(Class e) {
        ArrayList<Operation> _xblockexpression = null;
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Consumer<Class> _function = it -> Operations.getOwnedOperationsHelper(it, operations);
        UmlNavigation.getInheritanceTree((Classifier)e).forEach(_function);
        _xblockexpression = operations;
        return _xblockexpression;
    }

    private static List<Operation> getOwnedOperationsHelper(Class e, List<Operation> operations) {
        List<Operation> _xblockexpression = null;
        Consumer<Operation> _function = it -> {
            boolean _not;
            boolean _isEmpty = it.getMethods().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                boolean operationExist = false;
                int operationIndex = 0;
                for (int i = 0; i < ((Object[])Conversions.unwrapArray((Object)operations, Object.class)).length; ++i) {
                    boolean _equals = ((Operation)operations.get(i)).getName().equals(it.getName());
                    if (!_equals) continue;
                    operationExist = true;
                    operationIndex = i;
                }
                if (operationExist) {
                    operations.set(operationIndex, (Operation)it);
                } else {
                    operations.add((Operation)it);
                }
            }
        };
        e.getOwnedOperations().forEach(_function);
        _xblockexpression = operations;
        return _xblockexpression;
    }

    private String classOperationTypedefToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef struct ");
        String _name = e.getName();
        _builder.append(_name);
        _builder.append("_operations ");
        String _name_1 = e.getName();
        _builder.append(_name_1);
        _builder.append("_operations;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String classOperationTypeToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("struct ");
        String _name = e.getName();
        _builder.append(_name);
        _builder.append("_operations {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> this.operationTypeToC((Operation)it, e);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.mappingOperations.get(e), (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder.toString();
    }

    private String classOperationToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Operations type for the ");
        String _name = e.getName();
        _builder.append(_name, " ");
        _builder.append(" class.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        String _name_1 = e.getName();
        _builder.append(_name_1);
        _builder.append("_operations ");
        String _name_2 = e.getName();
        _builder.append(_name_2);
        _builder.append("_operations_vtable = {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> this.operationToC((Operation)it, e);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.mappingOperations.get(e), (Functions.Function1)_function), (CharSequence)",\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder.toString();
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Typedef for operations type.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.classOperationTypedefToC((Class)it.getKey());
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.mappingOperations.entrySet(), (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Structures initializer for operations.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.classOperationTypeToC((Class)it.getKey());
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.mappingOperations.entrySet(), (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Structures types for operations.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> {
            int _length = ((Object[])Conversions.unwrapArray(this.mappingOperations.get(it.getKey()), Object.class)).length;
            return _length != 0;
        };
        Functions.Function1 _function_1 = it -> this.classOperationToC((Class)it.getKey());
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.mappingOperations.entrySet(), (Functions.Function1)_function), (Functions.Function1)_function_1), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

