/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class EventPools {
    private final List<ClassifierInstance> activeObjectsMAIN;
    private final List<ClassifierInstance> activeObjectsOBS;

    public EventPools(ResourceManager rm) {
        this.activeObjectsMAIN = UmlNavigation.getActiveObjectsListOfComposite(rm, "Main");
        this.activeObjectsOBS = UmlNavigation.getActiveObjectsListOfComposite(rm, "Obs");
    }

    private String eventSetToC(Class e) {
        String _xblockexpression = null;
        List<Reception> receptions = UmlNavigation.getAllReceptions(e);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Event set of the class ");
        String _name = e.getName();
        _builder.append(_name, " ");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("UML_Signal * eventSet_");
        String _name_1 = e.getName();
        _builder.append(_name_1);
        _builder.append("[");
        int _length = ((Object[])Conversions.unwrapArray(receptions, Object.class)).length;
        _builder.append((Object)_length);
        _builder.append("] = {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> it.getSignal();
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("&");
            String _variableName = UmlSerializerExtensions.variableName((EObject)it);
            _builder_1.append(_variableName);
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)ListExtensions.map(receptions, (Functions.Function1)_function), (Functions.Function1)_function_1), (CharSequence)",\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String eventPoolDeclarationToC(ClassifierInstance activeObject) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("static EventPool eventPool_");
        String _instQualifiedName = activeObject.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        _builder.append(";");
        return _builder.toString();
    }

    private String eventPoolToC(ClassifierInstance activeObject) {
        return this.eventPoolCoreToC(activeObject);
    }

    private String eventPoolCoreToC(ClassifierInstance activeObject) {
        boolean _not_1;
        boolean _not;
        String _xblockexpression = null;
        Classifier _classifier = activeObject.getClassifier();
        Class class_ = (Class)_classifier;
        List<Reception> receptions = UmlNavigation.getAllReceptions(class_);
        String instQualifiedName = activeObject.getInstQualifiedName();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#if WITH_EVENT_META_DATA");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static void * data_");
        _builder.append(instQualifiedName, "\t");
        _builder.append("[3] = {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("store.");
        _builder.append(instQualifiedName, "\t\t");
        _builder.append(".ep.eventOccurred,");
        _builder.newLineIfNotEmpty();
        boolean _hasEventsParameters = UmlNavigation.hasEventsParameters(class_);
        if (_hasEventsParameters) {
            _builder.append("\t\t");
            _builder.append("store.");
            _builder.append(instQualifiedName, "\t\t");
            _builder.append(".ep_params.eventOccurred,");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t\t");
            _builder.append("NULL,");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("eventPool_");
        _builder.append(instQualifiedName, "\t\t");
        _builder.append(".meta.metaData");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static uint32_t element_size_");
        _builder.append(instQualifiedName, "\t");
        _builder.append("[3] = {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("sizeof(EventId), ");
        _builder.newLine();
        boolean _hasEventsParameters_1 = UmlNavigation.hasEventsParameters(class_);
        if (_hasEventsParameters_1) {
            _builder.append("\t\t");
            _builder.append("sizeof(");
            String _name = class_.getName();
            _builder.append(_name, "\t\t");
            _builder.append("_events),");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t\t");
            _builder.append("0,");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("sizeof(EventMetaData)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("#else");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static void * data_");
        _builder.append(instQualifiedName, "\t");
        _builder.append("[2] = {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#if EVENT_POOL_SIZE != 0");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("store.");
        _builder.append(instQualifiedName, "\t\t");
        _builder.append(".ep.eventOccurred,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#else");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("NULL,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#endif /* EVENT_POOL_SIZE != 0 */");
        _builder.newLine();
        boolean _hasEventsParameters_2 = UmlNavigation.hasEventsParameters(class_);
        if (_hasEventsParameters_2) {
            _builder.append("\t");
            _builder.append("#if EVENT_POOL_SIZE != 0");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("store.");
            _builder.append(instQualifiedName, "\t\t");
            _builder.append(".ep_params.eventOccurred,");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#else");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("NULL,");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#endif /* EVENT_POOL_SIZE != 0 */");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("NULL,");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static uint32_t element_size_");
        _builder.append(instQualifiedName, "\t");
        _builder.append("[2] = {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("sizeof(EventId),");
        _builder.newLine();
        boolean _hasEventsParameters_3 = UmlNavigation.hasEventsParameters(class_);
        if (_hasEventsParameters_3) {
            _builder.append("\t\t");
            _builder.append("sizeof(");
            String _name_1 = class_.getName();
            _builder.append(_name_1, "\t\t");
            _builder.append("_events),");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t\t");
            _builder.append("0");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("#endif /* WITH_EVENT_META_DATA */");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        StringConcatenation _xifexpression = null;
        boolean _isEmpty = UmlNavigation.getAllReceptions(class_).isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringConcatenation _xifexpression_1 = null;
            boolean _hasEventsParameters_4 = UmlNavigation.hasEventsParameters(class_);
            if (_hasEventsParameters_4) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("#if WITH_EVENT_META_DATA");
                _builder_1.newLine();
                _builder_1.append("static uint8_t reorganize_buffer_");
                _builder_1.append(instQualifiedName);
                _builder_1.append("[EVENT_POOL_SIZE * (sizeof(EventId) + sizeof(");
                String _name_2 = class_.getName();
                _builder_1.append(_name_2);
                _builder_1.append("_events) + sizeof(EventMetaData))];");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("#else");
                _builder_1.newLine();
                _builder_1.append("static uint8_t reorganize_buffer_");
                _builder_1.append(instQualifiedName);
                _builder_1.append("[EVENT_POOL_SIZE * (sizeof(EventId) + sizeof(");
                String _name_3 = class_.getName();
                _builder_1.append(_name_3);
                _builder_1.append("_events))];");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("#endif /* WITH_EVENT_META_DATA */");
                _builder_1.newLine();
                _xifexpression_1 = _builder_1;
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("#if WITH_EVENT_META_DATA");
                _builder_2.newLine();
                _builder_2.append("static uint8_t reorganize_buffer_");
                _builder_2.append(instQualifiedName);
                _builder_2.append("[EVENT_POOL_SIZE * (sizeof(EventId) + sizeof(EventMetaData))];");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("#else");
                _builder_2.newLine();
                _builder_2.append("static uint8_t reorganize_buffer_");
                _builder_2.append(instQualifiedName);
                _builder_2.append("[EVENT_POOL_SIZE * sizeof(EventId)];");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("#endif /* WITH_EVENT_META_DATA */");
                _builder_2.newLine();
                _xifexpression_1 = _builder_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _builder.append(_xifexpression);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("static EventPool eventPool_");
        _builder.append(instQualifiedName);
        _builder.append(" = {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("// Init the fifo");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".fifo.data = data_");
        _builder.append(instQualifiedName, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".fifo.element_size = element_size_");
        _builder.append(instQualifiedName, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("#if EVENT_POOL_SIZE != 0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".fifo.nb = &(store.");
        _builder.append(instQualifiedName, "\t");
        _builder.append(".ep.nbEvents),");
        _builder.newLineIfNotEmpty();
        _builder.append("#else");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".fifo.nb = NULL,");
        _builder.newLine();
        _builder.append("#endif /* EVENT_POOL_SIZE != 0 */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".fifo.size = EVENT_POOL_SIZE,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".fifo.writing = 0,");
        _builder.newLine();
        boolean _isEmpty_1 = UmlNavigation.getAllReceptions(class_).isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            _builder.append("\t");
            _builder.append(".fifo.reorganize_buffer = reorganize_buffer_");
            _builder.append(instQualifiedName, "\t");
            _builder.append(",");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            _builder.append(".fifo.reorganize_buffer = NULL,");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("#if WITH_EVENT_META_DATA");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".fifo.nb_layers = 3,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#else");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".fifo.nb_layers = 2,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#endif /* WITH_EVENT_META_DATA */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Init the meta part");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".meta.eventSetSize = ");
        int _length = ((Object[])Conversions.unwrapArray(receptions, Object.class)).length;
        _builder.append((Object)_length, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".meta.eventSet = eventSet_");
        String _name_4 = class_.getName();
        _builder.append(_name_4, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        boolean _hasEventsParameters_5 = UmlNavigation.hasEventsParameters(class_);
        if (_hasEventsParameters_5) {
            _builder.append("\t");
            _builder.append(".meta.paramsSize = sizeof(");
            String _name_5 = class_.getName();
            _builder.append(_name_5, "\t");
            _builder.append("_events),");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            _builder.append(".meta.paramsSize = 0,");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("#if DEBUG_EVENT");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".meta.nbMaxEvents = 0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#endif /* DEBUG_EVENT */");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String serializeHeadersTypedef() {
        return "";
    }

    public String serializeHeaders() {
        return "";
    }

    public String serialize() {
        String _xblockexpression = null;
        Functions.Function1 _function = it -> {
            Classifier _classifier = it.getClassifier();
            return (Class)_classifier;
        };
        Set activeClassifiersMAIN = IterableExtensions.toSet((Iterable)ListExtensions.map(this.activeObjectsMAIN, (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> {
            Classifier _classifier = it.getClassifier();
            return (Class)_classifier;
        };
        Set activeClassifiersOBS = IterableExtensions.toSet((Iterable)ListExtensions.map(this.activeObjectsOBS, (Functions.Function1)_function_1));
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function_2 = it -> this.eventSetToC((Class)it);
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)activeClassifiersMAIN, (Functions.Function1)_function_2), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        Functions.Function1 _function_3 = it -> this.eventSetToC((Class)it);
        String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)activeClassifiersOBS, (Functions.Function1)_function_3), (CharSequence)"\n");
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Event pools used for active objects to store received events.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append(" ");
        Functions.Function1 _function_4 = it -> this.eventPoolDeclarationToC((ClassifierInstance)it);
        String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjectsMAIN, (Functions.Function1)_function_4), (CharSequence)"\n");
        _builder.append(_join_2, " ");
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        Functions.Function1 _function_5 = it -> this.eventPoolDeclarationToC((ClassifierInstance)it);
        String _join_3 = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjectsOBS, (Functions.Function1)_function_5), (CharSequence)"\n");
        _builder.append(_join_3);
        _builder.newLineIfNotEmpty();
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function_6 = it -> this.eventPoolToC((ClassifierInstance)it);
        String _join_4 = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjectsMAIN, (Functions.Function1)_function_6), (CharSequence)"\n");
        _builder.append(_join_4);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        Functions.Function1 _function_7 = it -> this.eventPoolToC((ClassifierInstance)it);
        String _join_5 = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjectsOBS, (Functions.Function1)_function_7), (CharSequence)"\n");
        _builder.append(_join_5);
        _builder.newLineIfNotEmpty();
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }
}

