/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.identifiers;

import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ClassesID {
    private final List<Class> classes;

    public ClassesID(ResourceManager rm) {
        Function<Resource, List> _function = it -> IteratorExtensions.toList(emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)it.getAllContents(), Class.class));
        this.classes = rm.getList(_function);
    }

    private String toC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#define CLASS_");
        String _name = c.getName();
        _builder.append(_name);
        _builder.append("\t\t\t&");
        String _variableName = UmlSerializerExtensions.variableName((EObject)c);
        _builder.append(_variableName);
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The list of classes identifiers.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getName());
            return !_isNullOrEmpty;
        };
        Functions.Function1 _function_1 = it -> this.toC((Class)it);
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.classes, (Functions.Function1)_function), (Functions.Function1)_function_1), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

