/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.actionlanguage.C;

import com.google.common.collect.Iterators;
import emi.serializer.memoryobjects.OperationParameters;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ActionLanguageC {
    public static final String C_LANGUAGE_NAME = "C";
    private final List<OpaqueExpression> opaqueExpressions;
    private final List<OpaqueBehavior> opaqueBehaviors;
    private final List<Operation> operations;

    public ActionLanguageC(ResourceManager rm) {
        Function<Resource, List> _function = it -> IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), Transition.class));
        List transitions = rm.getList(_function);
        Function<Resource, List> _function_1 = it -> IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), State.class));
        List states = rm.getList(_function_1);
        Functions.Function1 _function_2 = it -> {
            Constraint _guard = it.getGuard();
            return _guard != null;
        };
        Functions.Function1 _function_3 = it -> {
            ValueSpecification _specification = it.getGuard().getSpecification();
            return _specification != null;
        };
        Functions.Function1 _function_4 = it -> {
            ValueSpecification _specification = it.getGuard().getSpecification();
            return (OpaqueExpression)_specification;
        };
        this.opaqueExpressions = ListExtensions.map((List)IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_2)), (Functions.Function1)_function_3)), (Functions.Function1)_function_4);
        ArrayList<OpaqueBehavior> _arrayList = new ArrayList<OpaqueBehavior>();
        this.opaqueBehaviors = _arrayList;
        Functions.Function1 _function_5 = it -> {
            Behavior _effect = it.getEffect();
            return _effect != null;
        };
        Functions.Function1 _function_6 = it -> {
            Behavior _effect = it.getEffect();
            return (OpaqueBehavior)_effect;
        };
        this.opaqueBehaviors.addAll(ListExtensions.map((List)IterableExtensions.toList((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_5)), (Functions.Function1)_function_6));
        Functions.Function1 _function_7 = it -> {
            Behavior _entry = it.getEntry();
            return _entry != null;
        };
        Functions.Function1 _function_8 = it -> {
            Behavior _entry = it.getEntry();
            return (OpaqueBehavior)_entry;
        };
        this.opaqueBehaviors.addAll(ListExtensions.map((List)IterableExtensions.toList((Iterable)IterableExtensions.filter(states, (Functions.Function1)_function_7)), (Functions.Function1)_function_8));
        Functions.Function1 _function_9 = it -> {
            Behavior _exit = it.getExit();
            return _exit != null;
        };
        Functions.Function1 _function_10 = it -> {
            Behavior _exit = it.getExit();
            return (OpaqueBehavior)_exit;
        };
        this.opaqueBehaviors.addAll(ListExtensions.map((List)IterableExtensions.toList((Iterable)IterableExtensions.filter(states, (Functions.Function1)_function_9)), (Functions.Function1)_function_10));
        Function<Resource, List> _function_11 = it -> IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), Operation.class));
        this.operations = rm.getList(_function_11);
    }

    private String getReturnTypeInC(Operation e) {
        String _xblockexpression = null;
        String returnType = "void";
        Parameter returnParameter = OperationParameters.getReturnParameter(e);
        if (returnParameter != null) {
            returnType = UmlSerializerExtensions.typeNameToC(returnParameter.getType());
        }
        _xblockexpression = returnType;
        return _xblockexpression;
    }

    private String prototypeToC(OpaqueBehavior e) {
        String _xblockexpression = null;
        Class class_ = this.getClassContainer((EObject)e);
        String parametersType = this.getParametersType(this.getSignalOfTrigger(e));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("static void c_function_");
        String _variableName = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append(_variableName);
        _builder.append("(");
        String _name = class_.getName();
        _builder.append(_name);
        _builder.append("_Object * this, ");
        _builder.append(parametersType);
        _builder.append(" params);");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String prototypeToC(OpaqueExpression e) {
        String _xblockexpression = null;
        Class class_ = this.getClassContainer((EObject)e);
        String parametersType = this.getParametersType(this.getSignalOfTrigger(e));
        int index = -1;
        try {
            index = ActionLanguageC.getIndexOfLanguageC((EList<String>)e.getLanguages());
        }
        catch (Throwable _t) {
            if (_t instanceof NoSuchElementException) {
                System.err.println("C language was not found for opaque expression " + e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        String _xifexpression = null;
        if (index != -1) {
            boolean _not;
            String _xblockexpression_1 = null;
            String body = (String)e.getBodies().get(index);
            String _xifexpression_1 = null;
            boolean _contentEquals = "else".contentEquals(body);
            boolean bl = _not = !_contentEquals;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("static bool c_function_");
                String _variableName = UmlSerializerExtensions.variableName((EObject)e);
                _builder.append(_variableName);
                _builder.append("(");
                String _name = class_.getName();
                _builder.append(_name);
                _builder.append("_Object * this, ");
                _builder.append(parametersType);
                _builder.append(" params);");
                _builder.newLineIfNotEmpty();
                _xifexpression_1 = _builder.toString();
            } else {
                _xifexpression_1 = "";
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String prototypeToC(Operation e) {
        String _xblockexpression = null;
        Class class_ = this.getClassContainer((EObject)e);
        String parametersType = OperationParameters.getOperationParametersStructName(e);
        Behavior _head = (Behavior)IterableExtensions.head((Iterable)e.getMethods());
        OpaqueBehavior ob = (OpaqueBehavior)_head;
        String returnType = this.getReturnTypeInC(e);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("static ");
        _builder.append(returnType);
        _builder.append(" c_function_");
        String _variableName = UmlSerializerExtensions.variableName((EObject)ob);
        _builder.append(_variableName);
        _builder.append("(");
        String _name = class_.getName();
        _builder.append(_name);
        _builder.append("_Object * this, ");
        _builder.append(parametersType);
        _builder.append(" * params);");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private Class getClassContainer(EObject e) {
        Class _xblockexpression = null;
        EObject classContainer = e;
        while (!classContainer.eClass().getName().equals("Class")) {
            classContainer = classContainer.eContainer();
        }
        _xblockexpression = (Class)classContainer;
        return _xblockexpression;
    }

    private Transition getTransitionContainer(EObject e) {
        EObject trContainer;
        Transition _xblockexpression = null;
        for (trContainer = e; trContainer != null && !(trContainer instanceof Transition); trContainer = trContainer.eContainer()) {
        }
        _xblockexpression = (Transition)trContainer;
        return _xblockexpression;
    }

    private Signal getSignalOfTrigger(OpaqueBehavior e) {
        Signal _xblockexpression = null;
        Signal signal = null;
        if (e.eContainer() != null && e.eContainer() instanceof Transition) {
            Trigger trigger;
            EObject _eContainer = e.eContainer();
            Transition transition = (Transition)_eContainer;
            while (transition != null && transition.getSource() instanceof Pseudostate) {
                boolean _equals;
                int _length = ((Object[])Conversions.unwrapArray((Object)transition.getSource().getIncomings(), Object.class)).length;
                boolean bl = _equals = _length == 1;
                if (_equals) {
                    transition = (Transition)IterableExtensions.head((Iterable)transition.getSource().getIncomings());
                    continue;
                }
                transition = null;
            }
            if (transition != null && (trigger = (Trigger)IterableExtensions.head((Iterable)transition.getTriggers())) != null) {
                Event _event = trigger.getEvent();
                signal = ((SignalEvent)_event).getSignal();
            }
        }
        _xblockexpression = signal;
        return _xblockexpression;
    }

    private Signal getSignalOfTrigger(OpaqueExpression e) {
        Signal _xblockexpression = null;
        Signal signal = null;
        Transition transition = null;
        EObject constraint = e.eContainer();
        if (constraint != null && constraint.eContainer() != null && constraint.eContainer() instanceof Transition) {
            Trigger trigger;
            EObject _eContainer = constraint.eContainer();
            transition = (Transition)_eContainer;
            Vertex source = transition.getSource();
            while (source instanceof Pseudostate) {
                transition = (Transition)IterableExtensions.head((Iterable)((Pseudostate)source).getIncomings());
                source = transition.getSource();
            }
            if (transition != null && (trigger = (Trigger)IterableExtensions.head((Iterable)transition.getTriggers())) != null) {
                Event _event = trigger.getEvent();
                signal = ((SignalEvent)_event).getSignal();
            }
        }
        _xblockexpression = signal;
        return _xblockexpression;
    }

    private String getParametersType(Signal signal) {
        String _xblockexpression = null;
        String parametersType = null;
        if (signal != null) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = signal.getName();
            _builder.append(_name);
            _builder.append("_signal_parameters *");
            parametersType = _builder.toString();
        } else {
            parametersType = "void *";
        }
        _xblockexpression = parametersType;
        return _xblockexpression;
    }

    public static int getIndexOfLanguageC(EList<String> languages) {
        int index = -1;
        for (int i = 0; i < languages.size() && index == -1; ++i) {
            boolean _equals = ((String)languages.get(i)).equals(C_LANGUAGE_NAME);
            if (!_equals) continue;
            index = i;
        }
        if (index == -1) {
            throw new NoSuchElementException("C language not found");
        }
        return index;
    }

    private String toC(OpaqueBehavior e) {
        String _xblockexpression = null;
        String parametersType = this.getParametersType(this.getSignalOfTrigger(e));
        int index = -1;
        try {
            index = ActionLanguageC.getIndexOfLanguageC((EList<String>)e.getLanguages());
        }
        catch (Throwable _t) {
            if (_t instanceof NoSuchElementException) {
                System.err.println("C language was not found for opaque expression " + e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        Class class_ = this.getClassContainer((EObject)e);
        Transition transition = this.getTransitionContainer((EObject)e);
        String _xifexpression = null;
        if (index != -1) {
            String _xblockexpression_1 = null;
            String body = ((String)e.getBodies().get(index)).replaceAll(";\\s+", ";\n");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Opaque behavior for the class ");
            String _name = class_.getName();
            _builder.append(_name, " ");
            _builder.append(".");
            _builder.newLineIfNotEmpty();
            StringConcatenation _xifexpression_1 = null;
            if (transition != null) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(" ");
                _builder_1.append("* Of transition \"");
                String _name_1 = transition.getName();
                _builder_1.append(_name_1, " ");
                _builder_1.append("\" from \"");
                String _name_2 = transition.getSource().getName();
                _builder_1.append(_name_2, " ");
                _builder_1.append("\" to \"");
                String _name_3 = transition.getTarget().getName();
                _builder_1.append(_name_3, " ");
                _builder_1.append("\".");
                _xifexpression_1 = _builder_1;
            }
            _builder.append(_xifexpression_1);
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("static void c_function_");
            String _variableName = UmlSerializerExtensions.variableName((EObject)e);
            _builder.append(_variableName);
            _builder.append("(");
            String _name_4 = class_.getName();
            _builder.append(_name_4);
            _builder.append("_Object * this, ");
            _builder.append(parametersType);
            _builder.append(" params) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(body, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _xifexpression = _xblockexpression_1 = _builder.toString();
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String toC(OpaqueExpression e) {
        String _xblockexpression = null;
        String parametersType = this.getParametersType(this.getSignalOfTrigger(e));
        int index = -1;
        try {
            index = ActionLanguageC.getIndexOfLanguageC((EList<String>)e.getLanguages());
        }
        catch (Throwable _t) {
            if (_t instanceof NoSuchElementException) {
                System.err.println("C language was not found for opaque expression " + e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        Class class_ = this.getClassContainer((EObject)e);
        Transition transition = this.getTransitionContainer((EObject)e);
        String _xifexpression = null;
        if (index != -1) {
            boolean _not;
            String _xblockexpression_1 = null;
            String body = (String)e.getBodies().get(index);
            String _xifexpression_1 = null;
            boolean _contentEquals = "else".contentEquals(body);
            boolean bl = _not = !_contentEquals;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("/*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Opaque expression for the class ");
                String _name = class_.getName();
                _builder.append(_name, " ");
                _builder.append(".");
                _builder.newLineIfNotEmpty();
                StringConcatenation _xifexpression_2 = null;
                if (transition != null) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append(" ");
                    _builder_1.append("* Of transition \"");
                    String _name_1 = transition.getName();
                    _builder_1.append(_name_1, " ");
                    _builder_1.append("\" from \"");
                    String _name_2 = transition.getSource().getName();
                    _builder_1.append(_name_2, " ");
                    _builder_1.append("\" to \"");
                    String _name_3 = transition.getTarget().getName();
                    _builder_1.append(_name_3, " ");
                    _builder_1.append("\".");
                    _xifexpression_2 = _builder_1;
                }
                _builder.append(_xifexpression_2);
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("static bool c_function_");
                String _variableName = UmlSerializerExtensions.variableName((EObject)e);
                _builder.append(_variableName);
                _builder.append("(");
                String _name_4 = class_.getName();
                _builder.append(_name_4);
                _builder.append("_Object * this, ");
                _builder.append(parametersType);
                _builder.append(" params) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("return (");
                _builder.append(body, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
                _xifexpression_1 = _builder.toString();
            } else {
                _xifexpression_1 = "";
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String toC(Operation e) {
        String _xblockexpression = null;
        Class class_ = this.getClassContainer((EObject)e);
        String parametersType = OperationParameters.getOperationParametersStructName(e);
        Behavior _head = (Behavior)IterableExtensions.head((Iterable)e.getMethods());
        OpaqueBehavior ob = (OpaqueBehavior)_head;
        int index = -1;
        try {
            index = ActionLanguageC.getIndexOfLanguageC((EList<String>)ob.getLanguages());
        }
        catch (Throwable _t) {
            if (_t instanceof NoSuchElementException) {
                System.err.println("C language was not found for opaque behavior " + ob);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        String returnType = this.getReturnTypeInC(e);
        String _xifexpression = null;
        if (index != -1) {
            String _xblockexpression_1 = null;
            String body = (String)ob.getBodies().get(index);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Opaque behavior for the operation ");
            String _name = e.getName();
            _builder.append(_name, " ");
            _builder.append(" of class ");
            String _name_1 = class_.getName();
            _builder.append(_name_1, " ");
            _builder.append(".");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("static ");
            _builder.append(returnType);
            _builder.append(" c_function_");
            String _variableName = UmlSerializerExtensions.variableName((EObject)ob);
            _builder.append(_variableName);
            _builder.append("(");
            String _name_2 = class_.getName();
            _builder.append(_name_2);
            _builder.append("_Object * this, ");
            _builder.append(parametersType);
            _builder.append(" * params) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(body, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _xifexpression = _xblockexpression_1 = _builder.toString();
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String serializeEffectsDeclarations() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.prototypeToC((OpaqueBehavior)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.opaqueBehaviors, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function_1 = it -> this.prototypeToC((Operation)it);
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(this.operations, (Functions.Function1)_function_1));
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeEffects() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.toC((OpaqueBehavior)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.opaqueBehaviors, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function_1 = it -> this.toC((Operation)it);
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(this.operations, (Functions.Function1)_function_1));
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeGuardsDeclarations() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.prototypeToC((OpaqueExpression)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.opaqueExpressions, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeGuards() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.toC((OpaqueExpression)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.opaqueExpressions, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

