/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.protocol;

import emi.analysis.model.EMIAtom;
import emi.analysis.server.atom.AtomsAndParams;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class EMIProtocolAtoms {
    public static final int SIZEOF_ATOMS_NUMBERS = 4;
    public static final int SIZEOF_ATOM_LENGTH = 4;
    public static final int SIZEOF_ATOM_BANK = 4;
    public static final int SIZEOF_ATOM_VALUATION = 4;
    public static final int SIZEOF_PARAMS_NUMBERS = 4;
    public static final int SIZEOF_PARAM_LENGTH = 4;

    private EMIProtocolAtoms() {
    }

    public static byte[] serialize(EMIAtom[] atoms, List<byte[]> params, int size) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        byteBuffer.putInt(atoms.length);
        for (int i = 0; i < atoms.length; ++i) {
            EMIProtocolAtoms.serialize(byteBuffer, atoms[i]);
        }
        if (params != null) {
            byteBuffer.putInt(params.size());
            for (byte[] param : params) {
                EMIProtocolAtoms.serializeParam(byteBuffer, param);
            }
        } else {
            byteBuffer.putInt(0);
        }
        return byteBuffer.array();
    }

    private static void serialize(ByteBuffer byteBuffer, EMIAtom atom) {
        byteBuffer.put(atom.getId());
        byteBuffer.put(atom.getPriority());
        byteBuffer.putInt(atom.length());
        byteBuffer.put(atom.getStringCode().getBytes());
    }

    private static void serializeParam(ByteBuffer byteBuffer, byte[] param) {
        byteBuffer.putInt(param.length);
        byteBuffer.put(param);
    }

    public static AtomsAndParams deserialize(byte[] data) {
        ArrayList<EMIAtom> atoms = new ArrayList<EMIAtom>();
        ArrayList<byte[]> params = new ArrayList<byte[]>();
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        int nbAtoms = byteBuffer.getInt();
        for (int i = 0; i < nbAtoms; ++i) {
            EMIAtom atom = EMIProtocolAtoms.deserializeAtom(byteBuffer);
            atoms.add(atom);
        }
        int nbParams = byteBuffer.getInt();
        for (int i = 0; i < nbParams; ++i) {
            byte[] param = EMIProtocolAtoms.deserializeParam(byteBuffer);
            params.add(param);
        }
        return new AtomsAndParams(atoms, params);
    }

    private static EMIAtom deserializeAtom(ByteBuffer byteBuffer) {
        byte[] id = new byte[16];
        byteBuffer.get(id, 0, 16);
        byte priority = byteBuffer.get();
        int length = byteBuffer.getInt();
        byte[] stringCode = new byte[length];
        byteBuffer.get(stringCode, 0, length);
        return new EMIAtom(id, new String(stringCode), priority);
    }

    private static byte[] deserializeParam(ByteBuffer byteBuffer) {
        int length = byteBuffer.getInt();
        byte[] param = new byte[length];
        byteBuffer.get(param, 0, length);
        return param;
    }

    public static byte[] serializeLoad(int bank, EMIAtom atom) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        byteBuffer.putInt(bank);
        byteBuffer.put(atom.getId());
        return byteBuffer.array();
    }

    public static byte[] serializeLoad(int bank, byte[] binaryCode) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + binaryCode.length);
        byteBuffer.putInt(bank);
        byteBuffer.put(binaryCode);
        return byteBuffer.array();
    }

    public static byte[] serializeAtomsToEvaluate(ArrayList<? extends AtomBankable> atomsToEvaluate, List<byte[]> params) {
        int sizeAtoms = 4 + atomsToEvaluate.size() * 4;
        int sizeParams = EMIProtocolAtoms.computeParametersSerializedSize(params);
        ByteBuffer byteBuffer = ByteBuffer.allocate(sizeAtoms + sizeParams);
        byteBuffer.putInt(atomsToEvaluate.size());
        for (AtomBankable atomBankable : atomsToEvaluate) {
            byteBuffer.putInt(atomBankable.getBank());
        }
        if (params != null) {
            byteBuffer.putInt(params.size());
            for (byte[] byArray : params) {
                EMIProtocolAtoms.serializeParam(byteBuffer, byArray);
            }
        } else {
            byteBuffer.putInt(0);
        }
        return byteBuffer.array();
    }

    public static int[] deserializeEvaluationResults(byte[] data) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        int nb = data.length / 4;
        int[] atomEvaluations = new int[nb];
        for (int i = 0; i < nb; ++i) {
            atomEvaluations[i] = byteBuffer.getInt();
        }
        return atomEvaluations;
    }

    public static int computeParametersSerializedSize(List<byte[]> params) {
        int size = 4;
        if (params != null) {
            for (byte[] param : params) {
                size += 4 + param.length;
            }
        }
        return size;
    }

    public static interface AtomBankable {
        public int getBank();
    }
}

