/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.analysis;

import announce4j.Announcer;
import emi.analysis.model.EMIFireableTransitionComposite;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import plug.core.ILanguagePlugin;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.core.RuntimeDescription;
import plug.core.execution.Execution;
import plug.events.FiredEvent;
import plug.events.PropertyEvent;
import plug.explorer.BFSExplorer;
import plug.explorer.buchi.nested_dfs.BA_GaiserSchwoon_Iterative;
import plug.explorer.buchi.nested_dfs.BA_GaiserSchwoon_Recursive;
import plug.language.buchi.runtime.BuchiRuntime;
import plug.language.buchikripke.runtime.KripkeBuchiProductSemantics;
import plug.language.emi.EMIPlugin;
import plug.language.emi.model.PlugRuntimeConfiguration;
import plug.language.emi.runtime.EMIRuntime;
import plug.statespace.IGraphAccess;
import plug.statespace.SimpleStateSpaceManager;
import plug.verifiers.deadlock.DeadlockVerifier;
import plug.verifiers.deadlock.FinalStateDetected;
import plug.visualisation.StateSpace2DOT;
import plug.visualisation.StateSpace2MTX;
import plug.visualisation.StateSpace2TGF;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.LTL.parser.Parser;
import properties.LTL.transformations.LTL2Buchi;
import properties.PropositionalLogic.PropositionalLogicModel.Declaration;
import properties.PropositionalLogic.PropositionalLogicModel.DeclarationBlock;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;

public class EMIVerifier {
    private static final int DISPLAY_PROGRESS_PERIOD = 60000;
    private ILanguagePlugin<EMIRuntime> module = new EMIPlugin();
    private EMIRuntime runtime;

    public EMIVerifier(EMIRuntime runtime) {
        this.runtime = runtime;
    }

    public BuchiDeclaration getBuchiDeclaration(String ltlFormula) {
        DeclarationBlock propertiesBlock = Parser.parseBlock((String)ltlFormula);
        Declaration prop = (Declaration)propertiesBlock.getDeclarations().iterator().next();
        if (prop instanceof BuchiDeclaration) {
            return (BuchiDeclaration)prop;
        }
        Expression property = ((ExpressionDeclaration)prop).getExpression();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        LTL2Buchi convertor = new LTL2Buchi(writer);
        BuchiDeclaration decl = convertor.convert(property);
        return decl;
    }

    public boolean verifyProperty(String ltl, boolean recursive) throws Exception {
        BuchiDeclaration buchiAutomaton = this.getBuchiDeclaration(ltl);
        BuchiRuntime buchiRuntime = new BuchiRuntime(buchiAutomaton);
        RuntimeDescription kripke = new RuntimeDescription(this.module, () -> this.runtime);
        KripkeBuchiProductSemantics kbProductSemantics = new KripkeBuchiProductSemantics(kripke, buchiRuntime);
        BA_GaiserSchwoon_Recursive verifier = null;
        if (recursive) {
            verifier = new BA_GaiserSchwoon_Recursive((ITransitionRelation)kbProductSemantics);
        } else {
            SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
            verifier = new BA_GaiserSchwoon_Iterative((ITransitionRelation)kbProductSemantics, (IStateSpaceManager)stateSpaceManager);
        }
        AtomicBoolean result = new AtomicBoolean(true);
        verifier.getAnnouncer().when(PropertyEvent.class, (announcer, event) -> result.compareAndSet(!event.isVerified(), false));
        System.out.println("Launch verification of property: \"" + ltl + "\"");
        long timeStart = System.currentTimeMillis();
        verifier.execute();
        long timeEnd = System.currentTimeMillis();
        System.out.println("Property is " + (result.get() ? "verified" : "violated"));
        System.out.println("Duration = " + (timeEnd - timeStart) + "ms\n");
        return result.get();
    }

    public void verifyFile(String filename, boolean recursive) throws Exception {
        File file = new File(filename);
        InputStreamReader streamReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(streamReader);
        String readLine = null;
        int nbProperties = 0;
        int nbPropertiesVerified = 0;
        try {
            while ((readLine = reader.readLine()) != null) {
                if ("".contentEquals(readLine)) continue;
                ++nbProperties;
                if (!this.verifyProperty(readLine, recursive)) continue;
                ++nbPropertiesVerified;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            reader.close();
        }
        System.out.println("Verification result : " + nbPropertiesVerified + "/" + nbProperties + " properties verified\n");
    }

    public void verifyViaBuchiAutomaton(EMIPlugin languagePlugin, String filename, boolean showProgress) {
        File file = new File(filename);
        Path modelPath = file.toPath();
        if (modelPath == null || !file.exists()) {
            System.err.println("Model path is incorrect or does not exist");
            return;
        }
        Execution.TransitionStorageType transitionStorageType = Execution.TransitionStorageType.PARENT;
        Execution execution = new Execution("Buch\u00ef Automaton in EMI", modelPath, (ILanguagePlugin)languagePlugin, BA_GaiserSchwoon_Iterative::new, transitionStorageType, Collections.emptySet());
        System.out.println("Launch verification of properties encoded as UML observer automata");
        execution.initialize();
        Thread runnerThread = execution.run();
        boolean stopped = false;
        if (showProgress) {
            while (runnerThread.isAlive()) {
                try {
                    long confs = execution.configurationCount();
                    System.out.print(confs + " configurations [" + confs / Math.max(execution.getElapsedTime() / 1000L, 1L) + " confs/sec]\r");
                    Thread.sleep(500L);
                }
                catch (InterruptedException confs) {}
            }
        }
        try {
            runnerThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Model loaded in " + execution.getLoadingTime() + " ms\n\"" + execution.getName() + "\" Analysis " + (stopped ? Execution.CompletenessStatus.INCOMPLETE : execution.resultStatus()) + " " + execution.configurationCount() + " states " + execution.transitionCount() + " transitions in " + execution.getElapsedTime() + " ms\n" + execution.verificationStatus());
    }

    public void detectDeadlocks() {
        SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
        BFSExplorer explorer = new BFSExplorer((ITransitionRelation)this.runtime, (IStateSpaceManager)stateSpaceManager);
        long startTime = System.currentTimeMillis();
        AtomicInteger counterTime = new AtomicInteger(0);
        explorer.getAnnouncer().when(FiredEvent.class, (arg_0, arg_1) -> this.lambda$detectDeadlocks$2((IStateSpaceManager)stateSpaceManager, startTime, counterTime, arg_0, arg_1));
        DeadlockVerifier deadlockVerifier = new DeadlockVerifier(explorer.getAnnouncer());
        AtomicBoolean deadLockFree = new AtomicBoolean(true);
        AtomicInteger nbDeadlocks = new AtomicInteger(0);
        deadlockVerifier.announcer.when(FinalStateDetected.class, (ann, ev) -> {
            deadLockFree.set(false);
            nbDeadlocks.incrementAndGet();
        });
        System.out.println("Launch deadlock detection.");
        long timeStart = System.currentTimeMillis();
        explorer.execute();
        long timeEnd = System.currentTimeMillis();
        System.out.println("Detection result: " + nbDeadlocks.get() + " deadlocks detected");
        System.out.println("Duration = " + (timeEnd - timeStart) + "ms\n");
    }

    public void exploreStateSpace(boolean deadlockDetection, boolean exportStateSpace) {
        SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
        stateSpaceManager.fullConfigurationStorage();
        stateSpaceManager.fullTransitionStorage();
        BFSExplorer explorer = new BFSExplorer((ITransitionRelation)this.runtime, (IStateSpaceManager)stateSpaceManager);
        long startTime = System.currentTimeMillis();
        AtomicInteger counterTime = new AtomicInteger(0);
        explorer.getAnnouncer().when(FiredEvent.class, (arg_0, arg_1) -> this.lambda$exploreStateSpace$4((IStateSpaceManager)stateSpaceManager, startTime, counterTime, arg_0, arg_1));
        AtomicBoolean deadLockFree = new AtomicBoolean(true);
        AtomicInteger nbDeadlocks = new AtomicInteger(0);
        DeadlockVerifier deadlockVerifier = new DeadlockVerifier(explorer.getAnnouncer());
        if (deadlockDetection) {
            deadlockVerifier.announcer.when(FinalStateDetected.class, (ann, ev) -> {
                deadLockFree.set(false);
                nbDeadlocks.incrementAndGet();
            });
        }
        System.out.println("Launch state-space exploration");
        long timeStart = System.currentTimeMillis();
        explorer.execute();
        long timeEnd = System.currentTimeMillis();
        System.out.println("Exploration result : " + stateSpaceManager.size() + " configurations and " + stateSpaceManager.transitionCount() + " transitions");
        System.out.println("Exploration duration = " + (timeEnd - timeStart) + "ms");
        System.gc();
        Runtime rt = Runtime.getRuntime();
        long usedMB = (rt.totalMemory() - rt.freeMemory()) / 1024L / 1024L;
        System.out.println("Exploration memory = " + usedMB + " MB");
        if (deadlockDetection) {
            System.out.println("Detection result: " + nbDeadlocks.get() + " deadlocks detected.");
        }
        if (exportStateSpace) {
            this.exportStateSpaceGraph("state_space", (IStateSpaceManager<PlugRuntimeConfiguration, EMIFireableTransitionComposite>)stateSpaceManager);
        }
    }

    public void exportStateSpaceGraph(String name, IStateSpaceManager<PlugRuntimeConfiguration, EMIFireableTransitionComposite> stateSpaceManager) {
        System.out.println("Print files used for state-space visualization");
        StateSpace2TGF.toTGF((IGraphAccess)stateSpaceManager.getGraphView(), (boolean)true, (String)(name + ".tgf"));
        StateSpace2MTX.toMTX((IGraphAccess)stateSpaceManager.getGraphView(), (String)(name + ".mtx"));
        StateSpace2DOT.toDOT((IGraphAccess)stateSpaceManager.getGraphView(), (boolean)true, (String)(name + ".gv"));
    }

    public void displayStateSpaceExplorationProgress(IStateSpaceManager<PlugRuntimeConfiguration, EMIFireableTransitionComposite> stateSpaceManager, long startTime, AtomicInteger counterTime, long period) {
        if (System.currentTimeMillis() - startTime > period * (long)counterTime.get()) {
            int counter = counterTime.get();
            Runtime rt = Runtime.getRuntime();
            long usedMB = (rt.totalMemory() - rt.freeMemory()) / 1024L / 1024L;
            System.out.println("[t=" + (long)counter * period + "ms][" + usedMB + "MB] nb configurations: " + stateSpaceManager.size() + "\tnb transitions:" + stateSpaceManager.transitionCount());
            counterTime.incrementAndGet();
        }
    }

    private /* synthetic */ void lambda$exploreStateSpace$4(IStateSpaceManager stateSpaceManager, long startTime, AtomicInteger counterTime, Announcer ann, FiredEvent ev) {
        this.displayStateSpaceExplorationProgress((IStateSpaceManager<PlugRuntimeConfiguration, EMIFireableTransitionComposite>)stateSpaceManager, startTime, counterTime, 60000L);
    }

    private /* synthetic */ void lambda$detectDeadlocks$2(IStateSpaceManager stateSpaceManager, long startTime, AtomicInteger counterTime, Announcer ann, FiredEvent ev) {
        this.displayStateSpaceExplorationProgress((IStateSpaceManager<PlugRuntimeConfiguration, EMIFireableTransitionComposite>)stateSpaceManager, startTime, counterTime, 60000L);
    }
}

