/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server;

import emi.analysis.com.IConnection;
import emi.analysis.protocol.EMIProtocol;
import emi.analysis.server.ServiceEvaluateAtoms;
import emi.analysis.server.ServiceTranslateConfiguration;
import emi.analysis.server.ServiceTranslateFireableTransition;
import emi.analysis.server.atom.AtomManager;
import emi.analysis.server.com.Forwarder;
import emi.analysis.server.com.TCPServer;
import emi.analysis.server.interpreter.ProxyInterpreter;
import emi.analysis.server.log.Log;
import emi.analysis.server.translator.Translator;
import java.io.IOException;
import java.util.HashMap;

public class EMIServer
extends TCPServer {
    private boolean logServices;
    private ProxyInterpreter interpreter;
    private ServiceEvaluateAtoms serviceEvaluateAtoms;
    private ServiceTranslateConfiguration serviceTranslateConfiguration;
    private ServiceTranslateFireableTransition serviceTranslateFireableTransition;
    private final HashMap<Byte, AService> services = new HashMap();

    public boolean hasLogServices() {
        return this.logServices;
    }

    public EMIServer(int port, ProxyInterpreter interpreter, AtomManager atomManager, Translator translator, boolean logServices) {
        super(port);
        this.logServices = logServices;
        this.interpreter = interpreter;
        interpreter.recordServer(this);
        this.serviceEvaluateAtoms = new ServiceEvaluateAtoms(atomManager, this.logServices);
        this.services.put((byte)15, this.serviceEvaluateAtoms);
        this.serviceTranslateConfiguration = new ServiceTranslateConfiguration(translator, this.logServices);
        this.services.put((byte)101, this.serviceTranslateConfiguration);
        this.serviceTranslateFireableTransition = new ServiceTranslateFireableTransition(translator, this.logServices);
        this.services.put((byte)102, this.serviceTranslateFireableTransition);
    }

    public boolean run() throws IOException {
        this.accept();
        Log.i("EMI Server accept the client");
        this.dispatch();
        Log.i("EMI Server lost the client");
        return true;
    }

    @Override
    protected void accept() throws IOException {
        try {
            super.accept();
        }
        catch (IOException e) {
            throw new IOException("Server exception: can't accept a client (" + e.getMessage() + ")");
        }
    }

    public void dispatch() {
        boolean connected = true;
        while (connected) {
            try {
                EMIProtocol.Header header = EMIProtocol.readHeader(this.getClientConnection());
                AService service = this.services.get(header.kind);
                if (service != null) {
                    service.execute(header, this.getClientConnection());
                    continue;
                }
                if (this.logServices) {
                    Log.d("EMI Client forwarding: kind = " + header.kind + ", size = " + header.size);
                }
                Forwarder.forward(this.getClientConnection(), this.interpreter.getConnection(), header);
            }
            catch (IOException e) {
                connected = false;
                Log.i("EMI Server dispatch stop: " + e.getMessage());
            }
        }
    }

    public void onInterpreterDisconnect() {
        try {
            if (this.getClientConnection() != null) {
                EMIProtocol.writeHeader(this.getClientConnection(), new EMIProtocol.Header(1));
            }
        }
        catch (IOException e) {
            Log.e("EMI Server exception: can't send error message to analysis client.");
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        Log.i("EMI Server close connection");
        this.interpreter.removeServer(this);
        try {
            super.close();
        }
        catch (IOException e) {
            Log.e("EMI Server exception: " + e.getMessage());
        }
    }

    public static abstract class AService {
        protected boolean log;

        public AService(boolean log) {
            this.log = log;
        }

        public abstract void execute(EMIProtocol.Header var1, IConnection var2) throws IOException;
    }
}

