/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.symbols;

import com.google.common.collect.Iterators;
import emi.serializer.memoryobjects.PropertiesRO;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.ResourceManager;
import emi.serializer.symbols.SymbolClass;
import emi.serializer.utils.UmlNavigation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SymbolTable {
    private final List<String> flatActiveObjectsName;
    private final Map<String, SymbolClass> symbolClasses;
    private final Map<String, String> flatMappingObjectsClasses;
    private final Map<String, SignalEvent> symbolEvents;

    public SymbolTable(ResourceManager rm) {
        this.flatActiveObjectsName = this.generateFlatActiveObjectsName(rm);
        this.symbolClasses = this.generateSymbolClasses(rm);
        this.flatMappingObjectsClasses = this.generateFlatMappingWithObjects(rm);
        this.symbolEvents = this.generateSymbolEvents(rm);
    }

    private List<String> generateFlatActiveObjectsName(ResourceManager rm) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> objetsSymbols = new ArrayList<String>();
        List<ClassifierInstance> objects = UmlNavigation.getActiveObjectsList(rm);
        Consumer<ClassifierInstance> _function = it -> objetsSymbols.add(it.getInstQualifiedName());
        objects.forEach(_function);
        _xblockexpression = objetsSymbols;
        return _xblockexpression;
    }

    private Map<String, SymbolClass> generateSymbolClasses(ResourceManager rm) {
        HashMap<String, SymbolClass> _xblockexpression = null;
        HashMap<String, SymbolClass> symbolClasses = new HashMap<String, SymbolClass>();
        PropertiesRO propertiesRO = new PropertiesRO(rm);
        Consumer<Resource> _function = it -> {
            Functions.Function1 _function_1 = it_1 -> {
                boolean _equals = it_1.getName().equals("Main");
                return !_equals;
            };
            Procedures.Procedure1 _function_2 = it_1 -> {
                String _name = it_1.getName();
                SymbolClass _symbolClass = new SymbolClass((Class)it_1, rm, propertiesRO);
                symbolClasses.put(_name, _symbolClass);
            };
            IteratorExtensions.forEach((Iterator)IteratorExtensions.filter(emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)it.getAllContents(), Class.class), (Functions.Function1)_function_1), (Procedures.Procedure1)_function_2);
        };
        rm.forEach(_function);
        _xblockexpression = symbolClasses;
        return _xblockexpression;
    }

    private Map<String, String> generateFlatMappingWithObjects(ResourceManager rm) {
        HashMap<String, String> _xblockexpression = null;
        HashMap<String, String> objetsSymbols = new HashMap<String, String>();
        List<ClassifierInstance> objects = UmlNavigation.collectClassifierInstance(rm);
        Consumer<ClassifierInstance> _function = it -> objetsSymbols.put(it.getInstQualifiedName(), it.getClassifier().getName());
        objects.forEach(_function);
        _xblockexpression = objetsSymbols;
        return _xblockexpression;
    }

    private Map<String, SignalEvent> generateSymbolEvents(ResourceManager rm) {
        HashMap<String, SignalEvent> _xblockexpression = null;
        HashMap<String, SignalEvent> symbolEvents = new HashMap<String, SignalEvent>();
        Consumer<Resource> _function = it -> {
            Procedures.Procedure1 _function_1 = it_1 -> symbolEvents.put(it_1.getSignal().getName(), (SignalEvent)it_1);
            IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)it.getAllContents(), SignalEvent.class), (Procedures.Procedure1)_function_1);
        };
        rm.forEach(_function);
        _xblockexpression = symbolEvents;
        return _xblockexpression;
    }

    public List<String> getFlatActiveObjectsName() {
        return this.flatActiveObjectsName;
    }

    public Map<String, SymbolClass> getSymbolClasses() {
        return this.symbolClasses;
    }

    public Map<String, String> getFlatMapping() {
        return this.flatMappingObjectsClasses;
    }

    public Map<String, SignalEvent> getSymbolEvents() {
        return this.symbolEvents;
    }
}

