/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.symbols;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import emi.serializer.model.ModelLoader;
import emi.serializer.model.ResourceManager;
import emi.serializer.symbols.SymbolClass;
import emi.serializer.symbols.SymbolTable;
import emi.serializer.utils.UmlNavigation;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class SymbolMatcher {
    private final ModelLoader modelLoader;
    private final ResourceManager resourceManager;
    private final SymbolTable symbolTable;
    private final Map<Class<?>, Map<String, ?>> searchCache = new HashMap();
    private List<SignalEvent> signalEventsCache = null;
    private final Map<String, Enumeration> enumCache = new HashMap<String, Enumeration>();

    public SymbolMatcher(String emiModel) {
        SymbolTable _symbolTable;
        ResourceManager _resourceManager;
        ModelLoader _modelLoader;
        File directory = new File(emiModel + "/uml/");
        Functions.Function1 _function = it -> it.endsWith(".uml");
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            String _absolutePath = directory.getAbsolutePath();
            _builder.append(_absolutePath);
            _builder.append("/");
            _builder.append(it);
            return new String(_builder.toString());
        };
        List umlFiles = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)directory.list())), (Functions.Function1)_function), (Functions.Function1)_function_1));
        this.modelLoader = _modelLoader = new ModelLoader();
        Functions.Function1 _function_2 = it -> this.modelLoader.load((String)it);
        List resources = ListExtensions.map((List)umlFiles, (Functions.Function1)_function_2);
        this.resourceManager = _resourceManager = new ResourceManager(resources);
        this.symbolTable = _symbolTable = new SymbolTable(this.resourceManager);
    }

    public String searchActiveObject(int aoId) {
        return this.symbolTable.getFlatActiveObjectsName().get(aoId);
    }

    public <T extends NamedElement> T search(Class<T> type, String name) {
        NamedElement _xblockexpression = null;
        Map _elvis = null;
        Map _get = this.searchCache.get(type);
        if (_get != null) {
            _elvis = _get;
        } else {
            Map _xblockexpression_1 = null;
            Function<Resource, List> _function = it -> IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), (Class)type));
            Functions.Function1 _function_1 = it -> it.getName();
            Map c = IterableExtensions.toMap((Iterable)Iterables.concat(this.resourceManager.map(_function)), (Functions.Function1)_function_1);
            this.searchCache.put(type, c);
            _elvis = _xblockexpression_1 = c;
        }
        Map typeSpecificCache = _elvis;
        Object _get_1 = typeSpecificCache.get(name);
        _xblockexpression = (NamedElement)_get_1;
        return (T)_xblockexpression;
    }

    public Vertex searchState(String ao, int stateId) {
        Vertex _xblockexpression = null;
        String class_ = this.symbolTable.getFlatMapping().get(ao);
        SymbolClass symbolClass = this.symbolTable.getSymbolClasses().get(class_);
        _xblockexpression = symbolClass.getVertices().get(stateId);
        return _xblockexpression;
    }

    public String searchStateName(String ao, int stateId) {
        return this.searchState(ao, stateId).getName();
    }

    public Transition searchTransition(String ao, int stateId, int transitionId) {
        Transition _xblockexpression = null;
        String class_ = this.symbolTable.getFlatMapping().get(ao);
        SymbolClass symbolClass = this.symbolTable.getSymbolClasses().get(class_);
        _xblockexpression = (Transition)symbolClass.getVertices().get(stateId).getOutgoings().get(transitionId);
        return _xblockexpression;
    }

    public TransitionInfo searchTransitionInfo(String ao, int stateId, int transitionId) {
        TransitionInfo _xblockexpression = null;
        Transition tr = this.searchTransition(ao, stateId, transitionId);
        String class_ = this.symbolTable.getFlatMapping().get(ao);
        SymbolClass symbolClass = this.symbolTable.getSymbolClasses().get(class_);
        int targetId = symbolClass.getVertices().indexOf(tr.getTarget());
        String _name = tr.getName();
        String _name_1 = tr.getSource().getName();
        String _name_2 = tr.getTarget().getName();
        _xblockexpression = new TransitionInfo(_name, _name_1, _name_2, targetId);
        return _xblockexpression;
    }

    public SignalEvent searchSignalEvent(int signalEventId) {
        SignalEvent _xblockexpression = null;
        if (this.signalEventsCache == null) {
            this.signalEventsCache = UmlNavigation.getSignalEvents(this.resourceManager);
        }
        _xblockexpression = this.signalEventsCache.get(signalEventId);
        return _xblockexpression;
    }

    public String searchSignalEventName(int signalEventId) {
        return this.searchSignalEvent(signalEventId).getName();
    }

    public Port searchPort(int portId) {
        return UmlNavigation.getPorts(this.resourceManager).get(portId);
    }

    public String searchPortName(int portId) {
        return this.searchPort(portId).getName();
    }

    public String searchEnumerationLiteralName(String enumName, int value) throws IndexOutOfBoundsException {
        boolean _greaterEqualsThan;
        String _xblockexpression = null;
        EList literals = this.searchEnumeration(enumName).getOwnedLiterals();
        int _size = literals.size();
        boolean bl = _greaterEqualsThan = value >= _size;
        if (_greaterEqualsThan) {
            throw new IndexOutOfBoundsException();
        }
        _xblockexpression = ((EnumerationLiteral)literals.get(value)).getName();
        return _xblockexpression;
    }

    public Enumeration searchEnumeration(String enumName) {
        Enumeration _xblockexpression = null;
        Enumeration enum_ = this.enumCache.get(enumName);
        if (enum_ == null) {
            Functions.Function1 _function = it -> enumName.startsWith(it.getName());
            enum_ = (Enumeration)IterableExtensions.head((Iterable)IterableExtensions.filter(UmlNavigation.getEnumerations(this.resourceManager), (Functions.Function1)_function));
            this.enumCache.put(enumName, enum_);
        }
        _xblockexpression = enum_;
        return _xblockexpression;
    }

    @Data
    public static class TransitionInfo {
        private final String name;
        private final String sourceName;
        private final String targetName;
        private final int targetId;

        public TransitionInfo(String name, String sourceName, String targetName, int targetId) {
            this.name = name;
            this.sourceName = sourceName;
            this.targetName = targetName;
            this.targetId = targetId;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.sourceName == null ? 0 : this.sourceName.hashCode());
            result = 31 * result + (this.targetName == null ? 0 : this.targetName.hashCode());
            return 31 * result + this.targetId;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TransitionInfo other = (TransitionInfo)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.sourceName == null ? other.sourceName != null : !this.sourceName.equals(other.sourceName)) {
                return false;
            }
            if (this.targetName == null ? other.targetName != null : !this.targetName.equals(other.targetName)) {
                return false;
            }
            return other.targetId == this.targetId;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("name", (Object)this.name);
            b.add("sourceName", (Object)this.sourceName);
            b.add("targetName", (Object)this.targetName);
            b.add("targetId", (Object)this.targetId);
            return b.toString();
        }

        @Pure
        public String getName() {
            return this.name;
        }

        @Pure
        public String getSourceName() {
            return this.sourceName;
        }

        @Pure
        public String getTargetName() {
            return this.targetName;
        }

        @Pure
        public int getTargetId() {
            return this.targetId;
        }
    }
}

