/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import emi.serializer.memoryobjects.Objects;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.PartMultiplicity;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PropertiesRO {
    private final List<ClassifierInstance> objects;
    private final List<ClassifierInstance> objectsMAIN;
    private final List<ClassifierInstance> objectsOBS;
    private final Set<Class> classes;
    private final Set<Class> superclasses;
    private final List<Association> associations;
    private final Map<ClassifierInstance, Map<Property, List<ClassifierInstance>>> mapping;

    public PropertiesRO(ResourceManager rm) {
        this.objects = IterableExtensions.toList(UmlNavigation.collectClassifierInstance(rm));
        this.objectsMAIN = UmlNavigation.collectClassifierInstanceWithCompositeClass(rm, "Main");
        this.objectsOBS = UmlNavigation.collectClassifierInstanceWithCompositeClass(rm, "Obs");
        Function<Resource, List> _function = it -> IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), Association.class));
        this.associations = rm.getList(_function);
        Functions.Function1 _function_1 = it -> it.allParents();
        this.superclasses = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map(UmlNavigation.getClasses(rm), (Functions.Function1)_function_1)), Class.class));
        HashSet<Class> _hashSet = new HashSet<Class>();
        this.classes = _hashSet;
        this.classes.addAll(this.superclasses);
        this.classes.addAll(UmlNavigation.getClasses(rm));
        IterableExtensions.toSet(this.classes);
        HashMap<ClassifierInstance, Map<Property, List<ClassifierInstance>>> _hashMap = new HashMap<ClassifierInstance, Map<Property, List<ClassifierInstance>>>();
        this.mapping = _hashMap;
        for (ClassifierInstance o : this.objects) {
            HashMap _hashMap_1 = new HashMap();
            this.mapping.put(o, _hashMap_1);
        }
        Class mainClass = UmlNavigation.getCompositeClass(rm, "Main");
        Class obsClass = UmlNavigation.getCompositeClass(rm, "Obs");
        this.collectPropertiesOfCompositeClass(this.mapping, mainClass, UmlNavigation.getCompositeInstance(rm, (Classifier)mainClass));
        this.collectPropertiesOfCompositeClass(this.mapping, obsClass, UmlNavigation.getCompositeInstance(rm, (Classifier)obsClass));
        InputOutput.println((Object)"PropertiesRO mapping:");
        Consumer<Map.Entry> _function_2 = it -> {
            InputOutput.println((Object)((ClassifierInstance)it.getKey()).getInstQualifiedName());
            Consumer<Map.Entry> _function_3 = it_1 -> {
                String _name = ((Property)it_1.getKey()).getName();
                String _plus = "\t" + _name;
                String _plus_1 = _plus + "= ";
                Functions.Function1 _function_4 = it_2 -> it_2.getInstQualifiedName();
                String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)it_1.getValue()), (Functions.Function1)_function_4), (CharSequence)", ");
                String _plus_2 = _plus_1 + _join;
                InputOutput.println((Object)_plus_2);
            };
            ((Map)it.getValue()).entrySet().forEach(_function_3);
        };
        this.mapping.entrySet().forEach(_function_2);
        InputOutput.println((Object)"");
    }

    public void collectPropertiesOfCompositeClass(Map<ClassifierInstance, Map<Property, List<ClassifierInstance>>> mapping, Class composite, InstanceSpecification is) {
        ArrayList compositeContainers = new ArrayList();
        if (composite != null) {
            Consumer<Connector> _function = it -> this.processConnector(mapping, (Connector)it, compositeContainers);
            composite.getOwnedConnectors().forEach(_function);
            Functions.Function1 _function_1 = it -> it.getContainers().size() == 0 && is.getName().equals(it.getName());
            ClassifierInstance compositeObject = (ClassifierInstance)IterableExtensions.head((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.filter(this.objects, (Functions.Function1)_function_1)));
            Consumer<Property> _function_2 = it -> this.processCompositePart(mapping, compositeObject, (Property)it, compositeContainers);
            composite.getParts().forEach(_function_2);
            Consumer<Property> _function_3 = it -> this.collectAllProperties(mapping, (Property)it, compositeContainers);
            composite.getParts().forEach(_function_3);
        }
    }

    private void collectAllProperties(Map<ClassifierInstance, Map<Property, List<ClassifierInstance>>> mapping, Property p, List<PartMultiplicity> containers) {
        int _lower = p.getLower();
        Consumer<Integer> _function = it -> {
            ArrayList<PartMultiplicity> pContainers = new ArrayList<PartMultiplicity>();
            pContainers.addAll(containers);
            PartMultiplicity _partMultiplicity = new PartMultiplicity(p, (int)it);
            pContainers.add(_partMultiplicity);
            Type _type = p.getType();
            Consumer<Connector> _function_1 = it_1 -> this.processConnector(mapping, (Connector)it_1, (List<PartMultiplicity>)pContainers);
            ((Class)_type).getOwnedConnectors().forEach(_function_1);
            Functions.Function1 _function_2 = it_1 -> this.compareToContainers((ClassifierInstance)it_1, (List<PartMultiplicity>)pContainers);
            ClassifierInstance pObject = (ClassifierInstance)IterableExtensions.head((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.filter(this.objects, (Functions.Function1)_function_2)));
            Type _type_1 = p.getType();
            Consumer<Property> _function_3 = it_1 -> this.processCompositePart(mapping, pObject, (Property)it_1, (List<PartMultiplicity>)pContainers);
            ((Class)_type_1).getParts().forEach(_function_3);
            Type _type_2 = p.getType();
            Consumer<Property> _function_4 = it_1 -> this.collectAllProperties(mapping, (Property)it_1, (List<PartMultiplicity>)pContainers);
            ((Class)_type_2).getParts().forEach(_function_4);
        };
        new ExclusiveRange(0, _lower, true).forEach(_function);
    }

    private void processConnector(Map<ClassifierInstance, Map<Property, List<ClassifierInstance>>> mapping, Connector c, List<PartMultiplicity> containers) {
        Association association = c.getType();
        EList memberEnds = association.getMemberEnds();
        Consumer<ConnectorEnd> _function = it -> {
            ConnectableElement role = it.getRole();
            Functions.Function1 _function_1 = it_1 -> com.google.common.base.Objects.equal((Object)it_1.getType(), (Object)role.getType()) || ((Class)role.getType()).allParents().contains((Object)it_1.getType());
            Property property = (Property)IterableExtensions.head((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)memberEnds, (Functions.Function1)_function_1)));
            Functions.Function1 _function_2 = it_1 -> !com.google.common.base.Objects.equal((Object)it_1.getType(), (Object)role.getType()) && !((Class)role.getType()).allParents().contains((Object)it_1.getType());
            Property oppositeProperty = (Property)IterableExtensions.head((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)memberEnds, (Functions.Function1)_function_2)));
            Functions.Function1 _function_3 = it_1 -> com.google.common.base.Objects.equal((Object)oppositeProperty.getType(), (Object)it_1.getRole().getType()) || ((Classifier)it_1.getRole().getType()).allParents().contains((Object)oppositeProperty.getType());
            ConnectorEnd oppositeEnd = (ConnectorEnd)IterableExtensions.head((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)c.getEnds(), (Functions.Function1)_function_3)));
            List<ClassifierInstance> endObjects = this.getClassifierInstancesOfConnectorEnd((ConnectorEnd)it, containers);
            List<ClassifierInstance> oppositeEndObjects = this.getClassifierInstancesOfConnectorEnd(oppositeEnd, containers);
            AtomicInteger index = new AtomicInteger(0);
            AtomicInteger oppositeIndex = new AtomicInteger(0);
            AtomicInteger counter = new AtomicInteger(0);
            Consumer<ClassifierInstance> _function_4 = it_1 -> {
                ClassifierInstance endObject = it_1;
                Map mapEndObject = (Map)mapping.get(endObject);
                ArrayList propertyList = new ArrayList();
                int _lower = oppositeProperty.getLower();
                Consumer<Integer> _function_5 = it_2 -> {
                    boolean _greaterEqualsThan;
                    propertyList.add(oppositeEndObjects.get(oppositeIndex.get()));
                    counter.incrementAndGet();
                    int _get = counter.get();
                    int _lower_1 = property.getLower();
                    boolean bl = _greaterEqualsThan = _get >= _lower_1;
                    if (_greaterEqualsThan) {
                        counter.set(0);
                        oppositeIndex.incrementAndGet();
                    }
                };
                new ExclusiveRange(0, _lower, true).forEach(_function_5);
                mapEndObject.put(oppositeProperty, propertyList);
                index.incrementAndGet();
            };
            endObjects.forEach(_function_4);
        };
        c.getEnds().forEach(_function);
    }

    private void processCompositePart(Map<ClassifierInstance, Map<Property, List<ClassifierInstance>>> mapping, ClassifierInstance ownerObject, Property part, List<PartMultiplicity> ownerContainers) {
        ArrayList propertyOwner = new ArrayList();
        int _lower = part.getLower();
        Consumer<Integer> _function = it -> {
            ArrayList<PartMultiplicity> partContainers = new ArrayList<PartMultiplicity>();
            partContainers.addAll(ownerContainers);
            PartMultiplicity _partMultiplicity = new PartMultiplicity(part, (int)it);
            partContainers.add(_partMultiplicity);
            Functions.Function1 _function_1 = it_1 -> this.compareToContainers((ClassifierInstance)it_1, (List<PartMultiplicity>)partContainers);
            ClassifierInstance partObject = (ClassifierInstance)IterableExtensions.head((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.filter(this.objects, (Functions.Function1)_function_1)));
            propertyOwner.add(partObject);
        };
        new ExclusiveRange(0, _lower, true).forEach(_function);
        Map<Property, List<ClassifierInstance>> mapOwnerObject = mapping.get(ownerObject);
        mapOwnerObject.put(part, propertyOwner);
    }

    private List<ClassifierInstance> getClassifierInstancesOfConnectorEnd(ConnectorEnd ce, List<PartMultiplicity> containers) {
        boolean _tripleNotEquals;
        ArrayList<ClassifierInstance> _xblockexpression = null;
        ArrayList<ClassifierInstance> list = new ArrayList<ClassifierInstance>();
        ArrayList<List<PartMultiplicity>> partWithPortContainers = new ArrayList<List<PartMultiplicity>>();
        ArrayList endContainers = new ArrayList();
        Property _partWithPort = ce.getPartWithPort();
        boolean bl = _tripleNotEquals = _partWithPort != null;
        if (_tripleNotEquals) {
            int _lower = ce.getPartWithPort().getLower();
            Consumer<Integer> _function = it -> {
                ArrayList<PartMultiplicity> thisContainers = new ArrayList<PartMultiplicity>();
                thisContainers.addAll(containers);
                Property _partWithPort_1 = ce.getPartWithPort();
                PartMultiplicity _partMultiplicity = new PartMultiplicity(_partWithPort_1, (int)it);
                thisContainers.add(_partMultiplicity);
                partWithPortContainers.add(thisContainers);
            };
            new ExclusiveRange(0, _lower, true).forEach(_function);
        } else {
            partWithPortContainers.add(containers);
        }
        Consumer<List> _function_1 = it -> {
            List pContainers = it;
            ConnectableElement _role = ce.getRole();
            Property role = (Property)_role;
            int _lower_1 = role.getLower();
            Consumer<Integer> _function_2 = it_1 -> {
                ArrayList<PartMultiplicity> thisContainers = new ArrayList<PartMultiplicity>();
                thisContainers.addAll(pContainers);
                PartMultiplicity _partMultiplicity = new PartMultiplicity(role, (int)it_1);
                thisContainers.add(_partMultiplicity);
                endContainers.add(thisContainers);
            };
            new ExclusiveRange(0, _lower_1, true).forEach(_function_2);
        };
        partWithPortContainers.forEach(_function_1);
        Consumer<List> _function_2 = it -> {
            List thisContainers = it;
            Functions.Function1 _function_3 = it_1 -> this.compareToContainers((ClassifierInstance)it_1, thisContainers);
            list.addAll(IterableExtensions.toList((Iterable)IterableExtensions.filter(this.objects, (Functions.Function1)_function_3)));
        };
        endContainers.forEach(_function_2);
        _xblockexpression = list;
        return _xblockexpression;
    }

    private boolean compareToContainers(ClassifierInstance e, List<PartMultiplicity> containers) {
        boolean _xblockexpression = false;
        if (e == null || containers == null || e.getContainers() == null || e.getContainers().size() != containers.size()) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < containers.size(); ++i) {
            boolean _not;
            boolean _fieldsEqual = PartMultiplicity.fieldsEqual(e.getContainers().get(i), containers.get(i));
            boolean bl = _not = !_fieldsEqual;
            if (!_not) continue;
            result = false;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static String getPeersTypeName(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = e.getName();
        _builder.append(_name);
        _builder.append("_peers");
        return _builder.toString();
    }

    private Set<Property> getPeers(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> peers = new HashSet<Property>();
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> {
                Type _type = it_1.getType();
                return (Class)_type;
            };
            return IterableExtensions.toList((Iterable)ListExtensions.map((List)it.getMemberEnds(), (Functions.Function1)_function_1)).contains(e);
        };
        List associations = IterableExtensions.toList((Iterable)IterableExtensions.filter(this.associations, (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> it.getMemberEnds();
        List allMemberEnd = IterableExtensions.toList((Iterable)ListExtensions.map((List)associations, (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> {
            Type _type = it.getType();
            boolean _equals = ((Class)_type).equals(e);
            return !_equals;
        };
        Iterable endPeers = IterableExtensions.filter((Iterable)Iterables.concat((Iterable)allMemberEnd), (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = it -> it.isBehavior();
        Iterable behavioralPorts = IterableExtensions.filter((Iterable)e.getOwnedPorts(), (Functions.Function1)_function_3);
        Iterables.addAll(peers, (Iterable)endPeers);
        Iterables.addAll(peers, (Iterable)behavioralPorts);
        _xblockexpression = peers;
        return _xblockexpression;
    }

    public Set<Property> getAllPeers(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> peers = new HashSet<Property>();
        peers.addAll(this.getPeers(e));
        Consumer<Classifier> _function = it -> peers.addAll(this.getPeers((Class)it));
        e.allParents().forEach(_function);
        _xblockexpression = peers;
        return _xblockexpression;
    }

    private Set<Property> getCompositeParts(Class e) {
        Functions.Function1 _function = it -> it.isComposite();
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)e.getOwnedAttributes(), (Functions.Function1)_function));
    }

    private Set<Property> getAllCompositeParts(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> compositeParts = new HashSet<Property>();
        compositeParts.addAll(this.getCompositeParts(e));
        Consumer<Classifier> _function = it -> compositeParts.addAll(this.getCompositeParts((Class)it));
        e.allParents().forEach(_function);
        _xblockexpression = compositeParts;
        return _xblockexpression;
    }

    public HashSet<Property> getReadOnlyAttributes(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> attributes = new HashSet<Property>();
        attributes.addAll(this.getPeers(e));
        attributes.addAll(this.getCompositeParts(e));
        _xblockexpression = attributes;
        return _xblockexpression;
    }

    public HashSet<Property> getAllReadOnlyAttributes(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> attributes = new HashSet<Property>();
        attributes.addAll(this.getAllPeers(e));
        attributes.addAll(this.getAllCompositeParts(e));
        _xblockexpression = attributes;
        return _xblockexpression;
    }

    public int getNbReadOnlyAttributes(Class e) {
        boolean _notEquals;
        Integer _xblockexpression = null;
        HashSet<Property> attributes = this.getAllReadOnlyAttributes(e);
        Integer _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray(attributes, Object.class)).length;
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            Functions.Function1 _function = it -> it.getLower();
            Functions.Function2 _function_1 = (p1, p2) -> p1 + p2;
            _xifexpression = (Integer)IterableExtensions.reduce((Iterable)IterableExtensions.map(attributes, (Functions.Function1)_function), (Functions.Function2)_function_1);
        } else {
            _xifexpression = 0;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String typedefToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef struct ");
        String _name = e.getName();
        _builder.append(_name);
        _builder.append("_properties_ro ");
        String _name_1 = e.getName();
        _builder.append(_name_1);
        _builder.append("_properties_ro;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String getAbstractTypeName(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ABSTRACT_");
        String _upperCase = e.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_PROPERTIES_RO");
        return _builder.toString();
    }

    private String typeToC(Class e) {
        String _xblockexpression = null;
        HashSet<Property> attributes = this.getReadOnlyAttributes(e);
        List<Class> superClasses = UmlNavigation.getInheritanceTree((Classifier)e);
        superClasses.remove(e);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The ");
        String _name = e.getName();
        _builder.append(_name, " ");
        _builder.append("_properties_ro type used to link instances of the ");
        String _name_1 = e.getName();
        _builder.append(_name_1, " ");
        _builder.append(" class with their properties.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("struct ");
        String _name_2 = e.getName();
        _builder.append(_name_2);
        _builder.append("_properties_ro {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _abstractTypeName = this.getAbstractTypeName((Class)it);
            _builder_1.append(_abstractTypeName);
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(superClasses, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function_1 = it -> this.subfieldTypeToC((Property)it);
        String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map(attributes, (Functions.Function1)_function_1), (CharSequence)"\n");
        _builder.append(_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String abstractPeersToC(Class e) {
        boolean _notEquals;
        String _xblockexpression = null;
        HashSet<Property> attributes = this.getReadOnlyAttributes(e);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#define ");
        String _abstractTypeName = this.getAbstractTypeName(e);
        _builder.append(_abstractTypeName);
        _builder.append(" ");
        StringConcatenation _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray(attributes, Object.class)).length;
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\\");
            _xifexpression = _builder_1;
        }
        _builder.append(_xifexpression);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> this.subfieldTypeToC((Property)it);
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(attributes, (Functions.Function1)_function), (CharSequence)" \\\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String subfieldTypeToC(Property e) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        int _lower = e.getLower();
        boolean bl = _equals = _lower == 1;
        if (_equals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _name = e.getType().getName();
            _builder_1.append(_name);
            _builder_1.append("_Object * ");
            String _name_1 = e.getName();
            _builder_1.append(_name_1);
            _builder_1.append(";");
            _xifexpression = _builder_1;
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            String _name_2 = e.getType().getName();
            _builder_2.append(_name_2);
            _builder_2.append("_Object * ");
            String _name_3 = e.getName();
            _builder_2.append(_name_3);
            _builder_2.append("[");
            int _lower_1 = e.getLower();
            _builder_2.append((Object)_lower_1);
            _builder_2.append("];");
            _xifexpression = _builder_2;
        }
        _builder.append((Object)_xifexpression);
        return _builder.toString();
    }

    private String fieldTypeToC(ClassifierInstance e) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = e.getClassifier().getName();
        _builder.append(_name);
        _builder.append("_properties_ro ");
        String _instQualifiedName = e.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String fieldToC(ClassifierInstance e) {
        String _xblockexpression = null;
        Classifier _classifier = e.getClassifier();
        Class type = (Class)_classifier;
        HashSet<Property> attributes = this.getAllReadOnlyAttributes(type);
        Map<Property, List<ClassifierInstance>> mapCurrentObject = this.mapping.get(e);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".");
        String _instQualifiedName = e.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        _builder.append(" = {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> this.subfieldToC((Property)it, (List)mapCurrentObject.get(it));
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(attributes, (Functions.Function1)_function), (CharSequence)",\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String subfieldToC(Property p, List<ClassifierInstance> objects) {
        String _xblockexpression = null;
        if (objects != null && p.getLower() != objects.size()) {
            System.err.println("Error: number of properties RO is not equal to lower bound of property\n");
        }
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        if (objects == null || objects.isEmpty()) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(".");
            String _name = p.getName();
            _builder_1.append(_name);
            _builder_1.append(" = NULL");
            _xifexpression = _builder_1;
        } else {
            boolean _equals;
            StringConcatenation _xifexpression_1 = null;
            int _lower = p.getLower();
            boolean bl = _equals = _lower == 1;
            if (_equals) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append(".");
                String _name_1 = p.getName();
                _builder_2.append(_name_1);
                _builder_2.append(" = (");
                String _name_2 = p.getType().getName();
                _builder_2.append(_name_2);
                _builder_2.append("_Object *) &");
                String _objectName = Objects.getObjectName((ClassifierInstance)IterableExtensions.head(objects));
                _builder_2.append(_objectName);
                _xifexpression_1 = _builder_2;
            } else {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append(".");
                String _name_3 = p.getName();
                _builder_3.append(_name_3);
                _builder_3.append(" = {");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("\t");
                Functions.Function1 _function = it -> {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("(");
                    String _name_4 = p.getType().getName();
                    _builder_4.append(_name_4);
                    _builder_4.append("_Object *) &");
                    String _objectName_1 = Objects.getObjectName(it);
                    _builder_4.append(_objectName_1);
                    return _builder_4.toString();
                };
                String _join = IterableExtensions.join((Iterable)ListExtensions.map(objects, (Functions.Function1)_function), (CharSequence)",\n");
                _builder_3.append(_join, "\t");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("}");
                _xifexpression_1 = _builder_3;
            }
            _xifexpression = _xifexpression_1;
        }
        _builder.append((Object)_xifexpression);
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Typedef of read-only properties types for classes.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.typedefToC((Class)it);
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.classes, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("typedef struct PropertiesRO PropertiesRO;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Declaration of read-only properties types for superclasses.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.abstractPeersToC((Class)it);
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.superclasses, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Declaration of read-only properties types for classes.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.typeToC((Class)it);
        String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map(this.classes, (Functions.Function1)_function_1));
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The global read-only properties type used to make links between objects.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("struct PropertiesRO {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_2 = it -> this.fieldTypeToC((ClassifierInstance)it);
        String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map(this.objectsMAIN, (Functions.Function1)_function_2));
        _builder.append(_join_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_3 = it -> this.fieldTypeToC((ClassifierInstance)it);
        String _join_3 = IterableExtensions.join((Iterable)ListExtensions.map(this.objectsOBS, (Functions.Function1)_function_3));
        _builder.append(_join_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("extern PropertiesRO properties_ro;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Struct initializer for read-only properties.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("PropertiesRO properties_ro = {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function = it -> this.fieldToC((ClassifierInstance)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.objectsMAIN, (Functions.Function1)_function), (CharSequence)",\n");
        _builder.append(_join, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_1 = it -> this.fieldToC((ClassifierInstance)it);
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(this.objectsOBS, (Functions.Function1)_function_1), (CharSequence)",\n");
        _builder.append(_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        return _builder.toString();
    }
}

