/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.types;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import emi.serializer.memoryobjects.PropertiesRO;
import emi.serializer.memoryobjects.Transitions;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.BodyOwner;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class Types {
    private final int NB_EXECUTION_STEPS = 1000000;
    private final int NB_FIREABLES_SUM = 65535;
    private final int EVENT_POOL_SIZE = 32;
    private final int EVENT_SET_SIZE = 32;
    private final int NB_ATOMS = 10;
    private final int ATOM_SIZE = 2048;
    private final int NB_COMMANDS = 255;
    private final int COMMAND_SIZE = 65535;
    private final int CURRENT_STATE_SIZE = 4;
    private final int EVENT_SIZE = 4;
    private final int ATTRIBUTE_SIZE = 4;
    private final int NB_FIFO_LAYERS = 3;
    private final int NB_FIFO_ELEMENTS = 32;
    private final ResourceManager resourceManager;

    public Types(ResourceManager rm) {
        this.resourceManager = rm;
    }

    public int getCurrentStateMaxSize() {
        Integer _xblockexpression = null;
        Function<Resource, List> _function = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, StateMachine.class);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List stateMachines = this.resourceManager.getList(_function);
        Functions.Function1 _function_1 = it -> {
            EList _regions = it.getRegions();
            return (Region)IterableExtensions.head((Iterable)_regions);
        };
        List _map = ListExtensions.map(stateMachines, (Functions.Function1)_function_1);
        List regions = IterableExtensions.toList((Iterable)_map);
        Functions.Function1 _function_2 = it -> {
            EList _subvertices = it.getSubvertices();
            return _subvertices.size();
        };
        List _map_1 = ListExtensions.map((List)regions, (Functions.Function1)_function_2);
        _xblockexpression = (Integer)IterableExtensions.max((Iterable)_map_1);
        return _xblockexpression;
    }

    private String getIntType(int max, boolean signed) {
        String _xblockexpression = null;
        String string = null;
        string = signed ? (max <= 127 ? "int8_t  " : (max <= Short.MAX_VALUE ? "int16_t " : "int32_t ")) : (max <= 255 ? "uint8_t " : (max <= 65535 ? "uint16_t" : "uint32_t"));
        _xblockexpression = string;
        return _xblockexpression;
    }

    private int sum(Iterable<Integer> iterable) {
        int _xblockexpression = 0;
        int sum = 0;
        List list = IterableExtensions.toList(iterable);
        for (int i = 0; i < list.size(); ++i) {
            int _sum = sum;
            Integer _get = (Integer)list.get(i);
            sum = _sum + _get;
        }
        _xblockexpression = sum;
        return _xblockexpression;
    }

    private int sum(Iterator<Integer> iterator) {
        int _xblockexpression = 0;
        int sum = 0;
        while (iterator.hasNext()) {
            int _sum = sum;
            Integer _next = iterator.next();
            sum = _sum + _next;
        }
        _xblockexpression = sum;
        return _xblockexpression;
    }

    private String serializeMetamodelTypes() {
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        String _xblockexpression = null;
        Function<Resource, List> _function = it -> {
            TreeIterator _allContents = it.getAllContents();
            Iterator<Class> _filterExact = emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)_allContents, Class.class);
            return IteratorExtensions.toList(_filterExact);
        };
        List classes = this.resourceManager.getList(_function);
        Functions.Function1 _function_1 = it -> {
            EList _ownedAttributes = it.getOwnedAttributes();
            return _ownedAttributes.size();
        };
        List _map = ListExtensions.map(classes, (Functions.Function1)_function_1);
        Integer nbOwnedAttributes = (Integer)IterableExtensions.max((Iterable)_map);
        Function<Resource, List> _function_2 = it -> {
            TreeIterator _allContents = it.getAllContents();
            Functions.Function1 _function_3 = it_1 -> it_1 instanceof OpaqueBehavior || it_1 instanceof OpaqueExpression;
            Iterator _filter = IteratorExtensions.filter((Iterator)_allContents, (Functions.Function1)_function_3);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List opaques = this.resourceManager.getList(_function_2);
        int nbMaxLanguages = 0;
        int nbMaxBodies = 0;
        boolean _isEmpty = opaques.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1 _function_3 = it -> {
                EList _languages = ((BodyOwner)it).getLanguages();
                return ((Object[])Conversions.unwrapArray((Object)_languages, Object.class)).length;
            };
            List _map_1 = ListExtensions.map(opaques, (Functions.Function1)_function_3);
            Integer _max = (Integer)IterableExtensions.max((Iterable)_map_1);
            nbMaxLanguages = _max;
            Functions.Function1 _function_4 = it -> {
                EList _bodies = ((BodyOwner)it).getBodies();
                return ((Object[])Conversions.unwrapArray((Object)_bodies, Object.class)).length;
            };
            List _map_2 = ListExtensions.map(opaques, (Functions.Function1)_function_4);
            Integer _max_1 = (Integer)IterableExtensions.max((Iterable)_map_2);
            nbMaxBodies = _max_1;
        }
        Functions.Function1 _function_5 = it -> {
            List<Property> _attributesNotPeers = UmlNavigation.getAttributesNotPeers((Classifier)it);
            return ((Object[])Conversions.unwrapArray(_attributesNotPeers, Object.class)).length;
        };
        List _map_3 = ListExtensions.map(classes, (Functions.Function1)_function_5);
        Integer nbPrimitiveAttributes = (Integer)IterableExtensions.max((Iterable)_map_3);
        Function<Resource, List> _function_6 = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, StateMachine.class);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List stateMachines = this.resourceManager.getList(_function_6);
        Function<Resource, List> _function_7 = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Region.class);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List regions = this.resourceManager.getList(_function_7);
        Function<Resource, List> _function_8 = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Transition.class);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List transitions = this.resourceManager.getList(_function_8);
        Functions.Function1 _function_9 = it -> {
            EList _regions = it.getRegions();
            return _regions.size();
        };
        List _map_4 = ListExtensions.map(stateMachines, (Functions.Function1)_function_9);
        Integer nbMaxRegions = (Integer)IterableExtensions.max((Iterable)_map_4);
        int nbMaxStates = this.getCurrentStateMaxSize();
        Functions.Function1 _function_10 = it -> {
            EList _transitions = it.getTransitions();
            return _transitions.size();
        };
        List _map_5 = ListExtensions.map(regions, (Functions.Function1)_function_10);
        Integer nbMaxTransitions = (Integer)IterableExtensions.max((Iterable)_map_5);
        Functions.Function1 _function_11 = it -> {
            EList _triggers = it.getTriggers();
            return _triggers.size();
        };
        List _map_6 = ListExtensions.map(transitions, (Functions.Function1)_function_11);
        Integer nbMaxTriggers = (Integer)IterableExtensions.max((Iterable)_map_6);
        List<SignalEvent> _signalEvents = UmlNavigation.getSignalEvents(this.resourceManager);
        int nbSignalEvents = ((Object[])Conversions.unwrapArray(_signalEvents, Object.class)).length;
        Function<Resource, List> _function_12 = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Enumeration.class);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List enumerations = this.resourceManager.getList(_function_12);
        int nbMaxEnumerationLiterals = 0;
        int _size = enumerations.size();
        boolean bl2 = _notEquals = _size != 0;
        if (_notEquals) {
            Functions.Function1 _function_13 = it -> {
                EList _ownedLiterals = it.getOwnedLiterals();
                return _ownedLiterals.size();
            };
            List _map_7 = ListExtensions.map(enumerations, (Functions.Function1)_function_13);
            Integer _max_2 = (Integer)IterableExtensions.max((Iterable)_map_7);
            nbMaxEnumerationLiterals = _max_2;
        }
        Functions.Function1 _function_14 = it -> {
            EList _interfaceRealizations = it.getInterfaceRealizations();
            return _interfaceRealizations.size();
        };
        List _map_8 = ListExtensions.map(classes, (Functions.Function1)_function_14);
        Integer nbInterfaceRealizations = (Integer)IterableExtensions.max((Iterable)_map_8);
        Function<Resource, List> _function_15 = it -> {
            TreeIterator _allContents = it.getAllContents();
            Iterator<Class> _filterExact = emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)_allContents, Class.class);
            Functions.Function1 _function_16 = it_1 -> it_1.getOwnedReceptions();
            Iterator _map_9 = IteratorExtensions.map(_filterExact, (Functions.Function1)_function_16);
            return IteratorExtensions.toList((Iterator)_map_9);
        };
        List receptions = this.resourceManager.getList(_function_15);
        Function<Resource, List> _function_16 = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Interface.class);
            Functions.Function1 _function_17 = it_1 -> it_1.getOwnedReceptions();
            Iterator _map_9 = IteratorExtensions.map((Iterator)_filter, (Functions.Function1)_function_17);
            return IteratorExtensions.toList((Iterator)_map_9);
        };
        List _list = this.resourceManager.getList(_function_16);
        receptions.addAll(_list);
        Functions.Function1 _function_17 = it -> ((Object[])Conversions.unwrapArray((Object)it, Object.class)).length;
        List _map_9 = ListExtensions.map(receptions, (Functions.Function1)_function_17);
        Integer nbReceptions = (Integer)IterableExtensions.max((Iterable)_map_9);
        Function<Resource, List> _function_18 = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Connector.class);
            Functions.Function1 _function_19 = it_1 -> it_1.getEnds();
            Iterator _map_10 = IteratorExtensions.map((Iterator)_filter, (Functions.Function1)_function_19);
            return IteratorExtensions.toList((Iterator)_map_10);
        };
        List connectorEnds = this.resourceManager.getList(_function_18);
        Function<Resource, List> _function_19 = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Property.class);
            Functions.Function1 _function_20 = it_1 -> it_1.getEnds();
            Iterator _map_10 = IteratorExtensions.map((Iterator)_filter, (Functions.Function1)_function_20);
            return IteratorExtensions.toList((Iterator)_map_10);
        };
        List _list_1 = this.resourceManager.getList(_function_19);
        connectorEnds.addAll(_list_1);
        Functions.Function1 _function_20 = it -> ((Object[])Conversions.unwrapArray((Object)it, Object.class)).length;
        List _map_10 = ListExtensions.map(connectorEnds, (Functions.Function1)_function_20);
        Integer nbConnectorEnds = (Integer)IterableExtensions.max((Iterable)_map_10);
        List<Port> _ports = UmlNavigation.getPorts(this.resourceManager);
        int nbPorts = ((Object[])Conversions.unwrapArray(_ports, Object.class)).length;
        int nbParametersPerOperation = 0;
        List<Operation> operations = UmlNavigation.getOperations(this.resourceManager);
        int _size_1 = operations.size();
        boolean bl3 = _notEquals_1 = _size_1 != 0;
        if (_notEquals_1) {
            Functions.Function1 _function_21 = it -> {
                EList _ownedParameters = it.getOwnedParameters();
                return ((Object[])Conversions.unwrapArray((Object)_ownedParameters, Object.class)).length;
            };
            List _map_11 = ListExtensions.map(operations, (Functions.Function1)_function_21);
            Integer _max_3 = (Integer)IterableExtensions.max((Iterable)_map_11);
            nbParametersPerOperation = _max_3;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Types for the metamodel.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"typedef ");
        String _intType = this.getIntType(nbOwnedAttributes, false);
        _builder.append((Object)_intType, "");
        _builder.append((Object)" NbOwnedAttributes_t;\t// Number of ownedAttributes per class");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_1 = this.getIntType(nbMaxLanguages, false);
        _builder.append((Object)_intType_1, "");
        _builder.append((Object)" NbLanguages_t;\t\t\t// Number of languages in OpaqueBehaviors or OpaqueExpressions");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_2 = this.getIntType(nbMaxBodies, false);
        _builder.append((Object)_intType_2, "");
        _builder.append((Object)" NbBodies_t;\t\t\t// Number of bodies in OpaqueBehaviors or OpaqueExpressions");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_3 = this.getIntType(nbPrimitiveAttributes, false);
        _builder.append((Object)_intType_3, "");
        _builder.append((Object)" NbPrimitiveTypeProperties_t;\t// Number of primitives type properties per class");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_4 = this.getIntType(nbMaxRegions, false);
        _builder.append((Object)_intType_4, "");
        _builder.append((Object)" NbRegions_t;\t\t\t// Number of regions per state machine");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_5 = this.getIntType(nbMaxTransitions, false);
        _builder.append((Object)_intType_5, "");
        _builder.append((Object)" NbTransitions_t;\t\t// Number of transitions per state machine");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_6 = this.getIntType(nbMaxTransitions, false);
        _builder.append((Object)_intType_6, "");
        _builder.append((Object)" NbOutgoingTransitions_t;\t\t// Number of outgoing transitions per state");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_7 = this.getIntType(nbMaxTriggers, false);
        _builder.append((Object)_intType_7, "");
        _builder.append((Object)" NbTriggers_t;\t\t\t// Number of triggers per transition");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_8 = this.getIntType(nbMaxStates, true);
        _builder.append((Object)_intType_8, "");
        _builder.append((Object)" NbStates_t;\t\t\t// Number of states per state machine (signed to handle errors with -1 as error code)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_9 = this.getIntType(nbMaxEnumerationLiterals, false);
        _builder.append((Object)_intType_9, "");
        _builder.append((Object)" NbEnumerationLiteral_t; // Number of EnumerationLiterals in an Enumeration");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_10 = this.getIntType(nbSignalEvents + 1, false);
        _builder.append((Object)_intType_10, "");
        _builder.append((Object)" NbSignalEvents_t;\t\t// Number of signal events (+1 in order to reserve the maximum value for 'no signal event')");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_11 = this.getIntType(nbInterfaceRealizations, false);
        _builder.append((Object)_intType_11, "");
        _builder.append((Object)" NbInterfaceRealizations_t;\t\t\t// Number of interface realizations");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_12 = this.getIntType(nbReceptions, false);
        _builder.append((Object)_intType_12, "");
        _builder.append((Object)" NbReceptions_t;\t\t\t// Number of receptions per class or interface");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_13 = this.getIntType(nbConnectorEnds, false);
        _builder.append((Object)_intType_13, "");
        _builder.append((Object)" NbConnectorEnds_t;\t// Number of connector ends per connector or property");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_14 = this.getIntType(nbPorts + 1, false);
        _builder.append((Object)_intType_14, "");
        _builder.append((Object)" NbPorts_t;\t\t\t\t// Number of ports (+1 in order to reserve the maximum value for 'no port')");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_15 = this.getIntType(nbParametersPerOperation, false);
        _builder.append((Object)_intType_15, "");
        _builder.append((Object)" NbParametersPerOperation_t;\t\t\t\t// Number of parameters per operations");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String serializeInterpreterTypes() {
        String _xblockexpression = null;
        List<ClassifierInstance> _activeObjectsList = UmlNavigation.getActiveObjectsList(this.resourceManager);
        int nbActiveObjects = _activeObjectsList.size();
        List<ClassifierInstance> _passiveObjectsList = UmlNavigation.getPassiveObjectsList(this.resourceManager);
        int nbPassiveObjects = _passiveObjectsList.size();
        int nbObjects = nbActiveObjects + nbPassiveObjects;
        Function<Resource, Integer> _function = it -> {
            TreeIterator _allContents = it.getAllContents();
            Iterator<Class> _filterExact = emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)_allContents, Class.class);
            Functions.Function1 _function_1 = it_1 -> {
                List<Property> _primitiveAttributes = UmlNavigation.getPrimitiveAttributes(it_1);
                return _primitiveAttributes.size();
            };
            Iterator _map = IteratorExtensions.map(_filterExact, (Functions.Function1)_function_1);
            return this.sum(_map);
        };
        List<Integer> _map = this.resourceManager.map(_function);
        int nbPrimitiveAttributes = this.sum(_map);
        this.getClass();
        this.getClass();
        this.getClass();
        this.getClass();
        int storeSize = nbActiveObjects * 4 + nbActiveObjects * 4 * 32 + nbPrimitiveAttributes * 4;
        Function<Resource, List> _function_1 = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Region.class);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List regions = this.resourceManager.getList(_function_1);
        Function<Resource, List> _function_2 = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, State.class);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List states = this.resourceManager.getList(_function_2);
        Functions.Function1 _function_3 = it -> {
            EList _subvertices = it.getSubvertices();
            Iterable _filter = Iterables.filter((Iterable)_subvertices, Pseudostate.class);
            Functions.Function1 _function_4 = it_1 -> {
                PseudostateKind _kind = it_1.getKind();
                return Objects.equal((Object)_kind, (Object)PseudostateKind.JUNCTION_LITERAL);
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_4);
            return ((Object[])Conversions.unwrapArray((Object)_filter_1, Object.class)).length;
        };
        List _map_1 = ListExtensions.map(regions, (Functions.Function1)_function_3);
        Integer nbJunctions = (Integer)IterableExtensions.max((Iterable)_map_1);
        List<ClassifierInstance> parts = UmlNavigation.collectClassifierInstance(this.resourceManager);
        PropertiesRO properties = new PropertiesRO(this.resourceManager);
        Functions.Function1 _function_4 = it -> {
            Classifier _classifier = it.getClassifier();
            return properties.getNbReadOnlyAttributes((Class)_classifier);
        };
        List _map_2 = ListExtensions.map(parts, (Functions.Function1)_function_4);
        Integer nbProperties = (Integer)IterableExtensions.max((Iterable)_map_2);
        List<Class> _activeClasses = UmlNavigation.getActiveClasses(this.resourceManager);
        Functions.Function1 _function_5 = it -> {
            StateMachine _stateMachine = UmlNavigation.getStateMachine(it);
            return Transitions.getMaxTransitionLength(_stateMachine);
        };
        List _map_3 = ListExtensions.map(_activeClasses, (Functions.Function1)_function_5);
        Integer fireablesLength = (Integer)IterableExtensions.max((Iterable)_map_3);
        List<Class> _activeClasses_1 = UmlNavigation.getActiveClasses(this.resourceManager);
        Functions.Function1 _function_6 = it -> {
            StateMachine _stateMachine = UmlNavigation.getStateMachine(it);
            return Transitions.getMaxFireablesTransition(_stateMachine);
        };
        List _map_4 = ListExtensions.map(_activeClasses_1, (Functions.Function1)_function_6);
        Integer fireablesMax = (Integer)IterableExtensions.max((Iterable)_map_4);
        Functions.Function1 _function_7 = it -> {
            EList _outgoings = it.getOutgoings();
            return ((Object[])Conversions.unwrapArray((Object)_outgoings, Object.class)).length;
        };
        List _map_5 = ListExtensions.map(states, (Functions.Function1)_function_7);
        Integer nbOutgoings = (Integer)IterableExtensions.max((Iterable)_map_5);
        Functions.Function1 _function_8 = it -> it.getLower();
        List _map_6 = ListExtensions.map(parts, (Functions.Function1)_function_8);
        Integer objectMultiplicity = (Integer)IterableExtensions.max((Iterable)_map_6);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Macros for the interpreter.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"#define MAX_FIREABLE_LENGTH\t\t(");
        _builder.append((Object)fireablesLength, "");
        _builder.append((Object)")\t\t\t// Maximum number of transitions in a compound transition of the model.");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#define MAX_OUTGOINGS\t\t\t(");
        _builder.append((Object)nbOutgoings, "");
        _builder.append((Object)")\t\t\t// Maximum number of outgoings transitions of a vertex.");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Types for the interpreter.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"typedef ");
        String _intType = this.getIntType(nbActiveObjects, true);
        _builder.append((Object)_intType, "");
        _builder.append((Object)" NbActiveObjects_t;\t\t// Number of active objects (signed because NO_OBJECT_ID takes value -1)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_1 = this.getIntType(nbPassiveObjects, false);
        _builder.append((Object)_intType_1, "");
        _builder.append((Object)" NbPassiveObjects_t;\t\t// Number of passive objects");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_2 = this.getIntType(nbObjects, false);
        _builder.append((Object)_intType_2, "");
        _builder.append((Object)" NbObjects_t;\t\t// Number of objects");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef\t");
        String _intType_3 = this.getIntType(this.NB_EXECUTION_STEPS, false);
        _builder.append((Object)_intType_3, "");
        _builder.append((Object)" NbExecutionSteps_t;\t// Number of execution steps (limit)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef\t");
        this.getClass();
        String _intType_4 = this.getIntType(65535, false);
        _builder.append((Object)_intType_4, "");
        _builder.append((Object)" NbFireablesSum_t;\t\t// Number of fireable transitions in a configuration");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef\t");
        String _intType_5 = this.getIntType(fireablesMax, true);
        _builder.append((Object)_intType_5, "");
        _builder.append((Object)" NbFireables_t;\t\t\t\t// Number of fireable transitions per active object (signed because NO_TRANSITION_ID, INITIAL_TRANSITION_ID, and IMPLICIT_TRANSITION_ID take negative values)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef\t");
        String _intType_6 = this.getIntType(nbOutgoings, true);
        _builder.append((Object)_intType_6, "");
        _builder.append((Object)" NbOutgoings_t;\t\t\t// Number of outgoing transitions in the current state");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef\t");
        String _intType_7 = this.getIntType(fireablesLength, true);
        _builder.append((Object)_intType_7, "");
        _builder.append((Object)" FireablesLength_t;\t\t// Length of fireable transitions (i.e., maximum number of atomic transitions in a compound transition) (value -1 is used for the stack_index)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_8 = this.getIntType(storeSize, false);
        _builder.append((Object)_intType_8, "");
        _builder.append((Object)" StoreSize_t;\t\t\t// Size of the store");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_9 = this.getIntType(nbJunctions, false);
        _builder.append((Object)_intType_9, "");
        _builder.append((Object)" NbJunctions_t; \t// Number of junction pseudostates per active object.");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_10 = this.getIntType(nbProperties, false);
        _builder.append((Object)_intType_10, "");
        _builder.append((Object)" NbPropertiesRO_t; \t// Number of read-only properties per object.");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_11 = this.getIntType(this.NB_FIFO_LAYERS, false);
        _builder.append((Object)_intType_11, "");
        _builder.append((Object)" NbFifoLayers_t; \t// Number of layers per fifo.");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        this.getClass();
        String _intType_12 = this.getIntType(32, false);
        _builder.append((Object)_intType_12, "");
        _builder.append((Object)" NbFifoElements_t; \t// Number of elements per fifo.");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_13 = this.getIntType(objectMultiplicity, false);
        _builder.append((Object)_intType_13, "");
        _builder.append((Object)" ObjectMultiplicity_t; \t// Multiplicity of a part.");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String serializeEventPoolTypes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Types for event pools.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"typedef ");
        this.getClass();
        String _intType = this.getIntType(32, false);
        _builder.append((Object)_intType, "");
        _builder.append((Object)" NbEvents_t;\t\t\t// Number of events on event pool");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        this.getClass();
        String _intType_1 = this.getIntType(32, false);
        _builder.append((Object)_intType_1, "");
        _builder.append((Object)" EventSetSize_t;\t\t// Size of the event set (= Number of receptions)");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String serializeCheckerTypes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Types for the checker.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"typedef ");
        String _intType = this.getIntType(this.NB_ATOMS, true);
        _builder.append((Object)_intType, "");
        _builder.append((Object)" NbAtoms_t;\t\t// Number of atoms that can be checked (signed to handle errors with -1 as error code)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        String _intType_1 = this.getIntType(this.ATOM_SIZE, false);
        _builder.append((Object)_intType_1, "");
        _builder.append((Object)" AtomSize_t;\t// Size of an atom");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String serializePilotTypes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Types for the pilot.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"typedef ");
        String _intType = this.getIntType(this.NB_COMMANDS, false);
        _builder.append((Object)_intType, "");
        _builder.append((Object)" NbCommands_t;\t\t\t// Number of commands");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef ");
        this.getClass();
        String _intType_1 = this.getIntType(65535, false);
        _builder.append((Object)_intType_1, "");
        _builder.append((Object)" CommandSize_t;\t\t\t// Size of a command");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#ifndef MODELS_MODEL_TYPES_H");
        _builder.newLine();
        _builder.append((Object)"#define MODELS_MODEL_TYPES_H");
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @file types_calibration.h");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Define all data types according to the model size.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Do not modify manually.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include <stdint.h>");
        _builder.newLine();
        _builder.newLine();
        String _serializeMetamodelTypes = this.serializeMetamodelTypes();
        _builder.append((Object)_serializeMetamodelTypes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeInterpreterTypes = this.serializeInterpreterTypes();
        _builder.append((Object)_serializeInterpreterTypes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeEventPoolTypes = this.serializeEventPoolTypes();
        _builder.append((Object)_serializeEventPoolTypes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeCheckerTypes = this.serializeCheckerTypes();
        _builder.append((Object)_serializeCheckerTypes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializePilotTypes = this.serializePilotTypes();
        _builder.append((Object)_serializePilotTypes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#endif /* MODELS_MODEL_TYPES_H */");
        _builder.newLine();
        return _builder.toString();
    }
}

